/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.BaseRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;

public class UpdateRequestBuilder
extends BaseRequestBuilder<UpdateRequest, UpdateResponse> {
    public UpdateRequestBuilder(Client client) {
        super(client, new UpdateRequest());
    }

    public UpdateRequestBuilder(Client client, String index, String type, String id) {
        super(client, new UpdateRequest(index, type, id));
    }

    public UpdateRequestBuilder setIndex(String index) {
        ((UpdateRequest)this.request).index(index);
        return this;
    }

    public UpdateRequestBuilder setType(String type) {
        ((UpdateRequest)this.request).type(type);
        return this;
    }

    public UpdateRequestBuilder setId(String id) {
        ((UpdateRequest)this.request).id(id);
        return this;
    }

    public UpdateRequestBuilder setRouting(String routing) {
        ((UpdateRequest)this.request).routing(routing);
        return this;
    }

    public UpdateRequestBuilder setParent(String parent) {
        ((UpdateRequest)this.request).parent(parent);
        return this;
    }

    public UpdateRequestBuilder setScript(String script) {
        ((UpdateRequest)this.request).script(script);
        return this;
    }

    public UpdateRequestBuilder setScriptLang(String scriptLang) {
        ((UpdateRequest)this.request).scriptLang(scriptLang);
        return this;
    }

    public UpdateRequestBuilder setScriptParams(Map<String, Object> scriptParams) {
        ((UpdateRequest)this.request).scriptParams(scriptParams);
        return this;
    }

    public UpdateRequestBuilder addScriptParam(String name, Object value) {
        ((UpdateRequest)this.request).addScriptParam(name, value);
        return this;
    }

    public UpdateRequestBuilder setRetryOnConflict(int retryOnConflict) {
        ((UpdateRequest)this.request).retryOnConflict(retryOnConflict);
        return this;
    }

    public UpdateRequestBuilder setTimeout(TimeValue timeout) {
        ((UpdateRequest)this.request).timeout(timeout);
        return this;
    }

    public UpdateRequestBuilder setTimeout(String timeout) {
        ((UpdateRequest)this.request).timeout(timeout);
        return this;
    }

    public UpdateRequestBuilder setRefresh(boolean refresh) {
        ((UpdateRequest)this.request).refresh(refresh);
        return this;
    }

    public UpdateRequestBuilder setReplicationType(ReplicationType replicationType) {
        ((UpdateRequest)this.request).replicationType(replicationType);
        return this;
    }

    public UpdateRequestBuilder setConsistencyLevel(WriteConsistencyLevel consistencyLevel) {
        ((UpdateRequest)this.request).consistencyLevel(consistencyLevel);
        return this;
    }

    public UpdateRequestBuilder setPercolate(String percolate) {
        ((UpdateRequest)this.request).percolate(percolate);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<UpdateResponse> listener) {
        this.client.update((UpdateRequest)this.request, listener);
    }
}

