/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class SingleShardOperationRequest
implements ActionRequest {
    protected String index;
    private boolean threadedListener = false;
    private boolean threadedOperation = true;

    protected SingleShardOperationRequest() {
    }

    public SingleShardOperationRequest(String index) {
        this.index = index;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    SingleShardOperationRequest index(String index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    @Override
    public SingleShardOperationRequest listenerThreaded(boolean threadedListener) {
        this.threadedListener = threadedListener;
        return this;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public SingleShardOperationRequest operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
    }
}

