/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class IndexReplicationOperationRequest
implements ActionRequest {
    protected TimeValue timeout = ShardReplicationOperationRequest.DEFAULT_TIMEOUT;
    protected String index;
    private boolean threadedListener = false;
    protected ReplicationType replicationType = ReplicationType.DEFAULT;
    protected WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    public IndexReplicationOperationRequest index(String index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public IndexReplicationOperationRequest listenerThreaded(boolean threadedListener) {
        this.threadedListener = threadedListener;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index name missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.timeout = TimeValue.readTimeValue(in);
        this.index = in.readUTF();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        this.timeout.writeTo(out);
        out.writeUTF(this.index);
    }
}

