/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class NodesOperationRequest
implements ActionRequest {
    public static String[] ALL_NODES = Strings.EMPTY_ARRAY;
    private String[] nodesIds;
    private boolean listenerThreaded = false;
    private TimeValue timeout;

    protected NodesOperationRequest() {
    }

    protected NodesOperationRequest(String ... nodesIds) {
        this.nodesIds = nodesIds;
    }

    @Override
    public NodesOperationRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    public String[] nodesIds() {
        return this.nodesIds;
    }

    public NodesOperationRequest nodesIds(String ... nodesIds) {
        this.nodesIds = nodesIds;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public NodesOperationRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodesIds = new String[in.readVInt()];
        for (int i = 0; i < this.nodesIds.length; ++i) {
            this.nodesIds[i] = in.readUTF();
        }
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodesIds == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.nodesIds.length);
            for (String nodeId : this.nodesIds) {
                out.writeUTF(nodeId);
            }
        }
        if (this.timeout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        }
    }
}

