/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BroadcastOperationRequest
implements ActionRequest {
    protected String[] indices;
    private boolean listenerThreaded = false;
    private BroadcastOperationThreading operationThreading = BroadcastOperationThreading.SINGLE_THREAD;

    protected BroadcastOperationRequest() {
    }

    protected BroadcastOperationRequest(String[] indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public BroadcastOperationRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    @Override
    public BroadcastOperationRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    public BroadcastOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public BroadcastOperationRequest operationThreading(BroadcastOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return this;
    }

    public BroadcastOperationRequest operationThreading(String operationThreading) {
        return this.operationThreading(BroadcastOperationThreading.fromString(operationThreading, this.operationThreading));
    }

    protected void beforeStart() {
    }

    protected void beforeLocalFork() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeUTF(index);
            }
        }
        out.writeByte(this.operationThreading.id());
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            this.indices = Strings.EMPTY_ARRAY;
        } else {
            this.indices = new String[size];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = in.readUTF();
            }
        }
        this.operationThreading = BroadcastOperationThreading.fromId(in.readByte());
    }
}

