/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;

public class TransportSearchCache {
    private final Queue<Collection<DfsSearchResult>> cacheDfsResults = new LinkedTransferQueue<Collection<DfsSearchResult>>();
    private final Queue<Map<SearchShardTarget, QuerySearchResultProvider>> cacheQueryResults = new LinkedTransferQueue<Map<SearchShardTarget, QuerySearchResultProvider>>();
    private final Queue<Map<SearchShardTarget, FetchSearchResult>> cacheFetchResults = new LinkedTransferQueue<Map<SearchShardTarget, FetchSearchResult>>();
    private final Queue<Map<SearchShardTarget, QueryFetchSearchResult>> cacheQueryFetchResults = new LinkedTransferQueue<Map<SearchShardTarget, QueryFetchSearchResult>>();

    public Collection<DfsSearchResult> obtainDfsResults() {
        Collection<DfsSearchResult> dfsSearchResults;
        while ((dfsSearchResults = this.cacheDfsResults.poll()) == null) {
            this.cacheDfsResults.offer(new LinkedTransferQueue());
        }
        return dfsSearchResults;
    }

    public void releaseDfsResults(Collection<DfsSearchResult> dfsResults) {
        dfsResults.clear();
        this.cacheDfsResults.offer(dfsResults);
    }

    public Map<SearchShardTarget, QuerySearchResultProvider> obtainQueryResults() {
        Map<SearchShardTarget, QuerySearchResultProvider> queryResults;
        while ((queryResults = this.cacheQueryResults.poll()) == null) {
            this.cacheQueryResults.offer(ConcurrentCollections.newConcurrentMap());
        }
        return queryResults;
    }

    public void releaseQueryResults(Map<SearchShardTarget, QuerySearchResultProvider> queryResults) {
        queryResults.clear();
        this.cacheQueryResults.offer(queryResults);
    }

    public Map<SearchShardTarget, FetchSearchResult> obtainFetchResults() {
        Map<SearchShardTarget, FetchSearchResult> fetchResults;
        while ((fetchResults = this.cacheFetchResults.poll()) == null) {
            this.cacheFetchResults.offer(ConcurrentCollections.newConcurrentMap());
        }
        return fetchResults;
    }

    public void releaseFetchResults(Map<SearchShardTarget, FetchSearchResult> fetchResults) {
        fetchResults.clear();
        this.cacheFetchResults.offer(fetchResults);
    }

    public Map<SearchShardTarget, QueryFetchSearchResult> obtainQueryFetchResults() {
        Map<SearchShardTarget, QueryFetchSearchResult> fetchResults;
        while ((fetchResults = this.cacheQueryFetchResults.poll()) == null) {
            this.cacheQueryFetchResults.offer(ConcurrentCollections.newConcurrentMap());
        }
        return fetchResults;
    }

    public void releaseQueryFetchResults(Map<SearchShardTarget, QueryFetchSearchResult> fetchResults) {
        fetchResults.clear();
        this.cacheQueryFetchResults.offer(fetchResults);
    }
}

