/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportActionNodeProxy<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent {
    protected final TransportService transportService;
    private final GenericAction<Request, Response> action;
    private final TransportRequestOptions transportOptions;

    @Inject
    public TransportActionNodeProxy(Settings settings, GenericAction<Request, Response> action, TransportService transportService) {
        super(settings);
        this.action = action;
        this.transportService = transportService;
        this.transportOptions = action.transportOptions(settings);
    }

    public ActionFuture<Response> execute(DiscoveryNode node, Request request) throws ElasticSearchException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        request.listenerThreaded(false);
        this.execute(node, request, future);
        return future;
    }

    public void execute(DiscoveryNode node, Request request, ActionListener<Response> listener) {
        this.transportService.sendRequest(node, this.action.name(), (Streamable)request, this.transportOptions, new BaseTransportResponseHandler<Response>((ActionRequest)request, listener){
            final /* synthetic */ ActionRequest val$request;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$request = actionRequest;
                this.val$listener = actionListener;
            }

            @Override
            public Response newInstance() {
                return TransportActionNodeProxy.this.action.newResponse();
            }

            @Override
            public String executor() {
                if (this.val$request.listenerThreaded()) {
                    return "generic";
                }
                return "same";
            }

            @Override
            public void handleResponse(Response response) {
                this.val$listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException exp) {
                this.val$listener.onFailure(exp);
            }
        });
    }
}

