/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.XTermsFilter;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public class CustomFieldQuery
extends FieldQuery {
    private static Field multiTermQueryWrapperFilterQueryField;
    public static final ThreadLocal<Boolean> highlightFilters;

    public CustomFieldQuery(Query query, IndexReader reader, FastVectorHighlighter highlighter) throws IOException {
        this(query, reader, highlighter.isPhraseHighlight(), highlighter.isFieldMatch());
    }

    public CustomFieldQuery(Query query, IndexReader reader, boolean phraseHighlight, boolean fieldMatch) throws IOException {
        super(query, reader, phraseHighlight, fieldMatch);
        highlightFilters.remove();
    }

    @Override
    void flatten(Query sourceQuery, IndexReader reader, Collection<Query> flatQueries) throws IOException {
        if (sourceQuery instanceof DisjunctionMaxQuery) {
            DisjunctionMaxQuery dmq = (DisjunctionMaxQuery)sourceQuery;
            for (Query query : dmq) {
                this.flatten(query, reader, flatQueries);
            }
        } else if (sourceQuery instanceof SpanTermQuery) {
            TermQuery termQuery = new TermQuery(((SpanTermQuery)sourceQuery).getTerm());
            if (!flatQueries.contains(termQuery)) {
                flatQueries.add(termQuery);
            }
        } else if (sourceQuery instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)sourceQuery;
            if (constantScoreQuery.getFilter() != null) {
                this.flatten(constantScoreQuery.getFilter(), reader, flatQueries);
            } else {
                this.flatten(constantScoreQuery.getQuery(), reader, flatQueries);
            }
        } else if (sourceQuery instanceof FunctionScoreQuery) {
            this.flatten(((FunctionScoreQuery)sourceQuery).getSubQuery(), reader, flatQueries);
        } else if (sourceQuery instanceof FilteredQuery) {
            this.flatten(((FilteredQuery)sourceQuery).getQuery(), reader, flatQueries);
            this.flatten(((FilteredQuery)sourceQuery).getFilter(), reader, flatQueries);
        } else if (sourceQuery instanceof MultiPhrasePrefixQuery) {
            try {
                this.flatten(sourceQuery.rewrite(reader), reader, flatQueries);
            }
            catch (IOException e) {}
        } else if (sourceQuery instanceof FiltersFunctionScoreQuery) {
            this.flatten(((FiltersFunctionScoreQuery)sourceQuery).getSubQuery(), reader, flatQueries);
        } else {
            super.flatten(sourceQuery, reader, flatQueries);
        }
    }

    void flatten(Filter sourceFilter, IndexReader reader, Collection<Query> flatQueries) throws IOException {
        block10: {
            block12: {
                block11: {
                    block9: {
                        Boolean highlight = highlightFilters.get();
                        if (highlight == null || highlight.equals(Boolean.FALSE)) {
                            return;
                        }
                        if (!(sourceFilter instanceof TermFilter)) break block9;
                        this.flatten(new TermQuery(((TermFilter)sourceFilter).getTerm()), reader, flatQueries);
                        break block10;
                    }
                    if (!(sourceFilter instanceof XTermsFilter)) break block11;
                    XTermsFilter termsFilter = (XTermsFilter)sourceFilter;
                    for (Term term : termsFilter.getTerms()) {
                        this.flatten(new TermQuery(term), reader, flatQueries);
                    }
                    break block10;
                }
                if (!(sourceFilter instanceof MultiTermQueryWrapperFilter)) break block12;
                if (multiTermQueryWrapperFilterQueryField == null) break block10;
                try {
                    this.flatten((Query)multiTermQueryWrapperFilterQueryField.get(sourceFilter), reader, flatQueries);
                }
                catch (IllegalAccessException e) {}
                break block10;
            }
            if (sourceFilter instanceof XBooleanFilter) {
                XBooleanFilter booleanFilter = (XBooleanFilter)sourceFilter;
                if (booleanFilter.getMustFilters() != null) {
                    for (Filter filter : booleanFilter.getMustFilters()) {
                        this.flatten(filter, reader, flatQueries);
                    }
                }
                if (booleanFilter.getShouldFilters() != null) {
                    for (Filter filter : booleanFilter.getShouldFilters()) {
                        this.flatten(filter, reader, flatQueries);
                    }
                }
            }
        }
    }

    static {
        try {
            multiTermQueryWrapperFilterQueryField = MultiTermQueryWrapperFilter.class.getDeclaredField("query");
            multiTermQueryWrapperFilterQueryField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        highlightFilters = new ThreadLocal();
    }
}

