/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.OneMeasurementHistogram;
import com.yahoo.ycsb.measurements.OneMeasurementTimeSeries;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class Measurements {
    private static final String MEASUREMENT_TYPE = "measurementtype";
    private static final String MEASUREMENT_TYPE_DEFAULT = "histogram";
    static Measurements singleton = null;
    static Properties measurementproperties = null;
    HashMap<String, OneMeasurement> data = new HashMap();
    boolean histogram = true;
    private Properties _props;

    public static void setProperties(Properties props) {
        measurementproperties = props;
    }

    public static synchronized Measurements getMeasurements() {
        if (singleton == null) {
            singleton = new Measurements(measurementproperties);
        }
        return singleton;
    }

    public Measurements(Properties props) {
        this._props = props;
        this.histogram = this._props.getProperty(MEASUREMENT_TYPE, MEASUREMENT_TYPE_DEFAULT).compareTo(MEASUREMENT_TYPE_DEFAULT) == 0;
    }

    OneMeasurement constructOneMeasurement(String name) {
        if (this.histogram) {
            return new OneMeasurementHistogram(name, this._props);
        }
        return new OneMeasurementTimeSeries(name, this._props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void measure(String operation, int latency) {
        if (!this.data.containsKey(operation)) {
            Measurements measurements = this;
            synchronized (measurements) {
                if (!this.data.containsKey(operation)) {
                    this.data.put(operation, this.constructOneMeasurement(operation));
                }
            }
        }
        try {
            this.data.get(operation).measure(latency);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR: java.lang.ArrayIndexOutOfBoundsException - ignoring and continuing");
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportReturnCode(String operation, int code) {
        if (!this.data.containsKey(operation)) {
            Measurements measurements = this;
            synchronized (measurements) {
                if (!this.data.containsKey(operation)) {
                    this.data.put(operation, this.constructOneMeasurement(operation));
                }
            }
        }
        this.data.get(operation).reportReturnCode(code);
    }

    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        for (OneMeasurement measurement : this.data.values()) {
            measurement.exportMeasurements(exporter);
        }
    }

    public String getSummary() {
        String ret = "";
        for (OneMeasurement m : this.data.values()) {
            ret = ret + m.getSummary() + " ";
        }
        return ret;
    }
}

