/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.generator.IntegerGenerator;
import java.util.Random;

public class HotspotIntegerGenerator
extends IntegerGenerator {
    private final int lowerBound;
    private final int upperBound;
    private final int hotInterval;
    private final int coldInterval;
    private final double hotsetFraction;
    private final double hotOpnFraction;

    public HotspotIntegerGenerator(int lowerBound, int upperBound, double hotsetFraction, double hotOpnFraction) {
        if (hotsetFraction < 0.0 || hotsetFraction > 1.0) {
            System.err.println("Hotset fraction out of range. Setting to 0.0");
            hotsetFraction = 0.0;
        }
        if (hotOpnFraction < 0.0 || hotOpnFraction > 1.0) {
            System.err.println("Hot operation fraction out of range. Setting to 0.0");
            hotOpnFraction = 0.0;
        }
        if (lowerBound > upperBound) {
            System.err.println("Upper bound of Hotspot generator smaller than the lower bound. Swapping the values.");
            int temp = lowerBound;
            lowerBound = upperBound;
            upperBound = temp;
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.hotsetFraction = hotsetFraction;
        int interval = upperBound - lowerBound + 1;
        this.hotInterval = (int)((double)interval * hotsetFraction);
        this.coldInterval = interval - this.hotInterval;
        this.hotOpnFraction = hotOpnFraction;
    }

    @Override
    public int nextInt() {
        int value = 0;
        Random random = Utils.random();
        value = random.nextDouble() < this.hotOpnFraction ? this.lowerBound + random.nextInt(this.hotInterval) : this.lowerBound + this.hotInterval + random.nextInt(this.coldInterval);
        this.setLastInt(value);
        return value;
    }

    public long nextLong() {
        return this.nextInt();
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public double getHotsetFraction() {
        return this.hotsetFraction;
    }

    public double getHotOpnFraction() {
        return this.hotOpnFraction;
    }

    @Override
    public double mean() {
        return this.hotOpnFraction * ((double)this.lowerBound + (double)this.hotInterval / 2.0) + (1.0 - this.hotOpnFraction) * ((double)(this.lowerBound + this.hotInterval) + (double)this.coldInterval / 2.0);
    }
}

