/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;

public class ElasticSearchClient
extends DB {
    public static final String DEFAULT_CLUSTER_NAME = "es.ycsb.cluster";
    public static final String DEFAULT_INDEX_KEY = "es.ycsb";
    private Node node;
    private Client client;
    private String indexKey;

    @Override
    public void init() throws DBException {
        Properties props = this.getProperties();
        this.indexKey = props.getProperty("es.index.key", DEFAULT_INDEX_KEY);
        String clusterName = props.getProperty("cluster.name", DEFAULT_CLUSTER_NAME);
        Boolean newdb = Boolean.parseBoolean(props.getProperty("elasticsearch.newdb", "false"));
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put("node.local", "true").put("path.data", System.getProperty("java.io.tmpdir") + "/esdata").put("discovery.zen.ping.multicast.enabled", "false").put("index.mapping._id.indexed", "true").put("index.gateway.type", "none").put("gateway.type", "none").put("index.number_of_shards", "1").put("index.number_of_replicas", "0");
        settings.put(props);
        System.out.println("ElasticSearch starting node = " + settings.get("cluster.name"));
        System.out.println("ElasticSearch node data path = " + settings.get("path.data"));
        this.node = NodeBuilder.nodeBuilder().clusterName(clusterName).settings(settings).node();
        this.node.start();
        this.client = this.node.client();
        if (newdb.booleanValue()) {
            this.client.admin().indices().prepareDelete(this.indexKey).execute().actionGet();
            this.client.admin().indices().prepareCreate(this.indexKey).execute().actionGet();
        } else {
            boolean exists = this.client.admin().indices().exists(Requests.indicesExistsRequest(this.indexKey)).actionGet().isExists();
            if (!exists) {
                this.client.admin().indices().prepareCreate(this.indexKey).execute().actionGet();
            }
        }
    }

    @Override
    public void cleanup() throws DBException {
        if (!this.node.isClosed()) {
            this.client.close();
            this.node.stop();
            this.node.close();
        }
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            XContentBuilder doc = XContentFactory.jsonBuilder().startObject();
            for (Map.Entry<String, String> entry : StringByteIterator.getStringMap(values).entrySet()) {
                doc.field(entry.getKey(), entry.getValue());
            }
            doc.endObject();
            this.client.prepareIndex(this.indexKey, table, key).setSource(doc).execute().actionGet();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    public int delete(String table, String key) {
        try {
            this.client.prepareDelete(this.indexKey, table, key).execute().actionGet();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        block6: {
            try {
                GetResponse response = (GetResponse)this.client.prepareGet(this.indexKey, table, key).execute().actionGet();
                if (!response.isExists()) break block6;
                if (fields != null) {
                    for (String field : fields) {
                        result.put(field, new StringByteIterator((String)response.getSource().get(field)));
                    }
                } else {
                    for (String field : response.getSource().keySet()) {
                        result.put(field, new StringByteIterator((String)response.getSource().get(field)));
                    }
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            GetResponse response = (GetResponse)this.client.prepareGet(this.indexKey, table, key).execute().actionGet();
            if (response.isExists()) {
                for (Map.Entry<String, String> entry : StringByteIterator.getStringMap(values).entrySet()) {
                    response.getSource().put(entry.getKey(), entry.getValue());
                }
                this.client.prepareIndex(this.indexKey, table, key).setSource(response.getSource()).execute().actionGet();
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            RangeFilterBuilder filter = FilterBuilders.rangeFilter("_id").gte(startkey);
            SearchResponse response = (SearchResponse)this.client.prepareSearch(this.indexKey).setTypes(table).setQuery(QueryBuilders.matchAllQuery()).setFilter(filter).setSize(recordcount).execute().actionGet();
            for (SearchHit hit : response.getHits()) {
                HashMap<String, StringByteIterator> entry = new HashMap<String, StringByteIterator>(fields.size());
                for (String field : fields) {
                    entry.put(field, new StringByteIterator((String)hit.getSource().get(field)));
                }
                result.add(entry);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }
}

