/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.LinkedList;

public abstract class DeclarationCollector
extends Check {
    private FrameStack mFrames;

    public void beginTree(DetailAST aRootAST) {
        this.mFrames = new FrameStack();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 10: 
            case 21: {
                DetailAST nameAST = aAST.findFirstToken(58);
                this.mFrames.current().addName(nameAST.getText());
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST nameAST = aAST.findFirstToken(58);
                this.mFrames.current().addName(nameAST.getText());
                this.mFrames.enter(new ClassFrame());
                break;
            }
            case 7: {
                this.mFrames.enter(new BlockFrame());
                break;
            }
            case 8: 
            case 9: {
                this.mFrames.enter(new MethodFrame());
                break;
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.mFrames.leave();
                break;
            }
        }
    }

    protected final boolean isDeclared(String aName) {
        return null != this.mFrames.findFrame(aName);
    }

    protected final boolean isClassField(String aName) {
        return this.mFrames.findFrame(aName) instanceof ClassFrame;
    }

    private static class FrameStack {
        private final LinkedList<LexicalFrame> mFrameList = Lists.newLinkedList();

        FrameStack() {
            this.enter(new GlobalFrame());
        }

        void enter(LexicalFrame aNewFrame) {
            this.mFrameList.addFirst(aNewFrame);
        }

        void leave() {
            this.mFrameList.removeFirst();
        }

        LexicalFrame current() {
            return this.mFrameList.getFirst();
        }

        LexicalFrame findFrame(String aNameToFind) {
            for (LexicalFrame thisFrame : this.mFrameList) {
                if (!thisFrame.contains(aNameToFind)) continue;
                return thisFrame;
            }
            return null;
        }
    }

    private static class BlockFrame
    extends LexicalFrame {
        private BlockFrame() {
        }
    }

    private static class ClassFrame
    extends LexicalFrame {
        private ClassFrame() {
        }
    }

    private static class MethodFrame
    extends LexicalFrame {
        private MethodFrame() {
        }
    }

    private static class GlobalFrame
    extends LexicalFrame {
        private GlobalFrame() {
        }
    }

    private static abstract class LexicalFrame {
        private final HashSet<String> mVarNames = Sets.newHashSet();

        protected LexicalFrame() {
        }

        void addName(String aNameToAdd) {
            this.mVarNames.add(aNameToAdd);
        }

        boolean contains(String aNameToFind) {
            return this.mVarNames.contains(aNameToFind);
        }
    }
}

