/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.dynamodb.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.DeleteItemResult;
import com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.amazonaws.services.dynamodb.model.PutItemResult;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DynamoDBClient
extends DB {
    private static final int OK = 0;
    private static final int SERVER_ERROR = 1;
    private static final int CLIENT_ERROR = 2;
    private AmazonDynamoDBClient dynamoDB;
    private String primaryKeyName;
    private boolean debug = false;
    private boolean consistentRead = false;
    private String endpoint = "http://dynamodb.us-east-1.amazonaws.com";
    private int maxConnects = 50;
    private static Logger logger = Logger.getLogger(DynamoDBClient.class);

    @Override
    public void init() throws DBException {
        String debug = this.getProperties().getProperty("dynamodb.debug", null);
        if (null != debug && "true".equalsIgnoreCase(debug)) {
            logger.setLevel(Level.DEBUG);
        }
        String endpoint = this.getProperties().getProperty("dynamodb.endpoint", null);
        String credentialsFile = this.getProperties().getProperty("dynamodb.awsCredentialsFile", null);
        String primaryKey = this.getProperties().getProperty("dynamodb.primaryKey", null);
        String consistentReads = this.getProperties().getProperty("dynamodb.consistentReads", null);
        String connectMax = this.getProperties().getProperty("dynamodb.connectMax", null);
        if (null != connectMax) {
            this.maxConnects = Integer.parseInt(connectMax);
        }
        if (null != consistentReads && "true".equalsIgnoreCase(consistentReads)) {
            this.consistentRead = true;
        }
        if (null != endpoint) {
            this.endpoint = endpoint;
        }
        if (null == primaryKey || primaryKey.length() < 1) {
            String errMsg = "Missing primary key attribute name, cannot continue";
            logger.error(errMsg);
        }
        try {
            PropertiesCredentials credentials = new PropertiesCredentials(new File(credentialsFile));
            ClientConfiguration cconfig = new ClientConfiguration();
            cconfig.setMaxConnections(this.maxConnects);
            this.dynamoDB = new AmazonDynamoDBClient(credentials, cconfig);
            this.dynamoDB.setEndpoint(this.endpoint);
            this.primaryKeyName = primaryKey;
            logger.info("dynamodb connection created with " + this.endpoint);
        }
        catch (Exception e1) {
            String errMsg = "DynamoDBClient.init(): Could not initialize DynamoDB client: " + e1.getMessage();
            logger.error(errMsg);
        }
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        logger.debug("readkey: " + key + " from table: " + table);
        GetItemRequest req = new GetItemRequest(table, DynamoDBClient.createPrimaryKey(key));
        req.setAttributesToGet(fields);
        req.setConsistentRead(this.consistentRead);
        GetItemResult res = null;
        try {
            res = this.dynamoDB.getItem(req);
        }
        catch (AmazonServiceException ex) {
            logger.error(ex.getMessage());
            return 1;
        }
        catch (AmazonClientException ex) {
            logger.error(ex.getMessage());
            return 2;
        }
        if (null != res.getItem()) {
            result.putAll(this.extractResult(res.getItem()));
            logger.debug("Result: " + res.toString());
        }
        return 0;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        logger.debug("scan " + recordcount + " records from key: " + startkey + " on table: " + table);
        GetItemRequest greq = new GetItemRequest(table, DynamoDBClient.createPrimaryKey(startkey));
        greq.setAttributesToGet(fields);
        GetItemResult gres = null;
        try {
            gres = this.dynamoDB.getItem(greq);
        }
        catch (AmazonServiceException ex) {
            logger.error(ex.getMessage());
            return 1;
        }
        catch (AmazonClientException ex) {
            logger.error(ex.getMessage());
            return 2;
        }
        if (null != gres.getItem()) {
            result.add(this.extractResult(gres.getItem()));
        }
        int count = 1;
        Key startKey = DynamoDBClient.createPrimaryKey(startkey);
        ScanRequest req = new ScanRequest(table);
        req.setAttributesToGet(fields);
        while (count < recordcount) {
            req.setExclusiveStartKey(startKey);
            req.setLimit(recordcount - count);
            ScanResult res = null;
            try {
                res = this.dynamoDB.scan(req);
            }
            catch (AmazonServiceException ex) {
                logger.error(ex.getMessage());
                ex.printStackTrace();
                return 1;
            }
            catch (AmazonClientException ex) {
                logger.error(ex.getMessage());
                ex.printStackTrace();
                return 2;
            }
            count += res.getCount().intValue();
            for (Map<String, AttributeValue> items : res.getItems()) {
                result.add(this.extractResult(items));
            }
            startKey = res.getLastEvaluatedKey();
        }
        return 0;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        logger.debug("updatekey: " + key + " from table: " + table);
        HashMap<String, AttributeValueUpdate> attributes = new HashMap<String, AttributeValueUpdate>(values.size());
        for (Map.Entry<String, ByteIterator> val : values.entrySet()) {
            AttributeValue v = new AttributeValue(val.getValue().toString());
            attributes.put(val.getKey(), new AttributeValueUpdate().withValue(v).withAction("PUT"));
        }
        UpdateItemRequest req = new UpdateItemRequest(table, DynamoDBClient.createPrimaryKey(key), attributes);
        try {
            this.dynamoDB.updateItem(req);
        }
        catch (AmazonServiceException ex) {
            logger.error(ex.getMessage());
            return 1;
        }
        catch (AmazonClientException ex) {
            logger.error(ex.getMessage());
            return 2;
        }
        return 0;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        logger.debug("insertkey: " + this.primaryKeyName + "-" + key + " from table: " + table);
        Map<String, AttributeValue> attributes = DynamoDBClient.createAttributes(values);
        attributes.put(this.primaryKeyName, new AttributeValue(key));
        PutItemRequest putItemRequest = new PutItemRequest(table, attributes);
        PutItemResult res = null;
        try {
            res = this.dynamoDB.putItem(putItemRequest);
        }
        catch (AmazonServiceException ex) {
            logger.error(ex.getMessage());
            return 1;
        }
        catch (AmazonClientException ex) {
            logger.error(ex.getMessage());
            return 2;
        }
        return 0;
    }

    @Override
    public int delete(String table, String key) {
        logger.debug("deletekey: " + key + " from table: " + table);
        DeleteItemRequest req = new DeleteItemRequest(table, DynamoDBClient.createPrimaryKey(key));
        DeleteItemResult res = null;
        try {
            res = this.dynamoDB.deleteItem(req);
        }
        catch (AmazonServiceException ex) {
            logger.error(ex.getMessage());
            return 1;
        }
        catch (AmazonClientException ex) {
            logger.error(ex.getMessage());
            return 2;
        }
        return 0;
    }

    private static Map<String, AttributeValue> createAttributes(HashMap<String, ByteIterator> values) {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>(values.size() + 1);
        for (Map.Entry<String, ByteIterator> val : values.entrySet()) {
            attributes.put(val.getKey(), new AttributeValue(val.getValue().toString()));
        }
        return attributes;
    }

    private HashMap<String, ByteIterator> extractResult(Map<String, AttributeValue> item) {
        if (null == item) {
            return null;
        }
        HashMap<String, ByteIterator> rItems = new HashMap<String, ByteIterator>(item.size());
        for (Map.Entry<String, AttributeValue> attr : item.entrySet()) {
            logger.debug(String.format("Result- key: %s, value: %s", attr.getKey(), attr.getValue()));
            rItems.put(attr.getKey(), new StringByteIterator(attr.getValue().getS()));
        }
        return rItems;
    }

    private static Key createPrimaryKey(String key) {
        Key k = new Key().withHashKeyElement(new AttributeValue().withS(key));
        return k;
    }
}

