/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ByteIterator;
import java.util.HashMap;
import java.util.Map;

public class StringByteIterator
extends ByteIterator {
    String str;
    int off;

    public static void putAllAsByteIterators(Map<String, ByteIterator> out, Map<String, String> in) {
        for (String s : in.keySet()) {
            out.put(s, new StringByteIterator(in.get(s)));
        }
    }

    public static void putAllAsStrings(Map<String, String> out, Map<String, ByteIterator> in) {
        for (String s : in.keySet()) {
            out.put(s, in.get(s).toString());
        }
    }

    public static HashMap<String, ByteIterator> getByteIteratorMap(Map<String, String> m) {
        HashMap<String, ByteIterator> ret = new HashMap<String, ByteIterator>();
        for (String s : m.keySet()) {
            ret.put(s, new StringByteIterator(m.get(s)));
        }
        return ret;
    }

    public static HashMap<String, String> getStringMap(Map<String, ByteIterator> m) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String s : m.keySet()) {
            ret.put(s, m.get(s).toString());
        }
        return ret;
    }

    public StringByteIterator(String s) {
        this.str = s;
        this.off = 0;
    }

    @Override
    public boolean hasNext() {
        return this.off < this.str.length();
    }

    @Override
    public byte nextByte() {
        byte ret = (byte)this.str.charAt(this.off);
        ++this.off;
        return ret;
    }

    @Override
    public long bytesLeft() {
        return this.str.length() - this.off;
    }

    @Override
    public String toString() {
        if (this.off > 0) {
            return super.toString();
        }
        return this.str;
    }
}

