/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TThreadPoolServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private Options options_;

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport) {
        this(processor, serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport) {
        this(processorFactory, serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, new TTransportFactory(), new TTransportFactory(), protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory transportFactory, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory transportFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
        this.options_ = new Options();
        this.executorService_ = Executors.newCachedThreadPool();
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, options);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
        this.executorService_ = null;
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        this.executorService_ = new ThreadPoolExecutor(options.minWorkerThreads, options.maxWorkerThreads, 60L, TimeUnit.SECONDS, executorQueue);
        this.options_ = options;
    }

    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        this.stopped_ = false;
        while (!this.stopped_) {
            int failureCount = 0;
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                this.executorService_.execute(wp);
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.options_.stopTimeoutUnit.toMillis(this.options_.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            try {
                processor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                while (!TThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol)) {
                }
            }
            catch (TTransportException ttx) {
            }
            catch (TException tx) {
                LOGGER.error("Thrift error occurred during processing of message.", tx);
            }
            catch (Exception x) {
                LOGGER.error("Error occurred during processing of message.", x);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }

    public static class Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
    }
}

