/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.Option;

public class OptionGroup {
    private HashMap optionMap = new HashMap();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option opt) {
        this.optionMap.put(opt.getKey(), opt);
        return this;
    }

    public Collection getNames() {
        return this.optionMap.keySet();
    }

    public Collection getOptions() {
        return this.optionMap.values();
    }

    public void setSelected(Option opt) throws AlreadySelectedException {
        if (this.selected != null && !this.selected.equals(opt.getOpt())) {
            throw new AlreadySelectedException("an option from this group has already been selected: '" + this.selected + "'");
        }
        this.selected = opt.getOpt();
    }

    public String getSelected() {
        return this.selected;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Iterator iter2 = this.getOptions().iterator();
        buff.append("[");
        while (iter2.hasNext()) {
            Option option = (Option)iter2.next();
            if (option.getOpt() != null) {
                buff.append("-");
                buff.append(option.getOpt());
            } else {
                buff.append("--");
                buff.append(option.getLongOpt());
            }
            buff.append(" ");
            buff.append(option.getDescription());
            if (!iter2.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }
}

