/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;

public abstract class ReducingIterator<T1, T2>
extends AbstractIterator<T2>
implements Iterator<T2>,
Iterable<T2> {
    protected Iterator<T1> source;
    protected T1 last;

    public ReducingIterator(Iterator<T1> source) {
        this.source = source;
    }

    public abstract void reduce(T1 var1);

    protected abstract T2 getReduced();

    protected boolean isEqual(T1 o1, T1 o2) {
        return o1.equals(o2);
    }

    @Override
    protected T2 computeNext() {
        if (this.last == null && !this.source.hasNext()) {
            return (T2)this.endOfData();
        }
        boolean keyChanged = false;
        while (!keyChanged) {
            if (this.last != null) {
                this.reduce(this.last);
            }
            if (!this.source.hasNext()) {
                this.last = null;
                break;
            }
            T1 current = this.source.next();
            if (this.last != null && !this.isEqual(current, this.last)) {
                keyChanged = true;
            }
            this.last = current;
        }
        return this.getReduced();
    }

    @Override
    public Iterator<T2> iterator() {
        return this;
    }
}

