/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Function;
import java.util.Enumeration;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringMap.class);
    private final Function<K, ?> postExpireHook;
    private final NonBlockingHashMap<K, CacheableObject> cache = new NonBlockingHashMap();
    private final Timer timer;
    private static int counter = 0;

    public ExpiringMap(long expiration) {
        this(expiration, null);
    }

    public ExpiringMap(long expiration, Function<K, ?> postExpireHook) {
        this.postExpireHook = postExpireHook;
        if (expiration <= 0L) {
            throw new IllegalArgumentException("Argument specified must be a positive number");
        }
        this.timer = new Timer("EXPIRING-MAP-TIMER-" + ++counter, true);
        this.timer.schedule((TimerTask)new CacheMonitor(expiration), expiration / 2L, expiration / 2L);
    }

    public void shutdown() {
        this.timer.cancel();
    }

    public void put(K key, V value) {
        this.cache.put(key, new CacheableObject<V>(value));
    }

    public V get(K key) {
        V result = null;
        CacheableObject co = this.cache.get(key);
        if (co != null) {
            result = (V)co.getValue();
        }
        return result;
    }

    public V remove(K key) {
        CacheableObject co = this.cache.remove(key);
        V result = null;
        if (co != null) {
            result = (V)co.getValue();
        }
        return result;
    }

    public long getAge(K key) {
        long age = 0L;
        CacheableObject co = this.cache.get(key);
        if (co != null) {
            age = co.age;
        }
        return age;
    }

    public int size() {
        return this.cache.size();
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    private class CacheMonitor
    extends TimerTask {
        private final long expiration;

        CacheMonitor(long expiration) {
            this.expiration = expiration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NonBlockingHashMap nonBlockingHashMap = ExpiringMap.this.cache;
            synchronized (nonBlockingHashMap) {
                Enumeration e = ExpiringMap.this.cache.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    CacheableObject co = (CacheableObject)ExpiringMap.this.cache.get(key);
                    if (co == null || !co.isReadyToDie(this.expiration)) continue;
                    ExpiringMap.this.cache.remove(key);
                    ExpiringMap.this.postExpireHook.apply(key);
                }
            }
        }
    }

    private static class CacheableObject<T> {
        private final T value;
        private final long age;

        CacheableObject(T o) {
            this.value = o;
            this.age = System.currentTimeMillis();
        }

        T getValue() {
            return this.value;
        }

        boolean isReadyToDie(long expiration) {
            return System.currentTimeMillis() - this.age > expiration;
        }
    }
}

