/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private TServer serverEngine;

    @Override
    protected void setup() throws IOException {
        TTransportFactory outTransportFactory;
        TTransportFactory inTransportFactory;
        super.setup();
        CassandraServer cassandraServer = new CassandraServer();
        Cassandra.Processor processor = new Cassandra.Processor(cassandraServer);
        TCustomServerSocket tServerSocket = null;
        try {
            tServerSocket = new TCustomServerSocket(new InetSocketAddress(this.listenAddr, this.listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
        }
        catch (TTransportException e) {
            throw new IOException(String.format("Unable to create thrift socket to %s:%s", this.listenAddr, this.listenPort), e);
        }
        logger.info(String.format("Binding thrift service to %s:%s", this.listenAddr, this.listenPort));
        TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory(true, true, DatabaseDescriptor.getThriftMaxMessageLength());
        if (DatabaseDescriptor.isThriftFramed()) {
            int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
            inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
            logger.info("Using TFramedTransport with a max frame size of {} bytes.", tFramedTransportSize);
        } else {
            inTransportFactory = new TTransportFactory();
            outTransportFactory = new TTransportFactory();
        }
        CustomTThreadPoolServer.Options options = new CustomTThreadPoolServer.Options();
        options.minWorkerThreads = 64;
        AbstractCassandraDaemon.CleaningThreadPool executorService = new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, options.minWorkerThreads, options.maxWorkerThreads);
        this.serverEngine = new CustomTThreadPoolServer(new TProcessorFactory(processor), tServerSocket, inTransportFactory, outTransportFactory, tProtocolFactory, tProtocolFactory, options, executorService);
    }

    @Override
    public void start() {
        logger.info("Listening for thrift clients...");
        this.serverEngine.serve();
    }

    @Override
    public void stop() {
        logger.info("Cassandra shutting down...");
        this.serverEngine.stop();
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }
}

