/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler
extends AbstractWriteResponseHandler {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected final AtomicInteger responses;

    protected WriteResponseHandler(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel, String table) {
        super(writeEndpoints, hintedEndpoints, consistencyLevel);
        this.responses = new AtomicInteger(this.determineBlockFor(table));
    }

    protected WriteResponseHandler(InetAddress endpoint) {
        super(Arrays.asList(endpoint), ImmutableMultimap.builder().put(endpoint, endpoint).build(), ConsistencyLevel.ALL);
        this.responses = new AtomicInteger(1);
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel, String table) {
        return new WriteResponseHandler(writeEndpoints, hintedEndpoints, consistencyLevel, table);
    }

    public static IWriteResponseHandler create(InetAddress endpoint) {
        return new WriteResponseHandler(endpoint);
    }

    @Override
    public void response(Message m) {
        if (this.responses.decrementAndGet() == 0) {
            this.condition.signal();
        }
    }

    protected int determineBlockFor(String table) {
        int blockFor = 0;
        switch (this.consistencyLevel) {
            case ONE: {
                blockFor = 1;
                break;
            }
            case ANY: {
                blockFor = 1;
                break;
            }
            case QUORUM: {
                blockFor = this.writeEndpoints.size() / 2 + 1;
                break;
            }
            case ALL: {
                blockFor = this.writeEndpoints.size();
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid consistency level: " + this.consistencyLevel.toString());
            }
        }
        assert (1 <= blockFor && blockFor <= 2 * Table.open(table).getReplicationStrategy().getReplicationFactor()) : String.format("invalid response count %d for replication factor %d", blockFor, Table.open(table).getReplicationStrategy().getReplicationFactor());
        return blockFor;
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.consistencyLevel == ConsistencyLevel.ANY && this.hintedEndpoints.keySet().size() < this.responses.get()) {
            throw new UnavailableException();
        }
        int liveNodes = 0;
        for (InetAddress destination : this.hintedEndpoints.keySet()) {
            if (!this.writeEndpoints.contains(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException();
        }
    }
}

