/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.scheduler;

import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import org.apache.cassandra.config.RequestSchedulerOptions;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinScheduler
implements IRequestScheduler {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinScheduler.class);
    private final NonBlockingHashMap<String, Pair<Integer, SynchronousQueue<Thread>>> queues;
    private static boolean started = false;
    private final Semaphore taskCount;
    private final Semaphore queueSize = new Semaphore(0, false);
    private Integer defaultWeight;
    private Map<String, Integer> weights;

    public RoundRobinScheduler(RequestSchedulerOptions options) {
        assert (!started);
        this.defaultWeight = options.default_weight;
        this.weights = options.weights;
        this.taskCount = new Semaphore(options.throttle_limit);
        this.queues = new NonBlockingHashMap();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    RoundRobinScheduler.this.schedule();
                }
            }
        };
        Thread scheduler = new Thread(runnable, "REQUEST-SCHEDULER");
        scheduler.start();
        logger.info("Started the RoundRobin Request Scheduler");
        started = true;
    }

    @Override
    public void queue(Thread t, String id) {
        Pair<Integer, SynchronousQueue<Thread>> weightedQueue = this.getWeightedQueue(id);
        try {
            this.queueSize.release();
            ((SynchronousQueue)weightedQueue.right).put(t);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while queueing requests", e);
        }
    }

    @Override
    public void release() {
        this.taskCount.release();
    }

    private void schedule() {
        this.queueSize.acquireUninterruptibly();
        for (Map.Entry<String, Pair<Integer, SynchronousQueue<Thread>>> request : this.queues.entrySet()) {
            Thread t;
            int weight = (Integer)request.getValue().left;
            SynchronousQueue queue = (SynchronousQueue)request.getValue().right;
            for (int i = 0; i < weight && (t = (Thread)queue.poll()) != null; ++i) {
                this.taskCount.acquireUninterruptibly();
                this.queueSize.acquireUninterruptibly();
            }
        }
        this.queueSize.release();
    }

    private Pair<Integer, SynchronousQueue<Thread>> getWeightedQueue(String id) {
        Pair<Integer, SynchronousQueue<Thread>> weightedQueue = this.queues.get(id);
        if (weightedQueue != null) {
            return weightedQueue;
        }
        Pair<Integer, SynchronousQueue<Thread>> maybenew = new Pair<Integer, SynchronousQueue<Thread>>(this.getWeight(id), new SynchronousQueue(true));
        weightedQueue = this.queues.putIfAbsent(id, maybenew);
        if (weightedQueue == null) {
            return maybenew;
        }
        return weightedQueue;
    }

    Semaphore getTaskCount() {
        return this.taskCount;
    }

    private int getWeight(String weightingVar) {
        return this.weights != null && this.weights.containsKey(weightingVar) ? this.weights.get(weightingVar) : this.defaultWeight;
    }
}

