/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliveryTask
implements Runnable {
    private static final Logger logger_ = LoggerFactory.getLogger(MessageDeliveryTask.class);
    private Message message_;
    private final long constructionTime_ = System.currentTimeMillis();

    public MessageDeliveryTask(Message message) {
        assert (message != null);
        this.message_ = message;
    }

    @Override
    public void run() {
        StorageService.Verb verb = this.message_.getVerb();
        switch (verb) {
            case BINARY: 
            case MUTATION: 
            case READ: 
            case RANGE_SLICE: 
            case READ_REPAIR: 
            case REQUEST_RESPONSE: {
                if (System.currentTimeMillis() <= this.constructionTime_ + DatabaseDescriptor.getRpcTimeout()) break;
                MessagingService.incrementDroppedMessages(verb);
                return;
            }
        }
        IVerbHandler verbHandler = MessagingService.instance.getVerbHandler(verb);
        assert (verbHandler != null) : "unknown verb " + (Object)((Object)verb);
        verbHandler.doVerb(this.message_);
    }
}

