/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.net.Socket;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.IncomingStreamReader;
import org.apache.cassandra.streaming.StreamHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingTcpConnection
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(IncomingTcpConnection.class);
    private final DataInputStream input;
    private Socket socket;

    public IncomingTcpConnection(Socket socket) {
        assert (socket != null);
        this.socket = socket;
        try {
            this.input = new DataInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            this.close();
            throw new IOError(e);
        }
    }

    @Override
    public void run() {
        block6: {
            try {
                while (true) {
                    int size;
                    MessagingService.validateMagic(this.input.readInt());
                    int header = this.input.readInt();
                    int type = MessagingService.getBits(header, 1, 2);
                    boolean isStream = MessagingService.getBits(header, 3, 1) == 1;
                    int version = MessagingService.getBits(header, 15, 8);
                    if (isStream) {
                        size = this.input.readInt();
                        byte[] headerBytes = new byte[size];
                        this.input.readFully(headerBytes);
                        StreamHeader streamHeader = StreamHeader.serializer().deserialize(new DataInputStream(new ByteArrayInputStream(headerBytes)));
                        new IncomingStreamReader(streamHeader, this.socket.getChannel()).read();
                        continue;
                    }
                    size = this.input.readInt();
                    byte[] contentBytes = new byte[size];
                    this.input.readFully(contentBytes);
                    Message message = Message.serializer().deserialize(new DataInputStream(new ByteArrayInputStream(contentBytes)));
                    MessagingService.receive(message);
                }
            }
            catch (EOFException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("eof reading from socket; closing", e);
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("error reading from socket; closing", e);
            }
        }
        this.close();
    }

    private void close() {
        block2: {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("error closing socket", e);
            }
        }
    }
}

