/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class SimpleStrategy
extends AbstractReplicationStrategy {
    public SimpleStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(table, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        int replicas = this.getReplicationFactor();
        ArrayList<Token> tokens = metadata.sortedTokens();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter2 = TokenMetadata.ringIterator(tokens, token, false);
        while (endpoints.size() < replicas && iter2.hasNext()) {
            endpoints.add(metadata.getEndpoint(iter2.next()));
        }
        if (endpoints.size() < replicas) {
            throw new IllegalStateException(String.format("replication factor (%s) exceeds number of endpoints (%s)", replicas, endpoints.size()));
        }
        return endpoints;
    }
}

