/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cache.InstrumentedCache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.sstable.BloomFilterTracker;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableDeletingReference;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.sstable.SSTableTracker;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableReader
extends SSTable
implements Comparable<SSTableReader> {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReader.class);
    private static final int INDEX_FILE_BUFFER_BYTES = 16 * DatabaseDescriptor.getIndexInterval();
    private static final Set<Reference<SSTableReader>> finalizers = new HashSet<Reference<SSTableReader>>();
    private static final ReferenceQueue<SSTableReader> finalizerQueue = new ReferenceQueue<SSTableReader>(){
        {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        SSTableDeletingReference r;
                        try {
                            r = (SSTableDeletingReference)finalizerQueue.remove();
                            finalizers.remove(r);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            r.cleanup();
                            continue;
                        }
                        catch (IOException e) {
                            logger.error("Error deleting " + r.desc, e);
                            continue;
                        }
                        break;
                    }
                }
            };
            new Thread(runnable, "SSTABLE-DELETER").start();
        }
    };
    public final long maxDataAge;
    private SegmentedFile ifile;
    private SegmentedFile dfile;
    private IndexSummary indexSummary;
    private BloomFilter bf;
    private InstrumentedCache<Pair<Descriptor, DecoratedKey>, Long> keyCache;
    private BloomFilterTracker bloomFilterTracker = new BloomFilterTracker();
    private volatile SSTableDeletingReference phantomReference;

    public static long getApproximateKeyCount(Iterable<SSTableReader> sstables) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            int indexKeyCount = sstable.getKeySamples().size();
            count += (long)((indexKeyCount + 1) * DatabaseDescriptor.getIndexInterval());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("index size for bloom filter calc for file  : " + sstable.getFilename() + "   : " + count);
        }
        return count;
    }

    public static SSTableReader open(Descriptor desc) throws IOException {
        Set<Component> components = SSTable.componentsFor(desc);
        return SSTableReader.open(desc, components, DatabaseDescriptor.getCFMetaData(desc.ksname, desc.cfname), StorageService.getPartitioner());
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        return SSTableReader.open(descriptor, components, Collections.<DecoratedKey>emptySet(), null, metadata, partitioner);
    }

    public static SSTableReader open(Descriptor descriptor, Set<Component> components, Set<DecoratedKey> savedKeys, SSTableTracker tracker, CFMetaData metadata, IPartitioner partitioner) throws IOException {
        EstimatedHistogram columnCounts;
        EstimatedHistogram rowSizes;
        assert (partitioner != null);
        long start = System.currentTimeMillis();
        logger.info("Opening " + descriptor);
        File statsFile = new File(descriptor.filenameFor(SSTable.COMPONENT_STATS));
        if (statsFile.exists()) {
            logger.debug("Load statistics for {}", descriptor);
            DataInputStream dis = new DataInputStream(new FileInputStream(statsFile));
            rowSizes = EstimatedHistogram.serializer.deserialize(dis);
            columnCounts = EstimatedHistogram.serializer.deserialize(dis);
            dis.close();
        } else {
            logger.debug("No statistics for {}", descriptor);
            rowSizes = SSTable.defaultRowHistogram();
            columnCounts = SSTable.defaultColumnHistogram();
        }
        SSTableReader sstable = new SSTableReader(descriptor, components, metadata, partitioner, null, null, null, null, System.currentTimeMillis(), rowSizes, columnCounts);
        sstable.setTrackedBy(tracker);
        if (descriptor.hasStringsInBloomFilter) {
            sstable.load(true, savedKeys);
        } else {
            sstable.load(false, savedKeys);
            sstable.loadBloomFilter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("INDEX LOAD TIME for " + descriptor + ": " + (System.currentTimeMillis() - start) + " ms.");
        }
        if (logger.isDebugEnabled() && sstable.getKeyCache() != null) {
            logger.debug(String.format("key cache contains %s/%s keys", sstable.getKeyCache().getSize(), sstable.getKeyCache().getCapacity()));
        }
        return sstable;
    }

    static SSTableReader internalOpen(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary isummary, BloomFilter bf, long maxDataAge, EstimatedHistogram rowsize, EstimatedHistogram columncount) throws IOException {
        assert (desc != null && partitioner != null && ifile != null && dfile != null && isummary != null && bf != null);
        return new SSTableReader(desc, components, metadata, partitioner, ifile, dfile, isummary, bf, maxDataAge, rowsize, columncount);
    }

    private SSTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, IPartitioner partitioner, SegmentedFile ifile, SegmentedFile dfile, IndexSummary indexSummary, BloomFilter bloomFilter, long maxDataAge, EstimatedHistogram rowSizes, EstimatedHistogram columnCounts) throws IOException {
        super(desc, components, metadata, partitioner, rowSizes, columnCounts);
        this.maxDataAge = maxDataAge;
        this.ifile = ifile;
        this.dfile = dfile;
        this.indexSummary = indexSummary;
        this.bf = bloomFilter;
    }

    public void setTrackedBy(SSTableTracker tracker) {
        if (tracker != null) {
            this.phantomReference = new SSTableDeletingReference(tracker, this, finalizerQueue);
            finalizers.add(this.phantomReference);
            this.keyCache = tracker.getKeyCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBloomFilter() throws IOException {
        DataInputStream stream = new DataInputStream(new FileInputStream(this.descriptor.filenameFor(Component.FILTER)));
        try {
            this.bf = BloomFilter.serializer().deserialize(stream);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean recreatebloom, Set<DecoratedKey> keysToLoadInCache) throws IOException {
        boolean cacheLoading = this.keyCache != null && !keysToLoadInCache.isEmpty();
        SegmentedFile.Builder ibuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getIndexAccessMode());
        SegmentedFile.Builder dbuilder = SegmentedFile.getBuilder(DatabaseDescriptor.getDiskAccessMode());
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(this.descriptor.filenameFor(Component.PRIMARY_INDEX), "r");
        try {
            long indexPosition;
            if (this.keyCache != null && this.keyCache.getCapacity() - this.keyCache.getSize() < keysToLoadInCache.size()) {
                this.keyCache.updateCapacity(this.keyCache.getSize() + keysToLoadInCache.size());
            }
            long indexSize = input.length();
            long estimatedKeys = SSTable.estimateRowsFromIndex(input);
            this.indexSummary = new IndexSummary(estimatedKeys);
            if (recreatebloom) {
                this.bf = BloomFilter.getFilter(estimatedKeys, 15);
            }
            while ((indexPosition = input.getFilePointer()) != indexSize) {
                boolean shouldAddEntry = this.indexSummary.shouldAddEntry();
                ByteBuffer key = shouldAddEntry || cacheLoading || recreatebloom ? FBUtilities.readShortByteArray(input) : (Object)FBUtilities.skipShortByteArray(input);
                long dataPosition = input.readLong();
                if (key != null) {
                    DecoratedKey decoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, key);
                    if (recreatebloom) {
                        this.bf.add(decoratedKey.key);
                    }
                    if (shouldAddEntry) {
                        this.indexSummary.addEntry(decoratedKey, indexPosition);
                    }
                    if (cacheLoading && keysToLoadInCache.contains(decoratedKey)) {
                        this.keyCache.put(new Pair<Descriptor, DecoratedKey>(this.descriptor, decoratedKey), dataPosition);
                    }
                }
                this.indexSummary.incrementRowid();
                ibuilder.addPotentialBoundary(indexPosition);
                dbuilder.addPotentialBoundary(dataPosition);
            }
            this.indexSummary.complete();
        }
        finally {
            input.close();
        }
        this.ifile = ibuilder.complete(this.descriptor.filenameFor(Component.PRIMARY_INDEX));
        this.dfile = dbuilder.complete(this.descriptor.filenameFor(Component.DATA));
    }

    private IndexSummary.KeyPosition getIndexScanPosition(DecoratedKey decoratedKey) {
        assert (this.indexSummary.getIndexPositions() != null && this.indexSummary.getIndexPositions().size() > 0);
        int index = Collections.binarySearch(this.indexSummary.getIndexPositions(), new IndexSummary.KeyPosition(decoratedKey, -1L));
        if (index < 0) {
            int greaterThan = (index + 1) * -1;
            if (greaterThan == 0) {
                return null;
            }
            return this.indexSummary.getIndexPositions().get(greaterThan - 1);
        }
        return this.indexSummary.getIndexPositions().get(index);
    }

    public void forceFilterFailures() {
        this.bf = BloomFilter.alwaysMatchingBloomFilter();
    }

    public BloomFilter getBloomFilter() {
        return this.bf;
    }

    public InstrumentedCache getKeyCache() {
        return this.keyCache;
    }

    public long estimatedKeys() {
        return this.indexSummary.getIndexPositions().size() * DatabaseDescriptor.getIndexInterval();
    }

    public Collection<DecoratedKey> getKeySamples() {
        return Collections2.transform(this.indexSummary.getIndexPositions(), new Function<IndexSummary.KeyPosition, DecoratedKey>(){

            @Override
            public DecoratedKey apply(IndexSummary.KeyPosition kp) {
                return kp.key;
            }
        });
    }

    public List<Pair<Long, Long>> getPositionsForRanges(Collection<Range> ranges) {
        ArrayList<Pair<Long, Long>> positions = new ArrayList<Pair<Long, Long>>();
        for (AbstractBounds range : AbstractBounds.normalize(ranges)) {
            long left = this.getPosition(new DecoratedKey<Token>(range.left, null), Operator.GT);
            if (left == -1L) continue;
            long right = this.getPosition(new DecoratedKey<Token>(range.right, null), Operator.GT);
            if (right == -1L || Range.isWrapAround(range.left, range.right)) {
                right = this.length();
            }
            if (left == right) continue;
            positions.add(new Pair<Long, Long>(left, right));
        }
        return positions;
    }

    public void cacheKey(DecoratedKey key, Long info) {
        this.keyCache.put(new Pair<Descriptor, DecoratedKey>(this.descriptor, key), info);
    }

    public Long getCachedPosition(DecoratedKey key) {
        return this.getCachedPosition(new Pair<Descriptor, DecoratedKey>(this.descriptor, key));
    }

    private Long getCachedPosition(Pair<Descriptor, DecoratedKey> unifiedKey) {
        if (this.keyCache != null && this.keyCache.getCapacity() > 0) {
            return this.keyCache.get(unifiedKey);
        }
        return null;
    }

    public long getPosition(DecoratedKey decoratedKey, Operator op) {
        if (op == Operator.EQ && !this.bf.isPresent(decoratedKey.key)) {
            return -1L;
        }
        Pair<Descriptor, DecoratedKey> unifiedKey = new Pair<Descriptor, DecoratedKey>(this.descriptor, decoratedKey);
        Long cachedPosition = this.getCachedPosition(unifiedKey);
        if (cachedPosition != null) {
            return cachedPosition;
        }
        IndexSummary.KeyPosition sampledPosition = this.getIndexScanPosition(decoratedKey);
        if (sampledPosition == null) {
            if (op == Operator.EQ) {
                this.bloomFilterTracker.addFalsePositive();
            }
            return op.apply(1) >= 0 ? 0L : -1L;
        }
        Iterator<FileDataInput> segments = this.ifile.iterator(sampledPosition.indexPosition, INDEX_FILE_BUFFER_BYTES);
        while (segments.hasNext()) {
            FileDataInput input = segments.next();
            try {
                while (!input.isEOF()) {
                    DecoratedKey indexDecoratedKey = SSTableReader.decodeKey(this.partitioner, this.descriptor, FBUtilities.readShortByteArray(input));
                    long dataPosition = input.readLong();
                    int comparison = indexDecoratedKey.compareTo(decoratedKey);
                    int v = op.apply(comparison);
                    if (v == 0) {
                        if (comparison == 0 && this.keyCache != null && this.keyCache.getCapacity() > 0) {
                            if (op == Operator.EQ) {
                                this.bloomFilterTracker.addTruePositive();
                            }
                            this.keyCache.put(unifiedKey, dataPosition);
                        }
                        long l = dataPosition;
                        return l;
                    }
                    if (v >= 0) continue;
                    if (op == Operator.EQ) {
                        this.bloomFilterTracker.addFalsePositive();
                    }
                    long l = -1L;
                    return l;
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error("error closing file", e);
                }
            }
        }
        if (op == Operator.EQ) {
            this.bloomFilterTracker.addFalsePositive();
        }
        return -1L;
    }

    public long length() {
        return this.dfile.length;
    }

    public void markCompacted() {
        if (logger.isDebugEnabled()) {
            logger.debug("Marking " + this.getFilename() + " compacted");
        }
        try {
            if (!new File(this.descriptor.filenameFor(Component.COMPACTED_MARKER)).createNewFile()) {
                throw new IOException("Unable to create compaction marker");
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.phantomReference.deleteOnCleanup();
    }

    public SSTableScanner getScanner(int bufferSize) {
        return new SSTableScanner(this, bufferSize);
    }

    public SSTableScanner getScanner(int bufferSize, QueryFilter filter) {
        return new SSTableScanner(this, filter, bufferSize);
    }

    public FileDataInput getFileDataInput(DecoratedKey decoratedKey, int bufferSize) {
        long position = this.getPosition(decoratedKey, Operator.EQ);
        if (position < 0L) {
            return null;
        }
        return this.dfile.getSegment(position, bufferSize);
    }

    @Override
    public int compareTo(SSTableReader o) {
        return this.descriptor.generation - o.descriptor.generation;
    }

    public AbstractType getColumnComparator() {
        return this.metadata.comparator;
    }

    public ColumnFamily createColumnFamily() {
        return ColumnFamily.create(this.metadata);
    }

    public ICompactSerializer2<IColumn> getColumnSerializer() {
        return this.metadata.cfType == ColumnFamilyType.Standard ? Column.serializer() : SuperColumn.serializer(this.getColumnComparator());
    }

    public boolean newSince(long age) {
        return this.maxDataAge > age;
    }

    public static long readRowSize(DataInput in, Descriptor d) throws IOException {
        if (d.hasIntRowSize) {
            return in.readInt();
        }
        return in.readLong();
    }

    public void createLinks(String snapshotDirectoryPath) throws IOException {
        for (Component component : this.components) {
            File sourceFile = new File(this.descriptor.filenameFor(component));
            File targetLink = new File(snapshotDirectoryPath, sourceFile.getName());
            CLibrary.createHardLink(sourceFile, targetLink);
        }
    }

    public static DecoratedKey decodeKey(IPartitioner p, Descriptor d, ByteBuffer bytes) {
        if (d.hasEncodedKeys) {
            return p.convertFromDiskFormat(bytes);
        }
        return p.decorateKey(bytes);
    }

    public long getBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getFalsePositiveCount();
    }

    public long getRecentBloomFilterFalsePositiveCount() {
        return this.bloomFilterTracker.getRecentFalsePositiveCount();
    }

    public long getBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getTruePositiveCount();
    }

    public long getRecentBloomFilterTruePositiveCount() {
        return this.bloomFilterTracker.getRecentTruePositiveCount();
    }

    public static abstract class Operator {
        public static final Operator EQ = new Equals();
        public static final Operator GE = new GreaterThanOrEqualTo();
        public static final Operator GT = new GreaterThan();

        public abstract int apply(int var1);

        static final class GreaterThan
        extends Operator {
            GreaterThan() {
            }

            @Override
            public int apply(int comparison) {
                return comparison > 0 ? 0 : 1;
            }
        }

        static final class GreaterThanOrEqualTo
        extends Operator {
            GreaterThanOrEqualTo() {
            }

            @Override
            public int apply(int comparison) {
                return comparison >= 0 ? 0 : -comparison;
            }
        }

        static final class Equals
        extends Operator {
            Equals() {
            }

            @Override
            public int apply(int comparison) {
                return -comparison;
            }
        }
    }
}

