/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements Iterator<DecoratedKey>,
Closeable {
    private final BufferedRandomAccessFile in;
    private final Descriptor desc;

    public KeyIterator(Descriptor desc) {
        this.desc = desc;
        try {
            this.in = new BufferedRandomAccessFile(new File(desc.filenameFor(SSTable.COMPONENT_INDEX)), "r");
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    protected DecoratedKey computeNext() {
        try {
            if (this.in.isEOF()) {
                return (DecoratedKey)this.endOfData();
            }
            DecoratedKey key = SSTableReader.decodeKey(StorageService.getPartitioner(), this.desc, FBUtilities.readShortByteArray(this.in));
            this.in.readLong();
            return key;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public long getBytesRead() {
        return this.in.getFilePointer();
    }

    public long getTotalBytes() {
        try {
            return this.in.length();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

