/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;

public class ColumnFamilyRecordReader
extends RecordReader<ByteBuffer, SortedMap<ByteBuffer, IColumn>> {
    private ColumnFamilySplit split;
    private RowIterator iter;
    private Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>> currentRow;
    private SlicePredicate predicate;
    private int totalRowCount;
    private int batchRowCount;
    private String cfName;
    private String keyspace;
    private TSocket socket;
    private Cassandra.Client client;

    public void close() {
        if (this.socket != null && this.socket.isOpen()) {
            this.socket.close();
            this.socket = null;
            this.client = null;
        }
    }

    public ByteBuffer getCurrentKey() {
        return (ByteBuffer)this.currentRow.left;
    }

    public SortedMap<ByteBuffer, IColumn> getCurrentValue() {
        return (SortedMap)this.currentRow.right;
    }

    public float getProgress() {
        return (float)this.iter.rowsRead() / (float)this.totalRowCount;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = context.getConfiguration();
        this.predicate = ConfigHelper.getInputSlicePredicate(conf);
        this.totalRowCount = ConfigHelper.getInputSplitSize(conf);
        this.batchRowCount = ConfigHelper.getRangeBatchSize(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        try {
            if (this.socket != null && this.socket.isOpen()) {
                return;
            }
            String location = this.getLocation();
            this.socket = new TSocket(location, ConfigHelper.getRpcPort(conf));
            TBinaryProtocol binaryProtocol = new TBinaryProtocol(new TFramedTransport(this.socket));
            this.client = new Cassandra.Client(binaryProtocol);
            this.socket.open();
            this.client.set_keyspace(this.keyspace);
            if (ConfigHelper.getInputKeyspaceUserName(conf) != null) {
                HashMap<String, String> creds = new HashMap<String, String>();
                creds.put("username", ConfigHelper.getInputKeyspaceUserName(conf));
                creds.put("password", ConfigHelper.getInputKeyspacePassword(conf));
                AuthenticationRequest authRequest = new AuthenticationRequest(creds);
                this.client.login(authRequest);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.iter = new RowIterator();
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.iter.hasNext()) {
            return false;
        }
        this.currentRow = (Pair)this.iter.next();
        return true;
    }

    private String getLocation() {
        InetAddress[] localAddresses;
        try {
            localAddresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
        for (InetAddress address : localAddresses) {
            for (String location : this.split.getLocations()) {
                InetAddress locationAddress = null;
                try {
                    locationAddress = InetAddress.getByName(location);
                }
                catch (UnknownHostException e) {
                    throw new AssertionError((Object)e);
                }
                if (!address.equals(locationAddress)) continue;
                return location;
            }
        }
        return this.split.getLocations()[0];
    }

    private class RowIterator
    extends AbstractIterator<Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>>> {
        private List<KeySlice> rows;
        private String startToken;
        private int totalRead = 0;
        private int i = 0;
        private final AbstractType comparator;
        private final AbstractType subComparator;
        private final IPartitioner partitioner;

        private RowIterator() {
            try {
                this.partitioner = FBUtilities.newPartitioner(ColumnFamilyRecordReader.this.client.describe_partitioner());
                KsDef ks_def = ColumnFamilyRecordReader.this.client.describe_keyspace(ColumnFamilyRecordReader.this.keyspace);
                ArrayList<String> cfnames = new ArrayList<String>();
                for (CfDef cfd : ks_def.cf_defs) {
                    cfnames.add(cfd.name);
                }
                int idx = cfnames.indexOf(ColumnFamilyRecordReader.this.cfName);
                CfDef cf_def = ks_def.cf_defs.get(idx);
                this.comparator = FBUtilities.getComparator(cf_def.comparator_type);
                this.subComparator = cf_def.subcomparator_type == null ? null : FBUtilities.getComparator(cf_def.subcomparator_type);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("unable to load sub/comparator", e);
            }
            catch (TException e) {
                throw new RuntimeException("error communicating via Thrift", e);
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load keyspace " + ColumnFamilyRecordReader.this.keyspace, e);
            }
        }

        private void maybeInit() {
            if (this.rows != null && this.i >= this.rows.size()) {
                this.rows = null;
            }
            if (this.rows != null) {
                return;
            }
            if (this.startToken == null) {
                this.startToken = ColumnFamilyRecordReader.this.split.getStartToken();
            } else if (this.startToken.equals(ColumnFamilyRecordReader.this.split.getEndToken())) {
                this.rows = null;
                return;
            }
            KeyRange keyRange = new KeyRange(ColumnFamilyRecordReader.this.batchRowCount).setStart_token(this.startToken).setEnd_token(ColumnFamilyRecordReader.this.split.getEndToken());
            try {
                this.rows = ColumnFamilyRecordReader.this.client.get_range_slices(new ColumnParent(ColumnFamilyRecordReader.this.cfName), ColumnFamilyRecordReader.this.predicate, keyRange, ConsistencyLevel.ONE);
                if (this.rows.isEmpty()) {
                    this.rows = null;
                    return;
                }
                this.i = 0;
                KeySlice lastRow = this.rows.get(this.rows.size() - 1);
                ByteBuffer rowkey = lastRow.key;
                this.startToken = this.partitioner.getTokenFactory().toString(this.partitioner.getToken(rowkey));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int rowsRead() {
            return this.totalRead;
        }

        @Override
        protected Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>> computeNext() {
            this.maybeInit();
            if (this.rows == null) {
                return (Pair)this.endOfData();
            }
            ++this.totalRead;
            KeySlice ks = this.rows.get(this.i++);
            TreeMap<ByteBuffer, IColumn> map = new TreeMap<ByteBuffer, IColumn>(this.comparator);
            for (ColumnOrSuperColumn cosc : ks.columns) {
                IColumn column = this.unthriftify(cosc);
                map.put(column.name(), column);
            }
            return new Pair<ByteBuffer, SortedMap<ByteBuffer, IColumn>>(ks.key, map);
        }

        private IColumn unthriftify(ColumnOrSuperColumn cosc) {
            if (cosc.column == null) {
                return this.unthriftifySuper(cosc.super_column);
            }
            return this.unthriftifySimple(cosc.column);
        }

        private IColumn unthriftifySuper(org.apache.cassandra.thrift.SuperColumn super_column) {
            SuperColumn sc = new SuperColumn(super_column.name, this.subComparator);
            for (org.apache.cassandra.thrift.Column column : super_column.columns) {
                sc.addColumn(this.unthriftifySimple(column));
            }
            return sc;
        }

        private IColumn unthriftifySimple(org.apache.cassandra.thrift.Column column) {
            return new Column(column.name, column.value, column.timestamp);
        }
    }
}

