/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.util.Map;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointStateSerializer;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.ICompactSerializer;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class EndpointState {
    private static final ICompactSerializer<EndpointState> serializer_ = new EndpointStateSerializer();
    volatile HeartBeatState hbState_;
    final Map<ApplicationState, VersionedValue> applicationState_ = new NonBlockingHashMap<ApplicationState, VersionedValue>();
    volatile long updateTimestamp_;
    volatile boolean isAlive_;
    volatile boolean isAGossiper_;
    volatile boolean hasToken_;

    public static ICompactSerializer<EndpointState> serializer() {
        return serializer_;
    }

    EndpointState(HeartBeatState hbState) {
        this.hbState_ = hbState;
        this.updateTimestamp_ = System.currentTimeMillis();
        this.isAlive_ = true;
        this.isAGossiper_ = false;
        this.hasToken_ = false;
    }

    HeartBeatState getHeartBeatState() {
        return this.hbState_;
    }

    void setHeartBeatState(HeartBeatState hbState) {
        this.updateTimestamp();
        this.hbState_ = hbState;
    }

    public VersionedValue getApplicationState(ApplicationState key) {
        return this.applicationState_.get((Object)key);
    }

    @Deprecated
    public Map<ApplicationState, VersionedValue> getApplicationStateMap() {
        return this.applicationState_;
    }

    void addApplicationState(ApplicationState key, VersionedValue value) {
        this.applicationState_.put(key, value);
    }

    long getUpdateTimestamp() {
        return this.updateTimestamp_;
    }

    void updateTimestamp() {
        this.updateTimestamp_ = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return this.isAlive_;
    }

    void isAlive(boolean value) {
        this.isAlive_ = value;
    }

    boolean isAGossiper() {
        return this.isAGossiper_;
    }

    void isAGossiper(boolean value) {
        this.isAGossiper_ = value;
    }

    public void setHasToken(boolean value) {
        this.hasToken_ = value;
    }

    public boolean getHasToken() {
        return this.hasToken_;
    }
}

