/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static Logger logger_ = LoggerFactory.getLogger(ArrivalWindow.class);
    private double tLast_ = 0.0;
    private BoundedStatsDeque arrivalIntervals_;

    ArrivalWindow(int size) {
        this.arrivalIntervals_ = new BoundedStatsDeque(size);
    }

    synchronized void add(double value) {
        double interArrivalTime = this.tLast_ > 0.0 ? value - this.tLast_ : 500.0;
        this.tLast_ = value;
        this.arrivalIntervals_.add(interArrivalTime);
    }

    synchronized double sum() {
        return this.arrivalIntervals_.sum();
    }

    synchronized double sumOfDeviations() {
        return this.arrivalIntervals_.sumOfDeviations();
    }

    synchronized double mean() {
        return this.arrivalIntervals_.mean();
    }

    synchronized double variance() {
        return this.arrivalIntervals_.variance();
    }

    double stdev() {
        return this.arrivalIntervals_.stdev();
    }

    void clear() {
        this.arrivalIntervals_.clear();
    }

    double p(double t) {
        double mean = this.mean();
        double exponent = -1.0 * t / mean;
        return Math.pow(Math.E, exponent);
    }

    double phi(long tnow) {
        int size = this.arrivalIntervals_.size();
        double log = 0.0;
        if (size > 0) {
            double t = (double)tnow - this.tLast_;
            double probability = this.p(t);
            log = -1.0 * Math.log10(probability);
        }
        return log;
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals_.iterator(), " ");
    }
}

