/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SSTableSliceIterator;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IFilter {
    private static Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public final ByteBuffer start;
    public final ByteBuffer finish;
    public final boolean reversed;
    public final int count;

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
    }

    @Override
    public IColumnIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key, AbstractType comparator) {
        return Memtable.getSliceIterator(key, cf, this, comparator);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableSliceIterator(sstable, key, this.start, this.finish, this.reversed);
    }

    @Override
    public IColumnIterator getSSTableColumnIterator(CFMetaData metadata, FileDataInput file, DecoratedKey key) {
        return new SSTableSliceIterator(metadata, file, key, this.start, this.finish, this.reversed);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        Comparator<ByteBuffer> comparator;
        Iterator subcolumns;
        SuperColumn scFiltered = superColumn.cloneMeShallow();
        if (this.reversed) {
            ArrayList<IColumn> columnsAsList = new ArrayList<IColumn>(superColumn.getSubColumns());
            subcolumns = new ReverseListIterator(columnsAsList);
        } else {
            subcolumns = superColumn.getSubColumns().iterator();
        }
        Comparator<ByteBuffer> comparator2 = comparator = this.reversed ? superColumn.getComparator().getReverseComparator() : superColumn.getComparator();
        while (subcolumns.hasNext()) {
            IColumn column = (IColumn)subcolumns.next();
            if (comparator.compare(column.name(), this.start) < 0) continue;
            subcolumns = IteratorUtils.chainedIterator(IteratorUtils.singletonIterator(column), subcolumns);
            break;
        }
        this.collectReducedColumns(scFiltered, subcolumns, gcBefore);
        return scFiltered;
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType comparator) {
        return this.reversed ? new ReverseComparator(QueryFilter.getColumnComparator(comparator)) : QueryFilter.getColumnComparator(comparator);
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        int liveColumns = 0;
        AbstractType comparator = container.getComparator();
        while (reducedColumns.hasNext() && liveColumns < this.count) {
            IColumn column = reducedColumns.next();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("collecting %s of %s: %s", liveColumns, this.count, column.getString(comparator)));
            }
            if (this.finish.remaining() > 0 && !this.reversed && comparator.compare(column.name(), this.finish) > 0 || this.reversed && comparator.compare(column.name(), this.finish) < 0) break;
            if (column.isLive() && (!container.isMarkedForDelete() || column.mostRecentLiveChangeAt() > container.getMarkedForDeleteAt())) {
                ++liveColumns;
            }
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
    }
}

