/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMutationVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(RowMutationVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        byte[] bytes = message.getMessageBody();
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        try {
            byte[] hintedBytes;
            RowMutation rm = RowMutation.serializer().deserialize(new DataInputStream(buffer));
            if (logger_.isDebugEnabled()) {
                logger_.debug("Applying " + rm);
            }
            if ((hintedBytes = message.getHeader("HINT")) != null) {
                assert (hintedBytes.length > 0);
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(hintedBytes));
                while (dis.available() > 0) {
                    ByteBuffer addressBytes = FBUtilities.readShortByteArray(dis);
                    if (logger_.isDebugEnabled()) {
                        logger_.debug("Adding hint for " + InetAddress.getByName(ByteBufferUtil.string(addressBytes, Charsets.UTF_8)));
                    }
                    RowMutation hintedMutation = new RowMutation("system", addressBytes);
                    hintedMutation.addHints(rm);
                    hintedMutation.apply();
                }
            }
            Table.open(rm.getTable()).apply(rm, bytes, true);
            WriteResponse response = new WriteResponse(rm.getTable(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug(rm + " applied.  Sending response to " + message.getMessageId() + "@" + message.getFrom());
            }
            MessagingService.instance.sendOneWay(responseMessage, message.getFrom());
        }
        catch (IOException e) {
            logger_.error("Error in row mutation", e);
        }
    }
}

