/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutationSerializer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class RowMutation {
    private static ICompactSerializer<RowMutation> serializer_ = new RowMutationSerializer();
    public static final String HINT = "HINT";
    private String table_;
    private ByteBuffer key_;
    protected Map<Integer, ColumnFamily> modifications_ = new HashMap<Integer, ColumnFamily>();

    public static ICompactSerializer<RowMutation> serializer() {
        return serializer_;
    }

    public RowMutation(String table, ByteBuffer key) {
        this.table_ = table;
        this.key_ = key;
    }

    public RowMutation(String table, Row row) {
        this.table_ = table;
        this.key_ = row.key.key;
        this.add(row.cf);
    }

    protected RowMutation(String table, ByteBuffer key, Map<Integer, ColumnFamily> modifications) {
        this.table_ = table;
        this.key_ = key;
        this.modifications_ = modifications;
    }

    public String getTable() {
        return this.table_;
    }

    public ByteBuffer key() {
        return this.key_;
    }

    public Collection<ColumnFamily> getColumnFamilies() {
        return this.modifications_.values();
    }

    void addHints(RowMutation rm) throws IOException {
        for (ColumnFamily cf : rm.getColumnFamilies()) {
            ByteBuffer combined = HintedHandOffManager.makeCombinedName(rm.getTable(), cf.metadata().cfName);
            QueryPath path = new QueryPath("HintsColumnFamily", rm.key(), combined);
            this.add(path, FBUtilities.EMPTY_BYTE_BUFFER, System.currentTimeMillis(), cf.metadata().getGcGraceSeconds());
        }
    }

    public void add(ColumnFamily columnFamily) {
        assert (columnFamily != null);
        ColumnFamily prev = this.modifications_.put(columnFamily.id(), columnFamily);
        if (prev != null) {
            throw new IllegalArgumentException("ColumnFamily " + columnFamily + " already has modifications in this mutation: " + prev);
        }
    }

    public boolean isEmpty() {
        return this.modifications_.isEmpty();
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        Integer id = CFMetaData.getId(this.table_, path.columnFamilyName);
        ColumnFamily columnFamily = this.modifications_.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
            this.modifications_.put(id, columnFamily);
        }
        columnFamily.addColumn(path, value, timestamp, timeToLive);
    }

    public void add(QueryPath path, ByteBuffer value, long timestamp) {
        this.add(path, value, timestamp, 0);
    }

    public void delete(QueryPath path, long timestamp) {
        Integer id = CFMetaData.getId(this.table_, path.columnFamilyName);
        int localDeleteTime = (int)(System.currentTimeMillis() / 1000L);
        ColumnFamily columnFamily = this.modifications_.get(id);
        if (columnFamily == null) {
            columnFamily = ColumnFamily.create(this.table_, path.columnFamilyName);
            this.modifications_.put(id, columnFamily);
        }
        if (path.superColumnName == null && path.columnName == null) {
            columnFamily.delete(localDeleteTime, timestamp);
        } else if (path.columnName == null) {
            SuperColumn sc = new SuperColumn(path.superColumnName, columnFamily.getSubComparator());
            sc.markForDeleteAt(localDeleteTime, timestamp);
            columnFamily.addColumn(sc);
        } else {
            columnFamily.addTombstone(path, localDeleteTime, timestamp);
        }
    }

    public void apply() throws IOException {
        Table.open(this.table_).apply(this, this.getSerializedBuffer(), true);
    }

    public void applyUnsafe() throws IOException {
        Table.open(this.table_).apply(this, this.getSerializedBuffer(), false);
    }

    void applyBinary() throws IOException, ExecutionException, InterruptedException {
        Table.open(this.table_).load(this);
    }

    public Message makeRowMutationMessage() throws IOException {
        return this.makeRowMutationMessage(StorageService.Verb.MUTATION);
    }

    public Message makeRowMutationMessage(StorageService.Verb verb) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        RowMutation.serializer().serialize(this, dos);
        return new Message(FBUtilities.getLocalAddress(), verb, bos.toByteArray());
    }

    public static RowMutation getRowMutationFromMutations(String keyspace, ByteBuffer key, Map<String, List<Mutation>> cfmap) {
        RowMutation rm = new RowMutation(keyspace, key);
        for (Map.Entry<String, List<Mutation>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey();
            for (Mutation mutation : entry.getValue()) {
                if (mutation.deletion != null) {
                    RowMutation.deleteColumnOrSuperColumnToRowMutation(rm, cfName, mutation.deletion);
                    continue;
                }
                RowMutation.addColumnOrSuperColumnToRowMutation(rm, cfName, mutation.column_or_supercolumn);
            }
        }
        return rm;
    }

    public static RowMutation getRowMutation(String table, ByteBuffer key, Map<String, List<ColumnOrSuperColumn>> cfmap) {
        RowMutation rm = new RowMutation(table, key);
        for (Map.Entry<String, List<ColumnOrSuperColumn>> entry : cfmap.entrySet()) {
            String cfName = entry.getKey();
            for (ColumnOrSuperColumn cosc : entry.getValue()) {
                if (cosc.column == null) {
                    assert (cosc.super_column != null);
                    for (Column column : cosc.super_column.columns) {
                        rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp, column.ttl);
                    }
                    continue;
                }
                assert (cosc.super_column == null);
                rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp, cosc.column.ttl);
            }
        }
        return rm;
    }

    public DataOutputBuffer getSerializedBuffer() throws IOException {
        DataOutputBuffer buffer = new DataOutputBuffer();
        RowMutation.serializer().serialize(this, buffer);
        return buffer;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("RowMutation(");
        buff.append("keyspace='").append(this.table_).append('\'');
        buff.append(", key='").append(FBUtilities.bytesToHex(this.key_)).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>();
            for (Integer cfid : this.modifications_.keySet()) {
                CFMetaData cfm = DatabaseDescriptor.getCFMetaData(cfid);
                cfnames.add(cfm == null ? "-dropped-" : cfm.cfName);
            }
            buff.append(StringUtils.join(cfnames, ", "));
        } else {
            buff.append(StringUtils.join(this.modifications_.values(), ", "));
        }
        return buff.append("])").toString();
    }

    private static void addColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, ColumnOrSuperColumn cosc) {
        if (cosc.column == null) {
            for (Column column : cosc.super_column.columns) {
                rm.add(new QueryPath(cfName, cosc.super_column.name, column.name), column.value, column.timestamp, column.ttl);
            }
        } else {
            rm.add(new QueryPath(cfName, null, cosc.column.name), cosc.column.value, cosc.column.timestamp, cosc.column.ttl);
        }
    }

    private static void deleteColumnOrSuperColumnToRowMutation(RowMutation rm, String cfName, Deletion del) {
        if (del.predicate != null && del.predicate.column_names != null) {
            for (ByteBuffer c : del.predicate.column_names) {
                if (del.super_column == null && DatabaseDescriptor.getColumnFamilyType(rm.table_, cfName) == ColumnFamilyType.Super) {
                    rm.delete(new QueryPath(cfName, c), del.timestamp);
                    continue;
                }
                rm.delete(new QueryPath(cfName, del.super_column, c), del.timestamp);
            }
        } else {
            rm.delete(new QueryPath(cfName, del.super_column), del.timestamp);
        }
    }

    public RowMutation deepCopy() {
        RowMutation rm = new RowMutation(this.table_, ByteBufferUtil.clone(this.key_));
        for (Map.Entry<Integer, ColumnFamily> e : this.modifications_.entrySet()) {
            ColumnFamily cf = e.getValue().cloneMeShallow();
            for (Map.Entry<ByteBuffer, IColumn> ce : e.getValue().getColumnsMap().entrySet()) {
                cf.addColumn(ce.getValue().deepCopy());
            }
            rm.modifications_.put(e.getKey(), cf);
        }
        return rm;
    }
}

