/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;

class RangeSliceCommandSerializer
implements ICompactSerializer<RangeSliceCommand> {
    RangeSliceCommandSerializer() {
    }

    @Override
    public void serialize(RangeSliceCommand sliceCommand, DataOutputStream dos) throws IOException {
        dos.writeUTF(sliceCommand.keyspace);
        dos.writeUTF(sliceCommand.column_family);
        ByteBuffer sc = sliceCommand.super_column;
        dos.writeInt(sc == null ? 0 : sc.remaining());
        if (sc != null) {
            dos.write(sc.array(), sc.position() + sc.arrayOffset(), sc.remaining());
        }
        TSerializer ser = new TSerializer(new TBinaryProtocol.Factory());
        FBUtilities.serialize(ser, sliceCommand.predicate, dos);
        AbstractBounds.serializer().serialize(sliceCommand.range, dos);
        dos.writeInt(sliceCommand.max_keys);
    }

    @Override
    public RangeSliceCommand deserialize(DataInputStream dis) throws IOException {
        String keyspace = dis.readUTF();
        String column_family = dis.readUTF();
        int scLength = dis.readInt();
        ByteBuffer super_column = null;
        if (scLength > 0) {
            super_column = ByteBuffer.wrap(RangeSliceCommandSerializer.readBuf(scLength, dis));
        }
        TDeserializer dser = new TDeserializer(new TBinaryProtocol.Factory());
        SlicePredicate pred = new SlicePredicate();
        FBUtilities.deserialize(dser, pred, dis);
        AbstractBounds range = AbstractBounds.serializer().deserialize(dis);
        int max_keys = dis.readInt();
        return new RangeSliceCommand(keyspace, column_family, super_column, pred, range, max_keys);
    }

    static byte[] readBuf(int len, DataInputStream dis) throws IOException {
        byte[] buf = new byte[len];
        int read = 0;
        while (read < len) {
            read = dis.read(buf, read, len - read);
        }
        return buf;
    }
}

