/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.EnumMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXConfigurableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;

public class StageManager {
    private static EnumMap<Stage, ThreadPoolExecutor> stages = new EnumMap(Stage.class);
    public static final long KEEPALIVE = 60L;

    private static ThreadPoolExecutor multiThreadedStage(Stage stage, int numThreads) {
        assert (numThreads > 1) : "multi-threaded stages must have at least 2 threads";
        return new JMXEnabledThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static ThreadPoolExecutor multiThreadedConfigurableStage(Stage stage, int numThreads) {
        assert (numThreads > 1) : "multi-threaded stages must have at least 2 threads";
        return new JMXConfigurableThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    public static ThreadPoolExecutor getStage(Stage stage) {
        return stages.get((Object)stage);
    }

    public static void shutdownNow() {
        for (Stage stage : Stage.values()) {
            stages.get((Object)stage).shutdownNow();
        }
    }

    static {
        stages.put(Stage.MUTATION, StageManager.multiThreadedConfigurableStage(Stage.MUTATION, DatabaseDescriptor.getConcurrentWriters()));
        stages.put(Stage.READ, StageManager.multiThreadedConfigurableStage(Stage.READ, DatabaseDescriptor.getConcurrentReaders()));
        stages.put(Stage.REQUEST_RESPONSE, StageManager.multiThreadedStage(Stage.REQUEST_RESPONSE, Math.max(2, Runtime.getRuntime().availableProcessors())));
        stages.put(Stage.INTERNAL_RESPONSE, StageManager.multiThreadedStage(Stage.INTERNAL_RESPONSE, Math.max(2, Runtime.getRuntime().availableProcessors())));
        stages.put(Stage.STREAM, new JMXEnabledThreadPoolExecutor(Stage.STREAM));
        stages.put(Stage.GOSSIP, new JMXEnabledThreadPoolExecutor(Stage.GOSSIP));
        stages.put(Stage.ANTI_ENTROPY, new JMXEnabledThreadPoolExecutor(Stage.ANTI_ENTROPY));
        stages.put(Stage.MIGRATION, new JMXEnabledThreadPoolExecutor(Stage.MIGRATION));
        stages.put(Stage.MISC, new JMXEnabledThreadPoolExecutor(Stage.MISC));
    }
}

