/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jline.ConsoleReader;
import jline.History;
import org.apache.cassandra.cli.CliClient;
import org.apache.cassandra.cli.CliCompiler;
import org.apache.cassandra.cli.CliCompleter;
import org.apache.cassandra.cli.CliOptions;
import org.apache.cassandra.cli.CliSessionState;
import org.apache.cassandra.cli.CliUtils;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class CliMain {
    public static final String HISTORYFILE = ".cassandra.history";
    private static TTransport transport = null;
    private static Cassandra.Client thriftClient = null;
    public static CliSessionState sessionState = new CliSessionState();
    private static CliClient cliClient;
    private static CliCompleter completer;
    private static int lineNumber;

    public static void connect(String server, int port) {
        String clusterName;
        TSocket socket = new TSocket(server, port);
        if (transport != null) {
            transport.close();
        }
        transport = CliMain.sessionState.framed ? new TFramedTransport(socket) : socket;
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport, true, true);
        Cassandra.Client cassandraClient = new Cassandra.Client(binaryProtocol);
        try {
            transport.open();
        }
        catch (Exception e) {
            if (CliMain.sessionState.debug) {
                e.printStackTrace();
            }
            String error = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            throw new RuntimeException("Exception connecting to " + server + "/" + port + ". Reason: " + error + ".");
        }
        thriftClient = cassandraClient;
        cliClient = new CliClient(sessionState, thriftClient);
        if (CliMain.sessionState.keyspace != null) {
            try {
                CliMain.sessionState.keyspace = CliCompiler.getKeySpace(CliMain.sessionState.keyspace, thriftClient.describe_keyspaces());
                thriftClient.set_keyspace(CliMain.sessionState.keyspace);
                cliClient.setKeySpace(CliMain.sessionState.keyspace);
                CliMain.updateCompletor(CliUtils.getCfNamesByKeySpace(cliClient.getKSMetaData(CliMain.sessionState.keyspace)));
            }
            catch (InvalidRequestException e) {
                CliMain.sessionState.err.println("Keyspace " + CliMain.sessionState.keyspace + " not found");
                return;
            }
            catch (TException e) {
                CliMain.sessionState.err.println("Did you specify 'keyspace'?");
                return;
            }
            catch (NotFoundException e) {
                CliMain.sessionState.err.println("Keyspace " + CliMain.sessionState.keyspace + " not found");
                return;
            }
        }
        if (CliMain.sessionState.username != null && CliMain.sessionState.password != null) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", CliMain.sessionState.username);
            credentials.put("password", CliMain.sessionState.password);
            AuthenticationRequest authRequest = new AuthenticationRequest(credentials);
            try {
                thriftClient.login(authRequest);
                cliClient.setUsername(CliMain.sessionState.username);
            }
            catch (AuthenticationException e) {
                CliMain.sessionState.err.println("Exception during authentication to the cassandra node, Verify the keyspace exists, and that you are using the correct credentials.");
                return;
            }
            catch (AuthorizationException e) {
                CliMain.sessionState.err.println("You are not authorized to use keyspace: " + CliMain.sessionState.keyspace);
                return;
            }
            catch (TException e) {
                CliMain.sessionState.err.println("Login failure. Did you specify 'keyspace', 'username' and 'password'?");
                return;
            }
        }
        try {
            clusterName = thriftClient.describe_cluster_name();
        }
        catch (Exception e) {
            CliMain.sessionState.err.println("Exception retrieving information about the cassandra node, check you have connected to the thrift port.");
            if (CliMain.sessionState.debug) {
                e.printStackTrace();
            }
            return;
        }
        CliMain.sessionState.out.printf("Connected to: \"%s\" on %s/%d%n", clusterName, server, port);
    }

    public static void disconnect() {
        if (transport != null) {
            transport.close();
            transport = null;
        }
    }

    private static void printBanner() {
        CliMain.sessionState.out.println("Welcome to cassandra CLI.\n");
        CliMain.sessionState.out.println("Type 'help;' or '?' for help. Type 'quit;' or 'exit;' to quit.");
    }

    public static boolean isConnected() {
        if (thriftClient == null) {
            CliMain.sessionState.out.println("Not connected to a cassandra instance.");
            return false;
        }
        return true;
    }

    public static void updateCompletor(Set<String> candidates) {
        HashSet<String> actions = new HashSet<String>();
        for (String cf : candidates) {
            for (String cmd : completer.getKeyspaceCommands()) {
                actions.add(String.format("%s %s", cmd, cf));
            }
        }
        String[] strs = (String[])Arrays.copyOf(actions.toArray(), actions.toArray().length, String[].class);
        completer.setCandidateStrings(strs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStatement(String query) {
        try {
            cliClient.executeCLIStatement(query);
        }
        catch (Exception e) {
            String errorTemplate = sessionState.inFileMode() ? "Line " + lineNumber + " => " : "";
            String message = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            CliMain.sessionState.err.println(errorTemplate + message);
            if (CliMain.sessionState.debug) {
                e.printStackTrace(CliMain.sessionState.err);
            }
            if (CliMain.sessionState.batch || sessionState.inFileMode()) {
                System.exit(4);
            }
        }
        finally {
            ++lineNumber;
        }
    }

    public static void main(String[] args) throws IOException {
        CliOptions cliOptions = new CliOptions();
        cliOptions.processArgs(sessionState, args);
        if (CliMain.sessionState.hostName != null) {
            try {
                CliMain.connect(CliMain.sessionState.hostName, CliMain.sessionState.thriftPort);
            }
            catch (RuntimeException e) {
                CliMain.sessionState.err.println(e.getMessage());
                System.exit(-1);
            }
        }
        if (cliClient == null) {
            cliClient = new CliClient(sessionState, null);
        }
        if (sessionState.inFileMode()) {
            FileReader fileReader;
            try {
                fileReader = new FileReader(CliMain.sessionState.filename);
            }
            catch (IOException e) {
                CliMain.sessionState.err.println(e.getMessage());
                return;
            }
            CliMain.evaluateFileStatements(new BufferedReader(fileReader));
            return;
        }
        ConsoleReader reader = new ConsoleReader();
        if (!CliMain.sessionState.batch) {
            reader.addCompletor(completer);
            reader.setBellEnabled(false);
            String historyFile = System.getProperty("user.home") + File.separator + HISTORYFILE;
            try {
                History history = new History(new File(historyFile));
                reader.setHistory(history);
            }
            catch (IOException exp) {
                CliMain.sessionState.err.printf("Unable to open %s for writing %n", historyFile);
            }
        } else {
            CliMain.sessionState.out.close();
        }
        CliMain.printBanner();
        String line = "";
        String currentStatement = "";
        boolean inCompoundStatement = false;
        while (line != null) {
            String prompt = inCompoundStatement ? "...\t" : CliMain.getPrompt(cliClient);
            try {
                line = reader.readLine(prompt);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (line == null) {
                return;
            }
            if ((line = line.trim()).isEmpty()) continue;
            currentStatement = currentStatement + line;
            if (line.endsWith(";") || line.equals("?")) {
                CliMain.processStatement(currentStatement);
                currentStatement = "";
                inCompoundStatement = false;
                continue;
            }
            currentStatement = currentStatement + " ";
            inCompoundStatement = true;
        }
    }

    private static void evaluateFileStatements(BufferedReader reader) throws IOException {
        String line = "";
        String currentStatement = "";
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            currentStatement = currentStatement + line;
            if (line.endsWith(";")) {
                CliMain.processStatement(currentStatement);
                currentStatement = "";
                continue;
            }
            currentStatement = currentStatement + " ";
        }
    }

    private static String getPrompt(CliClient client) {
        return "[" + client.getUsername() + "@" + client.getKeySpace() + "] ";
    }

    static {
        completer = new CliCompleter();
        lineNumber = 1;
    }
}

