/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.io.IOException;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.specific.SpecificResponder;
import org.apache.cassandra.avro.Cassandra;
import org.apache.cassandra.avro.CassandraServer;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private Server server;

    @Override
    public void start() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Binding avro service to %s:%s", this.listenAddr, this.listenPort));
        }
        CassandraServer cassandraServer = new CassandraServer();
        SpecificResponder responder = new SpecificResponder(Cassandra.class, (Object)cassandraServer);
        logger.info("Listening for avro clients...");
        this.server = new Server(this.listenPort);
        this.server.setThreadPool(new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, 64, Integer.MAX_VALUE));
        try {
            ResponderServlet servlet = new ResponderServlet(responder);
            new Context(this.server, "/").addServlet(new ServletHolder(servlet), "/*");
            this.server.start();
        }
        catch (Exception e) {
            throw new IOException("Could not start Avro server.", e);
        }
    }

    @Override
    public void stop() {
        logger.info("Cassandra shutting down...");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Avro server did not exit cleanly.", e);
        }
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }
}

