/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.ByteBufferInputStream;
import org.apache.avro.ipc.ByteBufferOutputStream;
import org.apache.avro.ipc.HandshakeMatch;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Responder {
    private static final Logger LOG = LoggerFactory.getLogger(Responder.class);
    private static final Schema META = Schema.createMap(Schema.create(Schema.Type.BYTES));
    private static final GenericDatumReader<Map<CharSequence, ByteBuffer>> META_READER = new GenericDatumReader(META);
    private static final GenericDatumWriter<Map<CharSequence, ByteBuffer>> META_WRITER = new GenericDatumWriter(META);
    private Map<MD5, Protocol> protocols = Collections.synchronizedMap(new HashMap());
    private Protocol local;
    private MD5 localHash;
    protected List<RPCPlugin> rpcMetaPlugins;
    private SpecificDatumWriter<HandshakeResponse> handshakeWriter = new SpecificDatumWriter<HandshakeResponse>(HandshakeResponse.class);
    private SpecificDatumReader<HandshakeRequest> handshakeReader = new SpecificDatumReader<HandshakeRequest>(HandshakeRequest.class);

    protected Responder(Protocol local) {
        this.local = local;
        this.localHash = new MD5();
        this.localHash.bytes(local.getMD5());
        this.protocols.put(this.localHash, local);
        this.rpcMetaPlugins = Collections.synchronizedList(new ArrayList());
    }

    public Protocol getLocal() {
        return this.local;
    }

    public void addRPCPlugin(RPCPlugin plugin) {
        this.rpcMetaPlugins.add(plugin);
    }

    public List<ByteBuffer> respond(List<ByteBuffer> buffers) throws IOException {
        return this.respond(buffers, null);
    }

    public List<ByteBuffer> respond(List<ByteBuffer> buffers, Transceiver connection) throws IOException {
        BinaryDecoder in = DecoderFactory.defaultFactory().createBinaryDecoder(new ByteBufferInputStream(buffers), null);
        ByteBufferOutputStream bbo = new ByteBufferOutputStream();
        BinaryEncoder out = new BinaryEncoder(bbo);
        Exception error = null;
        RPCContext context = new RPCContext();
        List<ByteBuffer> payload = null;
        List<ByteBuffer> handshake = null;
        boolean wasConnected = connection != null && connection.isConnected();
        try {
            Protocol remote = this.handshake(in, out, connection);
            if (remote == null) {
                return bbo.getBufferList();
            }
            handshake = bbo.getBufferList();
            context.setRequestCallMeta(META_READER.read(null, in));
            String messageName = ((Decoder)in).readString(null).toString();
            Protocol.Message rm = remote.getMessages().get(messageName);
            if (rm == null) {
                throw new AvroRuntimeException("No such remote message: " + messageName);
            }
            Object request = this.readRequest(rm.getRequest(), in);
            context.setMessage(rm);
            for (RPCPlugin plugin : this.rpcMetaPlugins) {
                plugin.serverReceiveRequest(context);
            }
            Protocol.Message m = this.getLocal().getMessages().get(messageName);
            if (m == null) {
                throw new AvroRuntimeException("No message named " + messageName + " in " + this.getLocal());
            }
            if (m.isOneWay() != rm.isOneWay()) {
                throw new AvroRuntimeException("Not both one-way: " + messageName);
            }
            Object response = null;
            try {
                response = this.respond(m, request);
                context.setResponse(response);
            }
            catch (Exception e) {
                error = e;
                context.setError(error);
                LOG.warn("user error", e);
            }
            if (m.isOneWay() && wasConnected) {
                return null;
            }
            out.writeBoolean(error != null);
            if (error == null) {
                this.writeResponse(m.getResponse(), response, out);
            } else {
                this.writeError(m.getErrors(), error, out);
            }
        }
        catch (Exception e) {
            LOG.warn("system error", e);
            context.setError(e);
            bbo = new ByteBufferOutputStream();
            out = new BinaryEncoder(bbo);
            out.writeBoolean(true);
            this.writeError(Protocol.SYSTEM_ERRORS, new Utf8(e.toString()), out);
        }
        payload = bbo.getBufferList();
        context.setResponsePayload(payload);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverSendResponse(context);
        }
        META_WRITER.write(context.responseCallMeta(), out);
        bbo.prepend(handshake);
        bbo.append(payload);
        return bbo.getBufferList();
    }

    private Protocol handshake(Decoder in, Encoder out, Transceiver connection) throws IOException {
        if (connection != null && connection.isConnected()) {
            return connection.getRemote();
        }
        HandshakeRequest request = this.handshakeReader.read(null, in);
        Protocol remote = this.protocols.get(request.clientHash);
        if (remote == null && request.clientProtocol != null) {
            remote = Protocol.parse(((Object)request.clientProtocol).toString());
            this.protocols.put(request.clientHash, remote);
        }
        HandshakeResponse response = new HandshakeResponse();
        if (this.localHash.equals(request.serverHash)) {
            response.match = remote == null ? HandshakeMatch.NONE : HandshakeMatch.BOTH;
        } else {
            HandshakeMatch handshakeMatch = response.match = remote == null ? HandshakeMatch.NONE : HandshakeMatch.CLIENT;
        }
        if (response.match != HandshakeMatch.BOTH) {
            response.serverProtocol = new Utf8(this.local.toString());
            response.serverHash = this.localHash;
        }
        RPCContext context = new RPCContext();
        context.setRequestHandshakeMeta(request.meta);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverConnecting(context);
        }
        response.meta = context.responseHandshakeMeta();
        this.handshakeWriter.write(response, out);
        if (connection != null && response.match != HandshakeMatch.NONE) {
            connection.setRemote(remote);
        }
        return remote;
    }

    public abstract Object respond(Protocol.Message var1, Object var2) throws Exception;

    public abstract Object readRequest(Schema var1, Decoder var2) throws IOException;

    public abstract void writeResponse(Schema var1, Object var2, Encoder var3) throws IOException;

    public abstract void writeError(Schema var1, Object var2, Encoder var3) throws IOException;
}

