/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.ParsingDecoder;
import org.apache.avro.io.parsing.JsonGrammarGenerator;
import org.apache.avro.io.parsing.Parser;
import org.apache.avro.io.parsing.Symbol;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class JsonDecoder
extends ParsingDecoder
implements Parser.ActionHandler {
    private JsonParser in;
    private static JsonFactory jsonFactory = new JsonFactory();
    static final String CHARSET = "ISO-8859-1";

    JsonDecoder(Symbol root, InputStream in) throws IOException {
        super(root);
        this.init(in);
    }

    JsonDecoder(Symbol root, String in) throws IOException {
        super(root);
        this.init(in);
    }

    public JsonDecoder(Schema schema, InputStream in) throws IOException {
        this(new JsonGrammarGenerator().generate(schema), in);
    }

    public JsonDecoder(Schema schema, String in) throws IOException {
        this(new JsonGrammarGenerator().generate(schema), in);
    }

    private void advance(Symbol symbol) throws IOException {
        this.parser.processTrailingImplicitActions();
        if (this.in.getCurrentToken() == null && this.parser.depth() == 1) {
            throw new EOFException();
        }
        this.parser.advance(symbol);
    }

    @Override
    public void init(InputStream in) throws IOException {
        this.parser.reset();
        this.in = jsonFactory.createJsonParser(in);
        this.in.nextToken();
    }

    public void init(String in) throws IOException {
        this.parser.reset();
        this.in = new JsonFactory().createJsonParser(in);
        this.in.nextToken();
    }

    @Override
    public void readNull() throws IOException {
        this.advance(Symbol.NULL);
        if (this.in.getCurrentToken() != JsonToken.VALUE_NULL) {
            throw this.error("null");
        }
        this.in.nextToken();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.advance(Symbol.BOOLEAN);
        JsonToken t = this.in.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE || t == JsonToken.VALUE_FALSE) {
            this.in.nextToken();
            return t == JsonToken.VALUE_TRUE;
        }
        throw this.error("boolean");
    }

    @Override
    public int readInt() throws IOException {
        this.advance(Symbol.INT);
        if (this.in.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            int result = this.in.getIntValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("int");
    }

    @Override
    public long readLong() throws IOException {
        this.advance(Symbol.LONG);
        if (this.in.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            long result = this.in.getLongValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("long");
    }

    @Override
    public float readFloat() throws IOException {
        this.advance(Symbol.FLOAT);
        if (this.in.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            float result = this.in.getFloatValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("float");
    }

    @Override
    public double readDouble() throws IOException {
        this.advance(Symbol.DOUBLE);
        if (this.in.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            double result = this.in.getDoubleValue();
            this.in.nextToken();
            return result;
        }
        throw this.error("double");
    }

    @Override
    public Utf8 readString(Utf8 old) throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        String result = this.in.getText();
        this.in.nextToken();
        return new Utf8(result);
    }

    @Override
    public void skipString() throws IOException {
        this.advance(Symbol.STRING);
        if (this.parser.topSymbol() == Symbol.MAP_KEY_MARKER) {
            this.parser.advance(Symbol.MAP_KEY_MARKER);
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw this.error("map-key");
            }
        } else if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("string");
        }
        this.in.nextToken();
    }

    @Override
    public ByteBuffer readBytes(ByteBuffer old) throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            return ByteBuffer.wrap(result);
        }
        throw this.error("bytes");
    }

    private byte[] readByteArray() throws IOException {
        byte[] result = this.in.getText().getBytes(CHARSET);
        return result;
    }

    @Override
    public void skipBytes() throws IOException {
        this.advance(Symbol.BYTES);
        if (this.in.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw this.error("bytes");
        }
        this.in.nextToken();
    }

    private void checkFixed(int size) throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        if (size != top.size) {
            throw new AvroTypeException("Incorrect length for fixed binary: expected " + top.size + " but received " + size + " bytes.");
        }
    }

    @Override
    public void readFixed(byte[] bytes, int start, int len) throws IOException {
        byte[] result;
        this.checkFixed(len);
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            result = this.readByteArray();
            this.in.nextToken();
            if (result.length != len) {
                throw new AvroTypeException("Expected fixed length " + len + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
        System.arraycopy(result, 0, bytes, start, len);
    }

    @Override
    public void skipFixed(int length) throws IOException {
        this.checkFixed(length);
        this.doSkipFixed(length);
    }

    private void doSkipFixed(int length) throws IOException {
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            byte[] result = this.readByteArray();
            this.in.nextToken();
            if (result.length != length) {
                throw new AvroTypeException("Expected fixed length " + length + ", but got" + result.length);
            }
        } else {
            throw this.error("fixed");
        }
    }

    @Override
    protected void skipFixed() throws IOException {
        this.advance(Symbol.FIXED);
        Symbol.IntCheckAction top = (Symbol.IntCheckAction)this.parser.popSymbol();
        this.doSkipFixed(top.size);
    }

    @Override
    public int readEnum() throws IOException {
        this.advance(Symbol.ENUM);
        Symbol.EnumLabelsAction top = (Symbol.EnumLabelsAction)this.parser.popSymbol();
        if (this.in.getCurrentToken() == JsonToken.VALUE_STRING) {
            this.in.getText();
            int n = top.findLabel(this.in.getText());
            if (n >= 0) {
                this.in.nextToken();
                return n;
            }
            throw new AvroTypeException("Unknown symbol in enum " + this.in.getText());
        }
        throw this.error("fixed");
    }

    @Override
    public long readArrayStart() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() == JsonToken.START_ARRAY) {
            this.in.nextToken();
            return this.doArrayNext();
        }
        throw this.error("array-start");
    }

    @Override
    public long arrayNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doArrayNext();
    }

    private long doArrayNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_ARRAY) {
            this.parser.advance(Symbol.ARRAY_END);
            this.in.nextToken();
            return 0L;
        }
        return 1L;
    }

    @Override
    public long skipArray() throws IOException {
        this.advance(Symbol.ARRAY_START);
        if (this.in.getCurrentToken() != JsonToken.START_ARRAY) {
            throw this.error("array-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.ARRAY_END);
        return 0L;
    }

    @Override
    public long readMapStart() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() == JsonToken.START_OBJECT) {
            this.in.nextToken();
            return this.doMapNext();
        }
        throw this.error("map-start");
    }

    @Override
    public long mapNext() throws IOException {
        this.advance(Symbol.ITEM_END);
        return this.doMapNext();
    }

    private long doMapNext() throws IOException {
        if (this.in.getCurrentToken() == JsonToken.END_OBJECT) {
            this.in.nextToken();
            this.advance(Symbol.MAP_END);
            return 0L;
        }
        return 1L;
    }

    @Override
    public long skipMap() throws IOException {
        this.advance(Symbol.MAP_START);
        if (this.in.getCurrentToken() != JsonToken.START_OBJECT) {
            throw this.error("map-start");
        }
        this.in.skipChildren();
        this.in.nextToken();
        this.advance(Symbol.MAP_END);
        return 0L;
    }

    @Override
    public int readIndex() throws IOException {
        String label;
        this.advance(Symbol.UNION);
        Symbol.Alternative a = (Symbol.Alternative)this.parser.popSymbol();
        if (this.in.getCurrentToken() == JsonToken.VALUE_NULL) {
            label = "null";
        } else if (this.in.getCurrentToken() == JsonToken.START_OBJECT && this.in.nextToken() == JsonToken.FIELD_NAME) {
            label = this.in.getText();
            this.in.nextToken();
            this.parser.pushSymbol(Symbol.UNION_END);
        } else {
            throw this.error("start-union");
        }
        int n = a.findLabel(label);
        if (n < 0) {
            throw new AvroTypeException("Unknown union branch " + label);
        }
        this.parser.pushSymbol(a.getSymbol(n));
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldAdjustAction) {
            Symbol.FieldAdjustAction fa = (Symbol.FieldAdjustAction)top;
            if (this.in.getCurrentToken() != JsonToken.FIELD_NAME) return null;
            String fn = this.in.getCurrentName();
            if (!fa.fname.equals(fn)) throw new AvroTypeException("Expected field name " + fa.fname + " got " + this.in.getCurrentName());
            this.in.nextToken();
            return null;
        }
        if (top == Symbol.RECORD_START) {
            if (this.in.getCurrentToken() != JsonToken.START_OBJECT) throw this.error("record-start");
            this.in.nextToken();
            return null;
        } else {
            if (top != Symbol.RECORD_END && top != Symbol.UNION_END) throw new AvroTypeException("Unknown action symbol " + top);
            if (this.in.getCurrentToken() != JsonToken.END_OBJECT) throw this.error(top == Symbol.RECORD_END ? "record-end" : "union-end");
            this.in.nextToken();
        }
        return null;
    }

    private AvroTypeException error(String type) {
        return new AvroTypeException("Expected " + type + ". Got " + (Object)((Object)this.in.getCurrentToken()));
    }

    public void setItemCount(long itemCount) throws IOException {
    }
}

