/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class CassandraClient7
extends DB {
    static Random random = new Random();
    public static final int Ok = 0;
    public static final int Error = -1;
    public static final ByteBuffer emptyByteBuffer = ByteBuffer.wrap(new byte[0]);
    public int ConnectionRetries;
    public int OperationRetries;
    public String column_family;
    public static final String CONNECTION_RETRY_PROPERTY = "cassandra.connectionretries";
    public static final String CONNECTION_RETRY_PROPERTY_DEFAULT = "300";
    public static final String OPERATION_RETRY_PROPERTY = "cassandra.operationretries";
    public static final String OPERATION_RETRY_PROPERTY_DEFAULT = "300";
    public static final String USERNAME_PROPERTY = "cassandra.username";
    public static final String PASSWORD_PROPERTY = "cassandra.password";
    public static final String COLUMN_FAMILY_PROPERTY = "cassandra.columnfamily";
    public static final String COLUMN_FAMILY_PROPERTY_DEFAULT = "data";
    TTransport tr;
    Cassandra.Client client;
    boolean _debug = false;
    String _table = "";
    Exception errorexception = null;
    List<Mutation> mutations = new ArrayList<Mutation>();
    Map<String, List<Mutation>> mutationMap = new HashMap<String, List<Mutation>>();
    Map<ByteBuffer, Map<String, List<Mutation>>> record = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
    ColumnParent parent;

    @Override
    public void init() throws DBException {
        String hosts = this.getProperties().getProperty("hosts");
        if (hosts == null) {
            throw new DBException("Required property \"hosts\" missing for CassandraClient");
        }
        this.column_family = this.getProperties().getProperty(COLUMN_FAMILY_PROPERTY, COLUMN_FAMILY_PROPERTY_DEFAULT);
        this.parent = new ColumnParent(this.column_family);
        this.ConnectionRetries = Integer.parseInt(this.getProperties().getProperty(CONNECTION_RETRY_PROPERTY, "300"));
        this.OperationRetries = Integer.parseInt(this.getProperties().getProperty(OPERATION_RETRY_PROPERTY, "300"));
        String username = this.getProperties().getProperty(USERNAME_PROPERTY);
        String password = this.getProperties().getProperty(PASSWORD_PROPERTY);
        this._debug = Boolean.parseBoolean(this.getProperties().getProperty("debug", "false"));
        String[] allhosts = hosts.split(",");
        String myhost = allhosts[random.nextInt(allhosts.length)];
        Exception connectexception = null;
        for (int retry = 0; retry < this.ConnectionRetries; ++retry) {
            this.tr = new TFramedTransport(new TSocket(myhost, 9160));
            TBinaryProtocol proto = new TBinaryProtocol(this.tr);
            this.client = new Cassandra.Client(proto);
            try {
                this.tr.open();
                connectexception = null;
                break;
            }
            catch (Exception e2) {
                connectexception = e2;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (connectexception != null) {
            System.err.println("Unable to connect to " + myhost + " after " + this.ConnectionRetries + " tries");
            System.out.println("Unable to connect to " + myhost + " after " + this.ConnectionRetries + " tries");
            throw new DBException(connectexception);
        }
        if (username != null && password != null) {
            HashMap<String, String> cred = new HashMap<String, String>();
            cred.put("username", username);
            cred.put("password", password);
            AuthenticationRequest req = new AuthenticationRequest(cred);
            try {
                this.client.login(req);
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
    }

    @Override
    public void cleanup() throws DBException {
        this.tr.close();
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (!this._table.equals(table)) {
            try {
                this.client.set_keyspace(table);
                this._table = table;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(System.out);
                return -1;
            }
        }
        for (int i = 0; i < this.OperationRetries; ++i) {
            try {
                SlicePredicate predicate;
                if (fields == null) {
                    predicate = new SlicePredicate().setSlice_range(new SliceRange(emptyByteBuffer, emptyByteBuffer, false, 1000000));
                } else {
                    ArrayList<ByteBuffer> fieldlist = new ArrayList<ByteBuffer>(fields.size());
                    for (String s : fields) {
                        fieldlist.add(ByteBuffer.wrap(s.getBytes("UTF-8")));
                    }
                    predicate = new SlicePredicate().setColumn_names(fieldlist);
                }
                List<ColumnOrSuperColumn> results = this.client.get_slice(ByteBuffer.wrap(key.getBytes("UTF-8")), this.parent, predicate, ConsistencyLevel.ONE);
                if (this._debug) {
                    System.out.print("Reading key: " + key);
                }
                for (ColumnOrSuperColumn oneresult : results) {
                    Column column = oneresult.column;
                    String name = new String(column.name.array(), column.name.position() + column.name.arrayOffset(), column.name.remaining());
                    ByteArrayByteIterator value = new ByteArrayByteIterator(column.value.array(), column.value.position() + column.value.arrayOffset(), column.value.remaining());
                    result.put(name, value);
                    if (!this._debug) continue;
                    System.out.print("(" + name + "=" + value + ")");
                }
                if (this._debug) {
                    System.out.println();
                }
                return 0;
            }
            catch (Exception e) {
                this.errorexception = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.errorexception.printStackTrace();
        this.errorexception.printStackTrace(System.out);
        return -1;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        if (!this._table.equals(table)) {
            try {
                this.client.set_keyspace(table);
                this._table = table;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(System.out);
                return -1;
            }
        }
        for (int i = 0; i < this.OperationRetries; ++i) {
            try {
                SlicePredicate predicate;
                if (fields == null) {
                    predicate = new SlicePredicate().setSlice_range(new SliceRange(emptyByteBuffer, emptyByteBuffer, false, 1000000));
                } else {
                    ArrayList<ByteBuffer> fieldlist = new ArrayList<ByteBuffer>(fields.size());
                    for (String s : fields) {
                        fieldlist.add(ByteBuffer.wrap(s.getBytes("UTF-8")));
                    }
                    predicate = new SlicePredicate().setColumn_names(fieldlist);
                }
                KeyRange kr = new KeyRange().setStart_key(startkey.getBytes("UTF-8")).setEnd_key(new byte[0]).setCount(recordcount);
                List<KeySlice> results = this.client.get_range_slices(this.parent, predicate, kr, ConsistencyLevel.ONE);
                if (this._debug) {
                    System.out.println("Scanning startkey: " + startkey);
                }
                for (KeySlice oneresult : results) {
                    HashMap<String, ByteArrayByteIterator> tuple = new HashMap<String, ByteArrayByteIterator>();
                    for (ColumnOrSuperColumn onecol : oneresult.columns) {
                        Column column = onecol.column;
                        String name = new String(column.name.array(), column.name.position() + column.name.arrayOffset(), column.name.remaining());
                        ByteArrayByteIterator value = new ByteArrayByteIterator(column.value.array(), column.value.position() + column.value.arrayOffset(), column.value.remaining());
                        tuple.put(name, value);
                        if (!this._debug) continue;
                        System.out.print("(" + name + "=" + value + ")");
                    }
                    result.add(tuple);
                    if (!this._debug) continue;
                    System.out.println();
                }
                return 0;
            }
            catch (Exception e) {
                this.errorexception = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.errorexception.printStackTrace();
        this.errorexception.printStackTrace(System.out);
        return -1;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        return this.insert(table, key, values);
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        if (!this._table.equals(table)) {
            try {
                this.client.set_keyspace(table);
                this._table = table;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(System.out);
                return -1;
            }
        }
        for (int i = 0; i < this.OperationRetries; ++i) {
            if (this._debug) {
                System.out.println("Inserting key: " + key);
            }
            try {
                ByteBuffer wrappedKey = ByteBuffer.wrap(key.getBytes("UTF-8"));
                for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                    ColumnOrSuperColumn column = new ColumnOrSuperColumn();
                    column.setColumn(new Column(ByteBuffer.wrap(entry.getKey().getBytes("UTF-8")), ByteBuffer.wrap(entry.getValue().toArray()), System.currentTimeMillis()));
                    this.mutations.add(new Mutation().setColumn_or_supercolumn(column));
                }
                this.mutationMap.put(this.column_family, this.mutations);
                this.record.put(wrappedKey, this.mutationMap);
                this.client.batch_mutate(this.record, ConsistencyLevel.ONE);
                this.mutations.clear();
                this.mutationMap.clear();
                this.record.clear();
                return 0;
            }
            catch (Exception e) {
                this.errorexception = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.errorexception.printStackTrace();
        this.errorexception.printStackTrace(System.out);
        return -1;
    }

    @Override
    public int delete(String table, String key) {
        if (!this._table.equals(table)) {
            try {
                this.client.set_keyspace(table);
                this._table = table;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(System.out);
                return -1;
            }
        }
        for (int i = 0; i < this.OperationRetries; ++i) {
            try {
                this.client.remove(ByteBuffer.wrap(key.getBytes("UTF-8")), new ColumnPath(this.column_family), System.currentTimeMillis(), ConsistencyLevel.ONE);
                if (this._debug) {
                    System.out.println("Delete key: " + key);
                }
                return 0;
            }
            catch (Exception e) {
                this.errorexception = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.errorexception.printStackTrace();
        this.errorexception.printStackTrace(System.out);
        return -1;
    }

    public static void main(String[] args) {
        CassandraClient7 cli = new CassandraClient7();
        Properties props = new Properties();
        props.setProperty("hosts", args[0]);
        cli.setProperties(props);
        try {
            cli.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        HashMap<String, ByteIterator> vals = new HashMap<String, ByteIterator>();
        vals.put("age", new StringByteIterator("57"));
        vals.put("middlename", new StringByteIterator("bradley"));
        vals.put("favoritecolor", new StringByteIterator("blue"));
        int res = cli.insert("usertable", "BrianFrankCooper", vals);
        System.out.println("Result of insert: " + res);
        HashMap<String, ByteIterator> result = new HashMap<String, ByteIterator>();
        HashSet<String> fields = new HashSet<String>();
        fields.add("middlename");
        fields.add("age");
        fields.add("favoritecolor");
        res = cli.read("usertable", "BrianFrankCooper", null, result);
        System.out.println("Result of read: " + res);
        for (String s : result.keySet()) {
            System.out.println("[" + s + "]=[" + result.get(s) + "]");
        }
        res = cli.delete("usertable", "BrianFrankCooper");
        System.out.println("Result of delete: " + res);
    }
}

