/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.Workload;
import java.util.Vector;

public class TerminatorThread
extends Thread {
    private Vector<Thread> threads;
    private long maxExecutionTime;
    private Workload workload;
    private long waitTimeOutInMS;

    public TerminatorThread(long maxExecutionTime, Vector<Thread> threads, Workload workload) {
        this.maxExecutionTime = maxExecutionTime;
        this.threads = threads;
        this.workload = workload;
        this.waitTimeOutInMS = 2000L;
        System.err.println("Maximum execution time specified as: " + maxExecutionTime + " secs");
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.maxExecutionTime * 1000L);
        }
        catch (InterruptedException e) {
            System.err.println("Could not wait until max specified time, TerminatorThread interrupted.");
            return;
        }
        System.err.println("Maximum time elapsed. Requesting stop for the workload.");
        this.workload.requestStop();
        System.err.println("Stop requested for workload. Now Joining!");
        for (Thread t : this.threads) {
            while (t.isAlive()) {
                try {
                    t.join(this.waitTimeOutInMS);
                    if (!t.isAlive()) continue;
                    System.err.println("Still waiting for thread " + t.getName() + " to complete. " + "Workload status: " + this.workload.isStopRequested());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

