/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CommandLine {
    public static final String DEFAULT_DB = "com.yahoo.ycsb.BasicDB";

    public static void usageMessage() {
        System.out.println("YCSB Command Line Client");
        System.out.println("Usage: java com.yahoo.ycsb.CommandLine [options]");
        System.out.println("Options:");
        System.out.println("  -P filename: Specify a property file");
        System.out.println("  -p name=value: Specify a property value");
        System.out.println("  -db classname: Use a specified DB class (can also set the \"db\" property)");
        System.out.println("  -table tablename: Use the table name instead of the default \"usertable\"");
        System.out.println();
    }

    public static void help() {
        System.out.println("Commands:");
        System.out.println("  read key [field1 field2 ...] - Read a record");
        System.out.println("  scan key recordcount [field1 field2 ...] - Scan starting at key");
        System.out.println("  insert key name1=value1 [name2=value2 ...] - Insert a new record");
        System.out.println("  update key name1=value1 [name2=value2 ...] - Update a record");
        System.out.println("  delete key - Delete a record");
        System.out.println("  table [tablename] - Get or [set] the name of the table");
        System.out.println("  quit - Quit");
    }

    public static void main(String[] args) {
        int argindex = 0;
        Properties props = new Properties();
        Properties fileprops = new Properties();
        String table = "usertable";
        while (argindex < args.length && args[argindex].startsWith("-")) {
            if (args[argindex].compareTo("-help") == 0 || args[argindex].compareTo("--help") == 0 || args[argindex].compareTo("-?") == 0 || args[argindex].compareTo("--?") == 0) {
                CommandLine.usageMessage();
                System.exit(0);
            }
            if (args[argindex].compareTo("-db") == 0) {
                if (++argindex >= args.length) {
                    CommandLine.usageMessage();
                    System.exit(0);
                }
                props.setProperty("db", args[argindex]);
                ++argindex;
            } else if (args[argindex].compareTo("-P") == 0) {
                if (++argindex >= args.length) {
                    CommandLine.usageMessage();
                    System.exit(0);
                }
                String propfile = args[argindex];
                ++argindex;
                Properties myfileprops = new Properties();
                try {
                    myfileprops.load(new FileInputStream(propfile));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(0);
                }
                Enumeration<?> e = myfileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    fileprops.setProperty(prop, myfileprops.getProperty(prop));
                }
            } else if (args[argindex].compareTo("-p") == 0) {
                int eq;
                if (++argindex >= args.length) {
                    CommandLine.usageMessage();
                    System.exit(0);
                }
                if ((eq = args[argindex].indexOf(61)) < 0) {
                    CommandLine.usageMessage();
                    System.exit(0);
                }
                String name = args[argindex].substring(0, eq);
                String value = args[argindex].substring(eq + 1);
                props.put(name, value);
                ++argindex;
            } else if (args[argindex].compareTo("-table") == 0) {
                if (++argindex >= args.length) {
                    CommandLine.usageMessage();
                    System.exit(0);
                }
                table = args[argindex];
                ++argindex;
            } else {
                System.out.println("Unknown option " + args[argindex]);
                CommandLine.usageMessage();
                System.exit(0);
            }
            if (argindex < args.length) continue;
        }
        if (argindex != args.length) {
            CommandLine.usageMessage();
            System.exit(0);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            fileprops.setProperty(prop, props.getProperty(prop));
        }
        props = fileprops;
        System.out.println("YCSB Command Line client");
        System.out.println("Type \"help\" for command line help");
        System.out.println("Start with \"-help\" for usage info");
        String dbname = props.getProperty("db", DEFAULT_DB);
        ClassLoader classLoader = CommandLine.class.getClassLoader();
        DB db = null;
        try {
            Class<?> dbclass = classLoader.loadClass(dbname);
            db = (DB)dbclass.newInstance();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(0);
        }
        db.setProperties(props);
        try {
            db.init();
        }
        catch (DBException e3) {
            e3.printStackTrace();
            System.exit(0);
        }
        System.out.println("Connected.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            int ret;
            System.out.print("> ");
            String input = null;
            try {
                input = br.readLine();
            }
            catch (IOException e4) {
                e4.printStackTrace();
                System.exit(1);
            }
            if (input.compareTo("") == 0) continue;
            if (input.compareTo("help") == 0) {
                CommandLine.help();
                continue;
            }
            if (input.compareTo("quit") == 0) break;
            String[] tokens = input.split(" ");
            long st = System.currentTimeMillis();
            if (tokens[0].compareTo("table") == 0) {
                if (tokens.length == 1) {
                    System.out.println("Using table \"" + table + "\"");
                } else if (tokens.length == 2) {
                    table = tokens[1];
                    System.out.println("Using table \"" + table + "\"");
                } else {
                    System.out.println("Error: syntax is \"table tablename\"");
                }
            } else if (tokens[0].compareTo("read") == 0) {
                if (tokens.length == 1) {
                    System.out.println("Error: syntax is \"read keyname [field1 field2 ...]\"");
                } else {
                    HashSet<String> fields = null;
                    if (tokens.length > 2) {
                        fields = new HashSet<String>();
                        for (int i = 2; i < tokens.length; ++i) {
                            fields.add(tokens[i]);
                        }
                    }
                    HashMap<String, ByteIterator> result = new HashMap<String, ByteIterator>();
                    ret = db.read(table, tokens[1], fields, result);
                    System.out.println("Return code: " + ret);
                    for (Map.Entry<String, ByteIterator> ent : result.entrySet()) {
                        System.out.println(ent.getKey() + "=" + ent.getValue());
                    }
                }
            } else if (tokens[0].compareTo("scan") == 0) {
                if (tokens.length < 3) {
                    System.out.println("Error: syntax is \"scan keyname scanlength [field1 field2 ...]\"");
                } else {
                    HashSet<String> fields = null;
                    if (tokens.length > 3) {
                        fields = new HashSet<String>();
                        for (int i = 3; i < tokens.length; ++i) {
                            fields.add(tokens[i]);
                        }
                    }
                    Vector<HashMap<String, ByteIterator>> results = new Vector<HashMap<String, ByteIterator>>();
                    ret = db.scan(table, tokens[1], Integer.parseInt(tokens[2]), fields, results);
                    System.out.println("Return code: " + ret);
                    int record = 0;
                    if (results.size() == 0) {
                        System.out.println("0 records");
                    } else {
                        System.out.println("--------------------------------");
                    }
                    for (HashMap<String, ByteIterator> result : results) {
                        System.out.println("Record " + record++);
                        for (Map.Entry<String, ByteIterator> ent : result.entrySet()) {
                            System.out.println(ent.getKey() + "=" + ent.getValue());
                        }
                        System.out.println("--------------------------------");
                    }
                }
            } else if (tokens[0].compareTo("update") == 0) {
                if (tokens.length < 3) {
                    System.out.println("Error: syntax is \"update keyname name1=value1 [name2=value2 ...]\"");
                } else {
                    HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
                    for (int i = 2; i < tokens.length; ++i) {
                        String[] nv = tokens[i].split("=");
                        values.put(nv[0], new StringByteIterator(nv[1]));
                    }
                    int ret2 = db.update(table, tokens[1], values);
                    System.out.println("Return code: " + ret2);
                }
            } else if (tokens[0].compareTo("insert") == 0) {
                if (tokens.length < 3) {
                    System.out.println("Error: syntax is \"insert keyname name1=value1 [name2=value2 ...]\"");
                } else {
                    HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
                    for (int i = 2; i < tokens.length; ++i) {
                        String[] nv = tokens[i].split("=");
                        values.put(nv[0], new StringByteIterator(nv[1]));
                    }
                    int ret3 = db.insert(table, tokens[1], values);
                    System.out.println("Return code: " + ret3);
                }
            } else if (tokens[0].compareTo("delete") == 0) {
                if (tokens.length != 2) {
                    System.out.println("Error: syntax is \"delete keyname\"");
                } else {
                    int ret4 = db.delete(table, tokens[1]);
                    System.out.println("Return code: " + ret4);
                }
            } else {
                System.out.println("Error: unknown command \"" + tokens[0] + "\"");
            }
            System.out.println(System.currentTimeMillis() - st + " ms");
        }
    }
}

