/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class JDOMAbout {
    public static void main(String[] args) throws Exception {
        Info info = new Info();
        String title = info.title;
        System.out.println(title + " version " + info.version);
        System.out.println("Copyright " + info.copyright);
        System.out.println();
        System.out.println(info.description);
        System.out.println();
        System.out.println("Authors:");
        Iterator iter2 = info.authors.iterator();
        while (iter2.hasNext()) {
            Author author = (Author)iter2.next();
            System.out.print("  " + author.name);
            if (author.email == null) {
                System.out.println();
                continue;
            }
            System.out.println(" <" + author.email + ">");
        }
        System.out.println();
        System.out.println(title + " license:");
        System.out.println(info.license);
        System.out.println();
        System.out.println(title + " support:");
        System.out.println(info.support);
        System.out.println();
        System.out.println(title + " web site: " + info.website);
        System.out.println();
    }

    private static class Author {
        final String name;
        final String email;

        Author(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }

    private static class Info {
        private static final String INFO_FILENAME = "META-INF/jdom-info.xml";
        final String title;
        final String version;
        final String copyright;
        final String description;
        final String license;
        final String support;
        final String website;
        final List authors = new ArrayList();

        Info() throws Exception {
            InputStream inputStream = this.getInfoFileStream();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inputStream);
            Element root = doc.getRootElement();
            this.title = root.getChildTextTrim("title");
            this.version = root.getChildTextTrim("version");
            this.copyright = root.getChildTextTrim("copyright");
            this.description = root.getChildTextTrim("description");
            this.license = root.getChildTextTrim("license");
            this.support = root.getChildTextTrim("support");
            this.website = root.getChildTextTrim("web-site");
            List authorElements = root.getChildren("author");
            Iterator iter2 = authorElements.iterator();
            while (iter2.hasNext()) {
                Element element = (Element)iter2.next();
                Author author = new Author(element.getChildTextTrim("name"), element.getChildTextTrim("e-mail"));
                this.authors.add(author);
            }
        }

        private InputStream getInfoFileStream() throws FileNotFoundException {
            InputStream inputStream = this.getClass().getResourceAsStream(INFO_FILENAME);
            if (inputStream == null) {
                throw new FileNotFoundException("META-INF/jdom-info.xml not found; it should be within the JDOM JAR but wasn't found on the classpath");
            }
            return inputStream;
        }
    }
}

