/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jtdgss.TdgssLogger;
import java.util.ArrayList;
import java.util.List;

class TdgssDeferredLogger
implements TdgssLogger {
    private static final int DEBUG = 0;
    private static final int INFO = 1;
    private static final int TIMING = 2;
    private static final int ERROR = 3;
    private final List logs = new ArrayList();

    TdgssDeferredLogger() {
    }

    public synchronized void error(String string) {
        this.logs.add(new DeferredLog(3, string));
    }

    public synchronized void error(String string, Throwable throwable) {
        this.logs.add(new DeferredLog(3, string, throwable));
    }

    public boolean isTimingEnabled() {
        return true;
    }

    public synchronized void timing(String string) {
        this.logs.add(new DeferredLog(2, string));
    }

    public synchronized void timing(String string, Throwable throwable) {
        this.logs.add(new DeferredLog(2, string, throwable));
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public synchronized void info(String string) {
        this.logs.add(new DeferredLog(1, string));
    }

    public synchronized void info(String string, Throwable throwable) {
        this.logs.add(new DeferredLog(1, string, throwable));
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String string) {
        this.logs.add(new DeferredLog(0, string));
    }

    public void debug(String string, Throwable throwable) {
        this.logs.add(new DeferredLog(0, string, throwable));
    }

    synchronized void report(TdgssLogger tdgssLogger) {
        block5: for (int i = 0; i < this.logs.size(); ++i) {
            DeferredLog deferredLog = (DeferredLog)this.logs.get(i);
            switch (deferredLog.level) {
                case 0: {
                    if (!tdgssLogger.isDebugEnabled()) continue block5;
                    if (deferredLog.cause == null) {
                        tdgssLogger.debug(deferredLog.message);
                        continue block5;
                    }
                    tdgssLogger.debug(deferredLog.message, deferredLog.cause);
                    continue block5;
                }
                case 2: {
                    if (!tdgssLogger.isTimingEnabled()) continue block5;
                    if (deferredLog.cause == null) {
                        tdgssLogger.timing(deferredLog.message);
                        continue block5;
                    }
                    tdgssLogger.timing(deferredLog.message, deferredLog.cause);
                    continue block5;
                }
                case 1: {
                    if (!tdgssLogger.isInfoEnabled()) continue block5;
                    if (deferredLog.cause == null) {
                        tdgssLogger.info(deferredLog.message);
                        continue block5;
                    }
                    tdgssLogger.info(deferredLog.message, deferredLog.cause);
                    continue block5;
                }
                default: {
                    if (deferredLog.cause == null) {
                        tdgssLogger.error(deferredLog.message);
                        continue block5;
                    }
                    tdgssLogger.error(deferredLog.message, deferredLog.cause);
                }
            }
        }
        this.logs.clear();
    }

    private static class DeferredLog {
        private final int level;
        private final String message;
        private final Throwable cause;

        private DeferredLog(int n, String string, Throwable throwable) {
            this.level = n;
            this.message = string;
            this.cause = throwable;
        }

        private DeferredLog(int n, String string) {
            this(n, string, (Throwable)null);
        }
    }
}

