/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jalgapi;

import java.util.ArrayList;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AlgParcel {
    public static final byte ALG_DER_TYPE_CLASS_PRIVATE = -64;
    public static final byte ALG_DER_TYPE_PRIMITIVE = 0;
    public static final byte ALG_DER_TYPE_CONSTRUCTED = 32;
    public static final byte ALG_TAG_SET_CIPHER_SUITES = 1;
    public static final byte ALG_TAG_SET_CIPHER_SUITE = 2;
    public static final byte ALG_TAG_SET_QOP_DEFINITIONS = 3;
    public static final byte ALG_TAG_SET_DEFAULT_QOP = 4;
    public static final byte ALG_TAG_SET_LOW_QOP = 5;
    public static final byte ALG_TAG_SET_MEDIUM_QOP = 6;
    public static final byte ALG_TAG_SET_HIGH_QOP = 7;
    public static final byte ALG_TAG_INT_CONF_ALG = 16;
    public static final byte ALG_TAG_INT_INTEG_ALG = 17;
    public static final byte ALG_TAG_INT_KEYEXCH_ALG = 18;
    public static final byte ALG_TAG_INT_MODE = 19;
    public static final byte ALG_TAG_INT_PADDING = 20;
    public static final byte ALG_TAG_INT_KEYLENGTH = 21;
    public static final byte ALG_TAG_INT_KEYLENGTHP = 22;
    public static final byte ALG_DER_TYPE_SET_CIPHER_SUITES = -31;
    public static final byte ALG_DER_TYPE_SET_CIPHER_SUITE = -30;
    public static final byte ALG_DER_TYPE_SET_QOP_DEFINITIONS = -29;
    public static final byte ALG_DER_TYPE_SET_DEFAULT_QOP = -28;
    public static final byte ALG_DER_TYPE_SET_LOW_QOP = -27;
    public static final byte ALG_DER_TYPE_SET_MEDIUM_QOP = -26;
    public static final byte ALG_DER_TYPE_SET_HIGH_QOP = -25;
    public static final byte ALG_DER_TYPE_INT_CONF_ALG = -48;
    public static final byte ALG_DER_TYPE_INT_INTEG_ALG = -47;
    public static final byte ALG_DER_TYPE_INT_KEYEXCH_ALG = -46;
    public static final byte ALG_DER_TYPE_INT_MODE = -45;
    public static final byte ALG_DER_TYPE_INT_PADDING = -44;
    public static final byte ALG_DER_TYPE_INT_KEYLENGTH = -43;
    public static final byte ALG_DER_TYPE_INT_KEYLENGTHP = -42;
    public static final int AES_KEYSIZE_128 = 128;
    public static final int AES_KEYSIZE_192 = 192;
    public static final int AES_KEYSIZE_256 = 256;
    public static final byte[] derConfAlg;
    public static final byte[] derIntgAlgSHA1;
    public static final byte[] derIntgAlgSHA256;
    public static final byte[] derIntgAlgSHA512;
    public static final byte[] derKeyExchAlg;
    public static final byte[] derKeyLength128;
    public static final byte[] derKeyLength192;
    public static final byte[] derKeyLength256;
    private static final byte[] cipherSuitesParcel;
    private static final int minKeySize;
    private static final int SHA256 = 6;
    private static final int SHA512 = 7;

    private AlgParcel() {
    }

    private static boolean isKeySizeSupported(int n) {
        String string = "AES/CBC/PKCS5Padding";
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(n);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isKeySupported(int n) {
        return n <= minKeySize;
    }

    public static byte[] getCipherSuitesParcel() {
        return (byte[])cipherSuitesParcel.clone();
    }

    static {
        AlgParcel algParcel;
        derConfAlg = new byte[]{-30, 9, -48, 1, 2, -45, 1, 1, -44, 1, 4};
        derIntgAlgSHA1 = new byte[]{-30, 3, -47, 1, 4};
        derIntgAlgSHA256 = new byte[]{-30, 3, -47, 1, 6};
        derIntgAlgSHA512 = new byte[]{-30, 3, -47, 1, 7};
        derKeyExchAlg = new byte[]{-30, 7, -46, 1, 5, -42, 2, 8, 0};
        derKeyLength128 = new byte[]{-43, 2, 0, -128};
        derKeyLength192 = new byte[]{-43, 2, 0, -64};
        derKeyLength256 = new byte[]{-43, 2, 1, 0};
        minKeySize = AlgParcel.isKeySizeSupported(256) ? 256 : (AlgParcel.isKeySizeSupported(192) ? 192 : (AlgParcel.isKeySizeSupported(128) ? 128 : 0));
        AlgParcel algParcel2 = algParcel = new AlgParcel();
        algParcel2.getClass();
        DerCipherSuite derCipherSuite = algParcel2.new DerCipherSuite(16);
        AlgParcel algParcel3 = algParcel;
        algParcel3.getClass();
        DerCipherSuite derCipherSuite2 = algParcel3.new DerCipherSuite(18);
        AlgParcel algParcel4 = algParcel;
        algParcel4.getClass();
        DerCipherSuite derCipherSuite3 = algParcel4.new DerCipherSuite(17);
        AlgParcel algParcel5 = algParcel;
        algParcel5.getClass();
        DerCipherSuite derCipherSuite4 = algParcel5.new DerCipherSuite(17, 6);
        AlgParcel algParcel6 = algParcel;
        algParcel6.getClass();
        DerCipherSuite derCipherSuite5 = algParcel6.new DerCipherSuite(17, 7);
        if (AlgParcel.isKeySupported(128)) {
            derCipherSuite.appendDerBytes(derKeyLength128);
        }
        if (AlgParcel.isKeySupported(192)) {
            derCipherSuite.appendDerBytes(derKeyLength192);
        }
        if (AlgParcel.isKeySupported(256)) {
            derCipherSuite.appendDerBytes(derKeyLength256);
        }
        DerCipherSuites derCipherSuites = algParcel.new DerCipherSuites();
        derCipherSuites.addDerCipherSuite(derCipherSuite);
        derCipherSuites.addDerCipherSuite(derCipherSuite3);
        derCipherSuites.addDerCipherSuite(derCipherSuite4);
        derCipherSuites.addDerCipherSuite(derCipherSuite5);
        derCipherSuites.addDerCipherSuite(derCipherSuite2);
        cipherSuitesParcel = derCipherSuites.getBytes();
    }

    private class DerCipherSuites {
        private static final int CONTENT_INDEX = 2;
        private ArrayList cipherSuitesList = new ArrayList();

        public void addDerCipherSuite(DerCipherSuite derCipherSuite) {
            this.cipherSuitesList.add(derCipherSuite);
        }

        public byte[] getBytes() {
            int n = 2;
            int n2 = 0;
            for (int i = 0; i < this.cipherSuitesList.size(); ++i) {
                DerCipherSuite derCipherSuite = (DerCipherSuite)this.cipherSuitesList.get(i);
                n2 += derCipherSuite.getBytesSize();
            }
            byte[] byArray = new byte[n += n2];
            byArray[0] = -31;
            byArray[1] = (byte)n2;
            int n3 = 2;
            for (int i = 0; i < this.cipherSuitesList.size(); ++i) {
                DerCipherSuite derCipherSuite = (DerCipherSuite)this.cipherSuitesList.get(i);
                byte[] byArray2 = derCipherSuite.getBytes();
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
                n3 += byArray2.length;
            }
            return byArray;
        }
    }

    private class DerCipherSuite {
        private static final int LENGTH_INDEX = 1;
        private byte[] cipherSuite = null;

        public DerCipherSuite(int n) {
            switch (n) {
                case 16: {
                    this.cipherSuite = derConfAlg;
                    break;
                }
                case 17: {
                    this.cipherSuite = derIntgAlgSHA1;
                    break;
                }
                case 18: {
                    this.cipherSuite = derKeyExchAlg;
                }
            }
        }

        public DerCipherSuite(int n, int n2) {
            block0 : switch (n) {
                case 17: {
                    switch (n2) {
                        case 6: {
                            this.cipherSuite = derIntgAlgSHA256;
                            break block0;
                        }
                        case 7: {
                            this.cipherSuite = derIntgAlgSHA512;
                        }
                    }
                }
            }
        }

        public void appendDerBytes(byte[] byArray) {
            int n = this.cipherSuite.length + byArray.length;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.cipherSuite, 0, byArray2, 0, this.cipherSuite.length);
            System.arraycopy(byArray, 0, byArray2, this.cipherSuite.length, byArray.length);
            this.cipherSuite = byArray2;
            this.cipherSuite[1] = (byte)(this.cipherSuite[1] + byArray.length);
        }

        public int getBytesSize() {
            return this.cipherSuite.length;
        }

        public byte[] getBytes() {
            return this.cipherSuite;
        }
    }
}

