/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraSQLOutput;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.client.ClientArray;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.AsciiStreamReader;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.LobReceiveController;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedBatchStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;

public abstract class TDPreparedStatement
extends TDStatement {
    private ParameterProperties m_paramProperties;
    private int numberOfBatchStatements = 0;
    private byte mode = (byte)69;
    private FullContentMetadataItem[] m_afcmiParameterMarkers;
    private LobReceiveController m_lobReceiveController;

    public TDPreparedStatement(TDSession tDSession, String string, int n, int n2, int n3, GeneratedKeysRequest generatedKeysRequest, Map map) throws SQLException {
        super(tDSession, n, n2, n3);
        boolean bl;
        this.m_generatedKeys = generatedKeysRequest;
        this.m_mapSQLRequestEscapeFunctions.putAll(map);
        if (this instanceof CallableStatement) {
            if (this.getSQLRequestEscapeFunction("TERADATA_CALL_PARAM_RS") != null) {
                throw ErrorFactory.makeDriverJDBCException("TJ812", "TERADATA_CALL_PARAM_RS");
            }
            if (this.getSQLRequestEscapeFunction("TERADATA_AUTO_OUT_PARAM") != null) {
                throw ErrorFactory.makeDriverJDBCException("TJ812", "TERADATA_AUTO_OUT_PARAM");
            }
        }
        boolean bl2 = bl = (tDSession.getURLParameters().getPrepSupport() || tDSession.isStatementInfoSupported()) && this.getSQLRequestEscapeFunction("TERADATA_NOPREPARE") == null;
        if (bl) {
            this.prepareRequest(string, 3, (byte)83);
        }
        if (this.getMetaDataList().size() == 0 || ActivityAnalyzer.outParamResultSet(this.getMetaDataList().getFirstMetaData().getActivityType()) || this.anyAmbiguousResultSetColumns()) {
            this.mode = (byte)66;
        }
        ArrayList arrayList = null;
        for (int i = 1; i <= this.getMetaDataList().size(); ++i) {
            ArrayList arrayList2 = this.getMetaDataList().getMetaDataForStatement(i).getPrepInfoParcel().getParameterMarkerMetadataItems();
            if (arrayList2 == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            arrayList.addAll(arrayList2);
        }
        if (arrayList != null) {
            this.m_afcmiParameterMarkers = arrayList.toArray(new FullContentMetadataItem[0]);
        }
        this.m_paramProperties = ParameterProperties.createParameterPropertiesForParameterMarkers(string, this.m_session);
    }

    private boolean anyAmbiguousResultSetColumns() throws SQLException {
        for (int i = 1; i <= this.getMetaDataList().size(); ++i) {
            TeraResultSetMetaData teraResultSetMetaData = this.getMetaDataList().getMetaDataForStatement(i);
            for (int j = 1; j <= teraResultSetMetaData.getColumnCount(); ++j) {
                if (teraResultSetMetaData.getColumnType(j) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized boolean doPrepExecute(String string) throws SQLException {
        PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.m_session, string);
        this.executeStatement(preparedStatementController, 3, this.mode);
        if (this.m_paramProperties != null) {
            this.m_paramProperties.clear();
        }
        return this.getResults().moreResults() && this.getResults().getResult(0).getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doPrepExecuteQuery(String string) throws SQLException {
        try {
            if (this.getMetaDataList().size() > 0 && !ActivityAnalyzer.resultSetExpected(this.getMetaDataList().getFirstMetaData().getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ388");
            }
            if (this.getMetaDataList().size() > 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ390", "executeQuery()");
            }
            PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.m_session, string);
            this.executeStatement(preparedStatementController, 2, this.mode);
            Object var4_3 = null;
            if (this.m_paramProperties != null) {
                this.m_paramProperties.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.m_paramProperties != null) {
                this.m_paramProperties.clear();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int doPrepExecuteUpdate(String string) throws SQLException {
        try {
            if (this.getMetaDataList().size() > 0 && ActivityAnalyzer.resultSetExpected(this.getMetaDataList().getFirstMetaData().getActivityType()) && !ActivityAnalyzer.outParamResultSet(this.getMetaDataList().getFirstMetaData().getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ389");
            }
            if (this.getMetaDataList().size() > 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ390", "executeUpdate()");
            }
            PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.m_session, string);
            this.executeStatement(preparedStatementController, 1, this.mode);
            Object var4_3 = null;
            if (this.m_paramProperties != null) {
                this.m_paramProperties.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.m_paramProperties != null) {
                this.m_paramProperties.clear();
            }
            throw throwable;
        }
        return this.getUpdateCount();
    }

    public int[] executeBatchDMLArray(String string) throws SQLException {
        if (this.getMetaDataList().size() > 0 && ActivityAnalyzer.resultSetExpected(this.getMetaDataList().getFirstMetaData().getActivityType()) && !ActivityAnalyzer.outParamResultSet(this.getMetaDataList().getFirstMetaData().getActivityType())) {
            throw ErrorFactory.makeDriverJDBCException("TJ391");
        }
        StatementController statementController = null;
        try {
            try {
                this.numberOfBatchStatements = this.m_paramProperties != null ? this.m_paramProperties.numberOfParamSets() : 0;
                this.getMetaDataList().setBatchStatement(true);
                statementController = new PreparedBatchStatementController(this, this.m_session, string);
                boolean bl = this.m_generatedKeys != null && !this.m_generatedKeys.returnsColumn();
                this.executeStatement(statementController, 5, (byte)69, bl);
                if (statementController.getBatchExceptions() != null) {
                    throw statementController.getAndRemoveBatchExceptions();
                }
                Object var7_5 = null;
                if (this.m_paramProperties != null) {
                    this.m_paramProperties.clear();
                }
            }
            catch (SQLException sQLException) {
                int[] nArray;
                if (statementController != null && statementController.getBatchExceptions() != null) {
                    sQLException.setNextException(statementController.getAndRemoveBatchExceptions());
                }
                if ((nArray = this.getResults().getSmallUpdateCountArray()) == null || nArray.length == 0) {
                    nArray = new int[this.numberOfBatchStatements];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = -3;
                    }
                }
                if (sQLException.getErrorCode() < 0 || sQLException.getNextException() != null) {
                    throw ErrorFactory.makeBatchUpdateException("TJ645", sQLException, nArray);
                }
                throw ErrorFactory.convertToBatchUpdateException(sQLException, nArray);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.m_paramProperties != null) {
                this.m_paramProperties.clear();
            }
            throw throwable;
        }
        this.checkResults();
        return this.getResults().getSmallUpdateCountArray();
    }

    public void setParameterProperties(ParameterProperties parameterProperties) {
        this.m_paramProperties = parameterProperties;
    }

    public ParameterProperties getParameterProperties() {
        return this.m_paramProperties;
    }

    public int getNumberOfBatchStatements() {
        return this.numberOfBatchStatements;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.getResults().getResultsSize() > 0 && this.conditionalGetResultSet() != null;
        TeraResultSetMetaData teraResultSetMetaData = bl ? (TeraResultSetMetaData)((Object)this.conditionalGetResultSet().getMetaData()) : (this.noResultsAndHaveMetaDataFromPrepare() ? this.getMetaDataList().getMetaDataForStatement(this.m_nMetadataStatementNumber) : null);
        return teraResultSetMetaData != null && ActivityAnalyzer.resultSetExpected(teraResultSetMetaData.getActivityType()) && (!ActivityAnalyzer.outParamResultSet(teraResultSetMetaData.getActivityType()) || this.getSQLRequestEscapeFunction("TERADATA_CALL_PARAM_RS") != null) ? (ResultSetMetaData)((Object)teraResultSetMetaData) : null;
    }

    public ArrayList getParameterMarkerMetaData() {
        return this.m_afcmiParameterMarkers != null ? new ArrayList<FullContentMetadataItem>(Arrays.asList(this.m_afcmiParameterMarkers)) : null;
    }

    public boolean hasParameterMetaData() {
        return this.m_afcmiParameterMarkers != null;
    }

    public int getNumberOfParameters() {
        return this.m_afcmiParameterMarkers.length;
    }

    public FullContentMetadataItem getParameterMarkerMetaDataItem(int n) throws SQLException {
        if (n < 1 || n > this.m_afcmiParameterMarkers.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.m_afcmiParameterMarkers.length);
        }
        return this.m_afcmiParameterMarkers[n - 1];
    }

    public void addBatch(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3;
        this.m_paramProperties.verifyParamMarker(n);
        boolean bl = this.m_session.shouldSendAnsiDate();
        boolean bl2 = this.m_session.isStatementInfoRequestSupported();
        boolean bl3 = this.m_session.isLargeDecimalAndBigIntSupported();
        switch (n2) {
            case 91: {
                n3 = bl ? 749 : (bl2 ? 753 : 497);
                break;
            }
            case 93: {
                n3 = bl2 ? 765 : 453;
                break;
            }
            case 92: {
                n3 = bl2 ? 761 : 453;
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 1111: {
                n3 = 449;
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                n3 = 757;
                break;
            }
            case 5: {
                n3 = 501;
                break;
            }
            case 4: {
                n3 = 497;
                break;
            }
            case -2: {
                n3 = 693;
                break;
            }
            case -4: 
            case -3: {
                n3 = 689;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n3 = 481;
                break;
            }
            case -5: {
                n3 = bl3 ? 601 : 485;
                break;
            }
            case 2: {
                n3 = this.m_session.isNumberDataTypeSupported() ? 605 : 485;
                break;
            }
            case 3: {
                n3 = 485;
                break;
            }
            case 2004: {
                n3 = 405;
                break;
            }
            case 2005: {
                n3 = 421;
                break;
            }
            case 2003: {
                this.setArray(n, null);
                return;
            }
            case 2002: {
                int n4 = 441;
                this.internalSetStruct(n, null);
                return;
            }
            case 2009: {
                n3 = 857;
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ231", n2);
            }
        }
        this.internalSetNull(n, n2, 0, n3, false);
    }

    public void internalSetNull(int n, int n2, int n3, int n4, boolean bl) throws SQLException {
        boolean bl2;
        byte[] byArray;
        int n5;
        int n6;
        if (n2 == 92 || n2 == 93) {
            n6 = n2 == 92 ? 8 : 19;
            int n7 = n5 = n2 == 92 ? this.m_session.getURLParameters().getTimeNano() : this.m_session.getURLParameters().getTimestampNano();
            if (n5 != -1 && n5 > 0) {
                n3 = n5;
                n6 += 1 + n5;
            }
            if (bl) {
                n6 += 6;
            }
            byArray = TDPreparedStatement.spacesForNullValue(n, false, n6, this.m_session);
        } else if (n4 == 749) {
            byArray = TDPreparedStatement.spacesForNullValue(n, false, 10, this.m_session);
        } else if (JDBC4Constants.isIntervalType(n4)) {
            n6 = JDBC4Constants.getIntervalLength(n4);
            byArray = TDPreparedStatement.spacesForNullValue(n, false, n6, this.m_session);
        } else {
            switch (n4) {
                case 453: 
                case 693: {
                    n6 = 0;
                    break;
                }
                case 449: 
                case 457: 
                case 689: 
                case 697: {
                    n6 = 2;
                    break;
                }
                case 757: {
                    n6 = 1;
                    break;
                }
                case 501: {
                    n6 = 2;
                    break;
                }
                case 497: 
                case 753: {
                    n6 = 4;
                    break;
                }
                case 601: {
                    n6 = 8;
                    break;
                }
                case 481: {
                    n6 = 8;
                    break;
                }
                case 605: {
                    int n8 = n3 = this.m_session.isNumberDataTypeSupported() ? -128 : n3;
                    n6 = this.m_session.isNumberDataTypeSupported() ? 1 : (this.m_session.isLargeDecimalAndBigIntSupported() ? 16 : 8);
                    break;
                }
                case 485: {
                    n6 = this.m_session.isLargeDecimalAndBigIntSupported() ? 16 : 8;
                    break;
                }
                case 405: 
                case 421: 
                case 889: {
                    n6 = 4;
                    break;
                }
                case 409: 
                case 425: 
                case 885: {
                    n6 = 2;
                    break;
                }
                case 441: {
                    n6 = 0;
                    break;
                }
                case 505: 
                case 509: {
                    n6 = 2;
                    break;
                }
                case 857: 
                case 869: {
                    n6 = 4;
                    break;
                }
                case 861: 
                case 873: {
                    n6 = 2;
                    break;
                }
                default: {
                    throw ErrorFactory.makeDriverJDBCException("TJ426", n, n4);
                }
            }
            byArray = new byte[n6];
        }
        n6 = !this.m_session.isLargeDecimalAndBigIntSupported() ? 1 : 0;
        n5 = !this.m_session.isNumberDataTypeSupported() ? 1 : 0;
        boolean bl3 = bl2 = n2 == 3 || n2 == 2 && n5 != 0 || n2 == -5 && n6 != 0;
        if (bl2) {
            this.m_paramProperties.setDecimalParameter(n, null, byArray, n4, true, this.m_session.isLargeDecimalAndBigIntSupported() ? 38 : 18, n3, 0);
        } else {
            boolean bl4;
            boolean bl5 = bl4 = n4 == 605 && this.m_session.isNumberDataTypeSupported();
            int n9 = bl4 ? 19 : (n4 == 889 ? (this.m_afcmiParameterMarkers[n - 1].getCharsetCode() == 1 ? this.m_session.getConfigResponse().getMaxJsonLatinCharCount() : this.m_session.getConfigResponse().getMaxJsonUnicodeCharCount()) : (n4 == 689 || n4 == 697 || n4 == 449 || n4 == 457 || n4 == 505 ? 0 : (n4 == 405 || n4 == 421 || n4 == 857 || n4 == 869 ? (int)this.m_afcmiParameterMarkers[n - 1].getMaxDataLengthInBytes() : byArray.length)));
            this.m_paramProperties.setCurrentParameter(n, null, byArray, n4, true, bl4 ? -128 : 0, n3, n9);
        }
    }

    public static byte[] spacesForNullValue(int n, boolean bl, int n2, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        int n3;
        if (bl) {
            int n4 = Encoder.encodeStringParameter(genericTeradataConnection, n, " ").length;
            n3 = n2 / n4;
        } else {
            n3 = n2;
        }
        char[] cArray = new char[n3];
        Arrays.fill(cArray, ' ');
        return Encoder.encodeStringParameter(genericTeradataConnection, n, new String(cArray));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.setCurrentParameter(n, new Boolean(bl), ByteConverter.putBoolean(bl), 757, false, 0, 0, 1L);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.setCurrentParameter(n, new Byte(by), ByteConverter.putByte(by), 757, false, 0, 0, 1L);
    }

    public void setShort(int n, short s) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.setCurrentParameter(n, new Short(s), ByteConverter.putShort(s), 501, false, 0, 0, 2L);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.setCurrentParameter(n, new Integer(n2), ByteConverter.putInt(n2), 497, false, 0, 0, 4L);
    }

    public void setLong(int n, long l) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (this.m_session.isLargeDecimalAndBigIntSupported()) {
            this.m_paramProperties.setCurrentParameter(n, new Long(l), ByteConverter.putLong(l), 600, false, 0, 0, 8L);
        } else {
            BigInteger bigInteger = new BigInteger(Long.toString(l));
            int n2 = bigInteger.abs().toString().length();
            if (n2 > 18) {
                throw ErrorFactory.makeTDDataTruncation("TJ433", n, true, false, bigInteger.toString().length(), 0, n2);
            }
            this.m_paramProperties.setDecimalParameter(n, new Long(l), ByteConverter.putLong(l), 485, false, 18, 0, 0);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, (double)Double.valueOf(Float.toString(f)));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.setCurrentParameter(n, new Double(d), ByteConverter.putDouble(d), 481, false, 0, 0, 8L);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.m_session.isNumberDataTypeSupported()) {
            this.internalSetNumeric(n, bigDecimal);
        } else {
            this.internalSetBigDecimal(n, bigDecimal);
        }
    }

    private void internalSetBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2;
        this.m_paramProperties.verifyParamMarker(n);
        if (bigDecimal == null) {
            this.setNull(n, 3);
            return;
        }
        int n3 = 0;
        if (bigDecimal.compareTo(BigDecimal.valueOf(0L)) == 0) {
            n2 = 0;
        } else {
            int n4;
            int n5 = 18;
            if (this.m_session.isLargeDecimalAndBigIntSupported()) {
                n5 = 38;
            }
            if ((n2 = bigDecimal.scale()) < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n2 = bigDecimal.scale();
            }
            int n6 = bigDecimal.compareTo(BigDecimal.valueOf(1L)) == -1 && bigDecimal.compareTo(BigDecimal.valueOf(-1L)) == 1 ? n2 : bigDecimal.abs().unscaledValue().toString().length();
            n3 = ComUtil.getSignificantDigits(bigDecimal);
            if (n3 > n5) {
                throw ErrorFactory.makeTDDataTruncation("TJ433", n, true, false, bigDecimal.abs().unscaledValue().toByteArray().length, 0, n6);
            }
            if (n6 > n5) {
                if ((n2 = n5 - (n6 - n2)) < 0) {
                    n2 = 0;
                }
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
            bigDecimal = bigDecimal.movePointRight(n2);
            String string = bigDecimal.toString();
            int n7 = string.length();
            if (bigDecimal.compareTo(BigDecimal.valueOf(0L)) == 0) {
                n2 = 0;
            }
            for (n4 = n7; n4 > n7 - n2 && string.charAt(n4 - 1) == '0'; --n4) {
            }
            if (n4 < n7) {
                bigDecimal = new BigDecimal(string.substring(0, n4));
                n2 -= n7 - n4;
            }
        }
        this.m_paramProperties.setDecimalParameter(n, bigDecimal, this.m_session.isLargeDecimalAndBigIntSupported() ? ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), 16) : ByteConverter.putLong(bigDecimal.longValue()), 485, false, this.m_session.isLargeDecimalAndBigIntSupported() ? 38 : 18, n2, n3);
    }

    public void internalSetNumeric(int n, BigDecimal bigDecimal) throws SQLException {
        byte[] byArray;
        this.m_paramProperties.verifyParamMarker(n);
        if (bigDecimal == null) {
            this.setNull(n, 2);
            return;
        }
        int n2 = bigDecimal.scale();
        if (bigDecimal.compareTo(BigDecimal.valueOf(0L)) == 0) {
            byArray = new byte[]{0};
            n2 = 0;
        } else {
            int n3;
            int n4 = 40;
            int n5 = bigDecimal.abs().unscaledValue().toString().length();
            if (n5 > n4 && n5 - n4 - n2 > 0) {
                int n6 = n5 - n4 - n2;
                bigDecimal = bigDecimal.movePointLeft(n6);
                bigDecimal = new BigDecimal(bigDecimal.toBigInteger());
                bigDecimal = bigDecimal.movePointRight(n6);
                n2 = 0;
            } else if (n5 > n4 && n5 - n4 - n2 <= 0) {
                n2 = n4 - (n5 - n2);
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
            String string = bigDecimal.unscaledValue().toString();
            int n7 = n3 = string.length();
            while (string.charAt(n7 - 1) == '0') {
                --n7;
            }
            if (n7 < n3) {
                n2 -= n3 - n7;
                bigDecimal = new BigDecimal(string.substring(0, n7));
            }
            BigInteger bigInteger = bigDecimal.unscaledValue();
            byte by = (byte)(bigInteger.toByteArray().length + 2);
            byArray = new byte[by + 1];
            byArray[0] = by;
            ByteConverter.putShort(byArray, 1, (short)n2);
            ByteConverter.bigIntToByteArray(bigInteger, byArray, 3);
        }
        this.m_paramProperties.setCurrentParameter(n, bigDecimal, byArray, 605, false, -128, -128, 19L);
    }

    public void setString(int n, String string) throws SQLException {
        this.internalSetString(n, -1, null, string);
    }

    public void internalSetString(int n, int n2, String[] stringArray, String string) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        ParameterProperties.ParameterSet parameterSet = this.m_paramProperties.getCurrentParamSet();
        boolean bl = parameterSet.isArrayElements();
        byte[] byArray = Encoder.encodeStringParameter(this.m_session, bl ? parameterSet.getArrayParameterIndex(n) : n, n2, stringArray, bl ? parameterSet.getArrayElementIndex(n) : null, string);
        int n3 = byArray.length;
        if (n3 > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(n3));
        }
        byte[] byArray2 = ByteConverter.copyByteArrayAddLengthPrefix(byArray);
        this.m_paramProperties.setCurrentParameter(n, string, byArray2, 449, false, 0, 0, n3);
    }

    private void internalSetFixedWidthBytes(int n, byte[] byArray, int n2) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (byArray.length > n2) {
            throw ErrorFactory.makeTDDataTruncation("TJ785", n, true, false, byArray.length, n2);
        }
        if (byArray.length > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(byArray.length));
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.m_paramProperties.setCurrentParameter(n, byArray2, byArray2, 693, false, 0, 0, byArray2.length);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        if (byArray.length > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(byArray.length));
        }
        int n2 = byArray.length;
        byte[] byArray2 = ByteConverter.copyByteArrayAddLengthPrefix(byArray);
        this.m_paramProperties.setCurrentParameter(n, byArray, byArray2, 689, false, 0, 0, n2);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (calendar != null) {
            date = TDResultSet.convertDateWithTimeZoneToGMT(n, date, calendar);
        }
        if (this.m_session.shouldSendAnsiDate()) {
            byte[] byArray = Encoder.encodeStringParameter(this.m_session, n, date.toString());
            this.m_paramProperties.setCurrentParameter(n, date, byArray, 749, false, 0, 0, byArray.length);
        } else {
            int n2 = (Integer.valueOf(String.valueOf(date).substring(0, 4)) - 1900) * 10000 + Integer.valueOf(String.valueOf(date).substring(5, 7)) * 100 + Integer.valueOf(String.valueOf(date).substring(8, 10));
            this.m_paramProperties.setCurrentParameter(n, date, ByteConverter.putInt(n2), this.m_session.isStatementInfoRequestSupported() ? 753 : 497, false, 0, 0, 4L);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.internalSetAsciiStream(n, -1, null, inputStream, n2);
    }

    public void internalSetAsciiStream(int n, int n2, String[] stringArray, InputStream inputStream, int n3) throws SQLException {
        this.internalSetCharacterStream(n, n2, stringArray, inputStream == null ? null : new AsciiStreamReader(this.m_session, n, n2, stringArray, inputStream, n3), n3);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        InputStreamReader inputStreamReader;
        if (inputStream == null) {
            this.setNull(n, 2005);
            return;
        }
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ212", "UTF8");
        }
        this.setCharacterStream(n, (Reader)inputStreamReader, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        this.m_paramProperties.verifyParamMarker(n);
        if (n2 < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ166", n2);
        }
        this.m_paramProperties.setDeferredLobParameter(n, -1, null, inputStream, 405, n2, this.m_afcmiParameterMarkers[n - 1].getTransmitMetadataItemNumber());
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n2 == -2) {
            if (object == null) {
                this.internalSetNull(n, n2, n3, 693, false);
            } else {
                this.internalSetFixedWidthBytes(n, (byte[])object, n3);
            }
        } else if (n2 == 3 || n2 == 2) {
            int n4;
            this.m_paramProperties.verifyParamMarker(n);
            boolean bl = n2 == 2 && this.m_session.isNumberDataTypeSupported();
            int n5 = n4 = this.m_session.isLargeDecimalAndBigIntSupported() ? 38 : 18;
            if (!(bl || n3 >= 0 && n3 <= n4)) {
                throw ErrorFactory.makeDriverJDBCException("TJ431", n, n3, n4);
            }
            if (object == null) {
                this.internalSetNull(n, n2, n3, bl ? 605 : 485, false);
            } else {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = object instanceof BigDecimal ? (BigDecimal)object : new BigDecimal(object.toString());
                if (bl) {
                    this.internalSetNumeric(n, bigDecimal);
                } else {
                    int n6 = ComUtil.getSignificantDigits(bigDecimal);
                    int n7 = n6 + n3;
                    if (n7 > n4) {
                        throw ErrorFactory.makeTDDataTruncation("TJ433", n, true, false, bigDecimal.abs().unscaledValue().toByteArray().length, 0, n7);
                    }
                    bigDecimal = bigDecimal.setScale(n3, 4).movePointRight(n3);
                    this.m_paramProperties.setDecimalParameter(n, bigDecimal, this.m_session.isLargeDecimalAndBigIntSupported() ? ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), 16) : ByteConverter.putLong(bigDecimal.longValue()), 485, false, n4, n3, n6);
                }
            }
        } else {
            this.setObject(n, object, n2);
        }
    }

    private static Date toDate(String string, int n, int n2) throws SQLException {
        try {
            return Date.valueOf(string);
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    private static Time toTime(String string, int n, int n2) throws SQLException {
        try {
            return Time.valueOf(string);
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    private static Timestamp toTimestamp(String string, int n, int n2) throws SQLException {
        try {
            return Timestamp.valueOf(string);
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ553", n, n2);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null && n2 != 2002 && n2 != 2001) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -6: {
                this.setByte(n, Byte.parseByte(object.toString()));
                return;
            }
            case 5: {
                this.setShort(n, Short.parseShort(object.toString()));
                return;
            }
            case 4: {
                this.setInt(n, Integer.parseInt(object.toString()));
                return;
            }
            case -5: {
                this.setLong(n, Long.parseLong(object.toString()));
                return;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = Double.valueOf(object.toString());
                this.setDouble(n, d);
                return;
            }
            case 2: {
                if (this.m_session.isNumberDataTypeSupported()) {
                    this.internalSetNumeric(n, new BigDecimal(object.toString()));
                } else {
                    this.internalSetBigDecimal(n, new BigDecimal(object.toString()));
                }
                return;
            }
            case 3: {
                this.internalSetBigDecimal(n, new BigDecimal(object.toString()));
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, object.toString());
                return;
            }
            case 91: {
                Date date = object instanceof Date ? (Date)object : (object instanceof java.util.Date ? new Date(((java.util.Date)object).getTime()) : TDPreparedStatement.toDate(object.toString(), n, n2));
                this.setDate(n, date);
                return;
            }
            case 92: {
                Time time = object instanceof Time ? (Time)object : (object instanceof java.util.Date ? new Time(((java.util.Date)object).getTime()) : TDPreparedStatement.toTime(object.toString(), n, n2));
                this.setTime(n, time);
                return;
            }
            case 93: {
                Timestamp timestamp = object instanceof Timestamp ? (Timestamp)object : (object instanceof java.util.Date ? new Timestamp(((java.util.Date)object).getTime()) : TDPreparedStatement.toTimestamp(object.toString(), n, n2));
                this.setTimestamp(n, timestamp);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    if (n2 == -2) {
                        this.internalSetFixedWidthBytes(n, byArray, byArray.length);
                    } else {
                        this.setBytes(n, byArray);
                    }
                    return;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ167", object.getClass().getName());
            }
            case 2004: {
                if (object instanceof Blob) {
                    this.setBlob(n, (Blob)object);
                    return;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ220", object.getClass().getName());
            }
            case 2005: {
                if (object instanceof Clob) {
                    this.setClob(n, (Clob)object);
                    return;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ221", object.getClass().getName());
            }
            case 2002: {
                this.internalSetStruct(n, object);
                return;
            }
            case 2001: {
                if (object == null) {
                    this.setNull(n, JDBC4Constants.getJavaSQLType(this.m_afcmiParameterMarkers[n - 1].getDataType()));
                } else if (object instanceof SQLData) {
                    this.setMappedDistinct(n, (SQLData)object, this.m_afcmiParameterMarkers);
                } else {
                    this.setObject(n, object);
                }
                return;
            }
            case 2003: {
                this.setArray(n, (Array)object);
                return;
            }
            case 2009: {
                this.internalSetSQLXML(n, -1, null, (TeraSQLXML)object);
                return;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ374");
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof String) {
            this.setString(n, object.toString());
        } else if (object instanceof Short) {
            this.setShort(n, (short)((Short)object));
        } else if (object instanceof Long) {
            this.setLong(n, (long)((Long)object));
        } else if (object instanceof Integer) {
            this.setInt(n, (int)((Integer)object));
        } else if (object instanceof Byte) {
            this.setByte(n, (byte)((Byte)object));
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n, (boolean)((Boolean)object));
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(n, (double)((Double)object));
        } else if (object instanceof Blob) {
            this.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            this.setClob(n, (Clob)object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof SQLData && JDBC4Constants.getJavaSQLType(this.m_afcmiParameterMarkers[n - 1].getDataType()) != 2002) {
            this.setMappedDistinct(n, (SQLData)object, this.m_afcmiParameterMarkers);
        } else if (object instanceof Struct || object instanceof SQLData) {
            this.internalSetStruct(n, object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object instanceof TeraSQLXML) {
            this.internalSetSQLXML(n, -1, null, (TeraSQLXML)object);
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ230", object.getClass().getName());
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.internalSetCharacterStream(n, -1, null, reader, n2);
    }

    public void internalSetCharacterStream(int n, int n2, String[] stringArray, Reader reader, int n3) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        if (reader == null) {
            this.setNull(n, 2005);
            return;
        }
        if (n3 < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ171", n3);
        }
        this.m_paramProperties.setDeferredLobParameter(n, n2, stringArray, reader, 421, n3, this.m_afcmiParameterMarkers[n - 1].getTransmitMetadataItemNumber());
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ172");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        if (((LocatorBlob)((Object)blob)).locatorIsStale()) {
            ((LocatorBlob)((Object)blob)).refreshStaleLocator();
        }
        byte[] byArray = TDPreparedStatement.getLocatorWithLength(((LocatorBlob)((Object)blob)).getLocator());
        this.m_paramProperties.setCurrentParameter(n, blob, byArray, 409, false, 0, 0, 2097088000L);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(n, 2005);
            return;
        }
        if (((LocatorClob)((Object)clob)).locatorIsStale()) {
            ((LocatorClob)((Object)clob)).refreshStaleLocator();
        }
        byte[] byArray = TDPreparedStatement.getLocatorWithLength(((LocatorClob)((Object)clob)).getLocator());
        this.m_paramProperties.setCurrentParameter(n, clob, byArray, 425, false, 0, 0, 2097088000L);
    }

    protected static byte[] getLocatorWithLength(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 2];
        byArray2[1] = (byte)(n & 0xFF);
        byArray2[0] = (byte)(n >> 8);
        System.arraycopy(byArray, 0, byArray2, 2, n);
        return byArray2;
    }

    public void internalSetSQLXML(int n, int n2, String[] stringArray, TeraSQLXML teraSQLXML) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArray(int n, Array array) throws SQLException {
        int n2;
        int n3;
        if (!this.m_session.isArrayDataTypeSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ174", this.m_session.getTeradataDatabaseVersion());
        }
        this.m_paramProperties.verifyParamMarker(n);
        String string = this.m_afcmiParameterMarkers[n - 1].getUdtTypeName();
        if (string == null || string.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ755", n);
        }
        if (array != null && !(array.getArray() instanceof Object[])) {
            throw ErrorFactory.makeDriverJDBCException("TJ753", String.valueOf(n), String.valueOf(array.getArray()));
        }
        if (array != null && array.getBaseTypeName() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ754", n);
        }
        if (array == null) {
            this.internalSetNull(n, 2003, 0, 505, false);
        }
        Object[] objectArray = array == null ? new Object[]{} : (Object[])array.getArray();
        int[] nArray = this.m_afcmiParameterMarkers[n - 1].getArrayMaxCardinalities();
        int n4 = n3 = array == null ? 0 : nArray.length;
        if (array != null && n3 != (n2 = ClientArray.calculateArrayDimensions(objectArray))) {
            throw ErrorFactory.makeDriverJDBCException("TJ750", n, n2, n3);
        }
        n2 = ClientArray.calculateTotNumOfElements(objectArray, n3);
        this.verifyArray(n, objectArray, n3, nArray, array == null ? 0 : n2 - nArray[n3 - 1], 0);
        this.m_paramProperties.setCurrentParameter(n, "", new byte[]{}, n3 > 1 ? 509 : 505, array == null || array.getArray() == null, 0, 0, 0L);
        this.m_paramProperties.getCurrentDataInfoField(n).setArrayCardinalities(nArray);
        this.m_paramProperties.getCurrentDataInfoField(n).setFullyQualifiedTypeName(string);
        ParameterProperties parameterProperties = ParameterProperties.createParameterPropertiesForArrayElements(this.m_paramProperties, n2, array == null || array.getArray() == null);
        ParameterProperties parameterProperties2 = this.m_paramProperties;
        this.m_paramProperties = parameterProperties;
        try {
            FullContentMetadataItem[] fullContentMetadataItemArray = this.m_afcmiParameterMarkers;
            this.m_afcmiParameterMarkers = this.m_afcmiParameterMarkers[n - 1].getAttributeItemArray();
            try {
                boolean bl = this.m_afcmiParameterMarkers == null || this.m_afcmiParameterMarkers.length == 0;
                int n5 = ClientArray.determineBaseType(n3, objectArray, bl ? 0 : JDBC4Constants.getJavaSQLType(this.m_afcmiParameterMarkers[0].getDataType()), bl);
                this.setArrayElements(n, new int[n3], objectArray, n5, 1, n3, bl ? null : this.m_afcmiParameterMarkers[0]);
                this.m_paramProperties.getCurrentParamSet().calculateAndSetArrayElementsAndAttributes();
                this.m_paramProperties.getCurrentParamSet().createNullIndicatorBitArray();
            }
            finally {
                this.m_afcmiParameterMarkers = fullContentMetadataItemArray;
            }
            Object var15_14 = null;
            this.m_paramProperties = parameterProperties2;
            this.m_paramProperties.getCurrentDataInfoField(n).setAttributes(parameterProperties.getCurrentDataInfoFields());
            this.m_paramProperties.getCurrentParamSet().setAttributeParamSet(n, parameterProperties.getCurrentParamSet());
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.m_paramProperties = parameterProperties2;
            this.m_paramProperties.getCurrentDataInfoField(n).setAttributes(parameterProperties.getCurrentDataInfoFields());
            this.m_paramProperties.getCurrentParamSet().setAttributeParamSet(n, parameterProperties.getCurrentParamSet());
            throw throwable;
        }
    }

    private int setArrayElements(int n, int[] nArray, Object[] objectArray, int n2, int n3, int n4, FullContentMetadataItem fullContentMetadataItem) throws SQLException {
        if (objectArray.length == 0) {
            this.setNull(1, n2);
        }
        int n5 = 1;
        while (n5 <= objectArray.length) {
            nArray[n4 - 1] = n5 - 1;
            this.m_paramProperties.getCurrentParamSet().setArrayParameterIndex(n3, n);
            this.m_paramProperties.getCurrentParamSet().setArrayElementIndex(n3, nArray);
            if (n4 > 1) {
                n3 = this.setArrayElements(n, nArray, (Object[])objectArray[n5 - 1], n2, n3, n4 - 1, fullContentMetadataItem);
            } else if (objectArray[n5 - 1] instanceof Struct || objectArray[n5 - 1] instanceof SQLData || objectArray[n5 - 1] == null && n2 == 2002) {
                if (fullContentMetadataItem == null) {
                    this.setStruct(n3, objectArray[n5 - 1], -1);
                } else {
                    this.setStruct(n3, objectArray[n5 - 1], 0);
                }
            } else if (objectArray[n5 - 1] == null) {
                this.setNull(n3, n2);
            } else {
                this.setObject(n3, objectArray[n5 - 1], n2);
            }
            ++n5;
            ++n3;
        }
        return n3 - 1;
    }

    private int verifyArray(int n, Object[] objectArray, int n2, int[] nArray, int n3, int n4) throws SQLException {
        if (n2 == 0) {
            return 0;
        }
        if (objectArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ756", n, n2);
        }
        if (objectArray.length > nArray[nArray.length - n2]) {
            throw ErrorFactory.makeDriverJDBCException("TJ746", n, n2, objectArray.length, nArray[nArray.length - n2]);
        }
        if (n2 == 1 && n4 < n3 && objectArray.length != nArray[nArray.length - 1]) {
            throw ErrorFactory.makeDriverJDBCException("TJ757", n, n2, nArray[nArray.length - 1], objectArray.length);
        }
        int n5 = 0;
        while (n5 < objectArray.length) {
            if (n2 > 1) {
                n4 = this.verifyArray(n, (Object[])objectArray[n5], n2 - 1, nArray, n3, n4);
            }
            ++n5;
            ++n4;
        }
        return n4;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        int n2;
        this.m_paramProperties.verifyParamMarker(n);
        int n3 = this.m_session.isStatementInfoRequestSupported() ? (calendar != null ? 769 : 761) : (n2 = 453);
        if (time == null) {
            this.internalSetNull(n, 92, 0, n2, calendar != null);
            return;
        }
        int n4 = 0;
        if (calendar != null) {
            n4 = 6;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(time.getTime());
        int n5 = gregorianCalendar.get(14);
        String string = String.valueOf(n5);
        if (n5 < 10) {
            string = "00" + n5;
        } else if (n5 < 100) {
            string = "0" + n5;
        }
        int n6 = this.m_session.getURLParameters().getTimeNano();
        int n7 = this.getNanoString(n5 * 1000 * 1000, n6).length();
        int n8 = n6 == -1 ? (n7 == 0 ? 0 : n7 + 1) : (n6 == 0 ? 0 : n6 + 1);
        StringBuffer stringBuffer = new StringBuffer(8 + n8 + n4);
        String string2 = time.toString() + "." + string;
        int n9 = string2.length() > stringBuffer.capacity() - n4 ? stringBuffer.capacity() - n4 : string2.length();
        stringBuffer.append(string2.toCharArray(), 0, n9);
        for (int i = n9; i < stringBuffer.capacity() - n4; ++i) {
            stringBuffer.append('0');
        }
        if (calendar != null) {
            stringBuffer.append(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
        }
        byte[] byArray = Encoder.encodeStringParameter(this.m_session, n, stringBuffer.toString());
        this.m_paramProperties.setCurrentParameter(n, time, byArray, n2, false, 0, n6 == -1 ? n7 : n6, byArray.length);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n2;
        this.m_paramProperties.verifyParamMarker(n);
        int n3 = this.m_session.isStatementInfoRequestSupported() ? (calendar != null ? 773 : 765) : (n2 = 453);
        if (timestamp == null) {
            this.internalSetNull(n, 93, 0, n2, calendar != null);
            return;
        }
        int n4 = timestamp.getNanos();
        String string = timestamp.toString();
        String string2 = string.substring(0, string.lastIndexOf(46) + 1);
        int n5 = this.m_session.getURLParameters().getTimestampNano();
        String string3 = this.getNanoString(n4, n5);
        int n6 = string2.length();
        if (string3.length() > 0) {
            string2 = string2.concat(string3);
        } else if (string2.charAt(n6 - 1) == '.') {
            string2 = string2.substring(0, n6 - 1);
        }
        if (calendar != null) {
            string2 = string2.concat(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
        }
        byte[] byArray = Encoder.encodeStringParameter(this.m_session, n, string2);
        this.m_paramProperties.setCurrentParameter(n, timestamp, byArray, n2, false, 0, n5 == -1 ? string3.length() : n5, byArray.length);
    }

    private final String getNanoString(int n, int n2) {
        int n3;
        int n4;
        if (n != 0) {
            n4 = 9 - String.valueOf(n).length();
            if (n4 > 5) {
                n = 0;
                n4 = 0;
            }
        } else {
            n4 = 0;
        }
        String string = String.valueOf(n);
        int n5 = string.length();
        if (n2 != -1) {
            if (n5 + n4 < n2) {
                int n6 = n2 - n5;
                for (n3 = 0; n3 < n6; ++n3) {
                    string = string.concat("0");
                }
            }
            if (n2 < n4) {
                n4 = n2;
            }
            n5 = n2 - n4 - 1;
        } else {
            for (n5 = string.length() - 1; n5 >= 0 && string.charAt(n5) == '0'; --n5) {
            }
        }
        if (n5 + n4 > 5) {
            n5 = 5 - n4;
        }
        string = string.substring(0, n5 + 1);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.insert(0, '0');
        }
        string = stringBuffer.toString();
        return string;
    }

    public static String formatCalendarTimeZone(int n, Calendar calendar) throws SQLException {
        TDResultSet.validateCalendarTimeZone(n, calendar);
        return TDPreparedStatement.formatTimeZone(calendar.getTimeZone());
    }

    public static String formatTimeZone(TimeZone timeZone) {
        int n;
        char c = '+';
        StringBuffer stringBuffer = new StringBuffer(6);
        int n2 = n % 60 * ((n = timeZone.getRawOffset() / 60000) < 0 ? -1 : 1);
        int n3 = n / 60 * (n < 0 ? -1 : 1);
        if (n < 0) {
            c = '-';
        }
        stringBuffer.append(c);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(String.valueOf(n3)).append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(String.valueOf(n2));
        return stringBuffer.toString();
    }

    public String getOriginalSql() {
        return this.m_paramProperties.getOriginalSql();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setURL");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.m_session.constructParameterMetaData(this);
    }

    public void setMappedDistinct(int n, SQLData sQLData, FullContentMetadataItem[] fullContentMetadataItemArray) throws SQLException {
        if (sQLData == null) {
            int n2 = JDBC4Constants.getJavaSQLType(fullContentMetadataItemArray[n - 1].getDataType());
            if (n2 == -2) {
                n2 = -3;
            }
            this.setNull(n, n2);
            return;
        }
        TeraSQLOutput teraSQLOutput = this.m_session.constructSQLOutput(this, new FullContentMetadataItem[]{fullContentMetadataItemArray[n - 1]}, n, sQLData.getClass());
        sQLData.writeSQL((SQLOutput)((Object)teraSQLOutput));
        if (teraSQLOutput.getNumberOfAttributesWritten() < n) {
            throw ErrorFactory.makeDriverJDBCException("TJ682", sQLData.getClass().getName() + ".writeSQL", "0", "1");
        }
    }

    private void internalSetStruct(int n, Object object) throws SQLException {
        if (!this.m_session.isUDTTransformOffSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ636");
        }
        this.m_paramProperties.verifyParamMarker(n);
        try {
            this.setStruct(n, object, n - 1);
        }
        catch (SQLException sQLException) {
            this.m_paramProperties.getCurrentParamSet().clearParameter(n);
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStruct(int n, Object object, int n2) throws SQLException {
        short s;
        int n3;
        Object object2;
        int n4;
        if (object instanceof Struct && (n4 = JDBC4Constants.getNullableTDTypeCodeForStructCompatibleBuiltInType((object2 = (Struct)object).getSQLTypeName())) != 0) {
            this.processBuiltInTypeViaStruct(n, (Struct)object2, n4);
            return;
        }
        if (object == null) {
            this.internalSetNull(n, 2002, 0, 441, false);
        } else {
            this.m_paramProperties.setCurrentParameter(n, "", new byte[0], 441, false, 0, 0, 0L);
        }
        object2 = null;
        if (n2 >= 0) {
            object2 = this.m_afcmiParameterMarkers[n2].getUdtTypeName();
        } else if (object instanceof Struct) {
            object2 = ((Struct)object).getSQLTypeName();
        }
        this.m_paramProperties.getCurrentDataInfoField(n).setFullyQualifiedTypeName((String)object2);
        Object[] objectArray = object == null || object instanceof SQLData ? null : ((Struct)object).getAttributes();
        FullContentMetadataItem[] fullContentMetadataItemArray = null;
        if (n2 >= 0) {
            fullContentMetadataItemArray = this.m_afcmiParameterMarkers[n2].getAttributeItemArray();
        }
        int n5 = objectArray == null ? (fullContentMetadataItemArray == null ? 0 : fullContentMetadataItemArray.length) : (fullContentMetadataItemArray == null ? 0 : (n3 = fullContentMetadataItemArray.length <= objectArray.length ? fullContentMetadataItemArray.length : objectArray.length));
        if (objectArray != null && fullContentMetadataItemArray != null && (objectArray.length == 0 && fullContentMetadataItemArray.length == 0 || objectArray.length != fullContentMetadataItemArray.length) || objectArray == null && fullContentMetadataItemArray != null && fullContentMetadataItemArray.length == 0) {
            if (object == null && objectArray == null && fullContentMetadataItemArray != null && fullContentMetadataItemArray.length == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ842", n);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ841", object == null ? null : object.getClass().getName() + ".getAttributes", objectArray == null ? null : String.valueOf(objectArray.length), (String)(object == null ? null : ("".equals(object2) ? ((Struct)object).getSQLTypeName() : object2)), String.valueOf(fullContentMetadataItemArray.length));
        }
        ParameterProperties parameterProperties = ParameterProperties.createParameterPropertiesForAttributes(this.m_paramProperties, this.m_paramProperties.processingArrayElements() && this.m_paramProperties.getCurrentDataInfoFields() != null && this.m_paramProperties.getCurrentDataInfoField(n) != null ? this.m_paramProperties.getCurrentDataInfoField(n).getAttributeFieldArray() : null, n3);
        ParameterProperties parameterProperties2 = this.m_paramProperties;
        this.m_paramProperties = parameterProperties;
        try {
            FullContentMetadataItem[] fullContentMetadataItemArray2 = this.m_afcmiParameterMarkers;
            this.m_afcmiParameterMarkers = fullContentMetadataItemArray;
            try {
                if (object != null && object instanceof SQLData) {
                    TeraSQLOutput teraSQLOutput = this.m_session.constructSQLOutput(this, fullContentMetadataItemArray, 1, object.getClass());
                    ((SQLData)object).writeSQL((SQLOutput)((Object)teraSQLOutput));
                    if (teraSQLOutput.getNumberOfAttributesWritten() < n3) {
                        throw ErrorFactory.makeDriverJDBCException("TJ682", object.getClass().getName() + ".writeSQL", String.valueOf(teraSQLOutput.getNumberOfAttributesWritten()), String.valueOf(n3));
                    }
                } else {
                    for (int i = 1; i <= n3 && i <= fullContentMetadataItemArray.length; ++i) {
                        this.setAttributeObject(i, objectArray == null ? null : objectArray[i - 1], fullContentMetadataItemArray);
                    }
                }
            }
            finally {
                this.m_afcmiParameterMarkers = fullContentMetadataItemArray2;
            }
            Object var14_15 = null;
            this.m_paramProperties = parameterProperties2;
            this.m_paramProperties.getCurrentDataInfoField(n).setAttributes(parameterProperties.getCurrentDataInfoFields());
            if (!this.m_paramProperties.getCurrentParamSet().isParentArrayNull()) {
                this.m_paramProperties.getCurrentParamSet().setAttributeParamSet(n, parameterProperties.getCurrentParamSet());
            }
            s = n2 == -1 ? (short)0 : this.m_afcmiParameterMarkers[n2].getServerDataType();
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.m_paramProperties = parameterProperties2;
            this.m_paramProperties.getCurrentDataInfoField(n).setAttributes(parameterProperties.getCurrentDataInfoFields());
            if (!this.m_paramProperties.getCurrentParamSet().isParentArrayNull()) {
                this.m_paramProperties.getCurrentParamSet().setAttributeParamSet(n, parameterProperties.getCurrentParamSet());
            }
            short s2 = n2 == -1 ? (short)0 : this.m_afcmiParameterMarkers[n2].getServerDataType();
            this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType(s2 == 0 ? (short)0 : JDBC4Constants.getServerDataType(parameterProperties.getCurrentParamSet().getSqlType(1)));
            throw throwable;
        }
        this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType(s == 0 ? (short)0 : JDBC4Constants.getServerDataType(parameterProperties.getCurrentParamSet().getSqlType(1)));
    }

    private void setAttributeObject(int n, Object object, FullContentMetadataItem[] fullContentMetadataItemArray) throws SQLException {
        if (object instanceof SQLData && fullContentMetadataItemArray[n - 1].isDistinct()) {
            this.setMappedDistinct(n, (SQLData)object, fullContentMetadataItemArray);
        } else if (object instanceof Struct || object instanceof SQLData || object == null && fullContentMetadataItemArray[n - 1].isStruct()) {
            this.setStruct(n, object, n - 1);
        } else if (object == null) {
            int n2 = JDBC4Constants.getJavaSQLType(fullContentMetadataItemArray[n - 1].getDataType());
            if (n2 == 3) {
                n2 = 2;
            } else if (n2 == -2) {
                n2 = -3;
            }
            switch (n2) {
                case 2004: 
                case 2005: {
                    this.internalSetNull(n, n2, 0, JDBC4Constants.getTDBasicType(fullContentMetadataItemArray[n - 1].getDataType()) + 1, false);
                    break;
                }
                default: {
                    this.setNull(n, n2);
                    break;
                }
            }
        } else {
            this.setObject(n, object);
        }
        this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType(fullContentMetadataItemArray[n - 1].getServerDataType());
    }

    private void processBuiltInTypeViaStruct(int n, Struct struct, int n2) throws SQLException {
        String string = struct.getSQLTypeName().trim().toUpperCase();
        Object[] objectArray = struct.getAttributes();
        if (objectArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ730", string);
        }
        if (objectArray.length == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ797", string);
        }
        if ("TIME WITH TIME ZONE".equals(string)) {
            if (objectArray.length != 2) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "2");
            }
            if (objectArray[0] != null && !(objectArray[0] instanceof Time)) {
                throw ErrorFactory.makeDriverJDBCException("TJ729", string, "1", objectArray[0].getClass().getName(), "java.sql.Time");
            }
            if (objectArray[1] != null && !(objectArray[1] instanceof Calendar)) {
                throw ErrorFactory.makeDriverJDBCException("TJ729", string, "2", objectArray[1].getClass().getName(), "java.util.Calendar");
            }
            this.setTime(n, (Time)objectArray[0], (Calendar)objectArray[1]);
        } else if ("TIMESTAMP WITH TIME ZONE".equals(string)) {
            if (objectArray.length != 2) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "2");
            }
            if (objectArray[0] != null && !(objectArray[0] instanceof Timestamp)) {
                throw ErrorFactory.makeDriverJDBCException("TJ729", string, "1", objectArray[0].getClass().getName(), "java.sql.Timestamp");
            }
            if (objectArray[1] != null && !(objectArray[1] instanceof Calendar)) {
                throw ErrorFactory.makeDriverJDBCException("TJ729", string, "2", objectArray[1].getClass().getName(), "java.util.Calendar");
            }
            this.setTimestamp(n, (Timestamp)objectArray[0], (Calendar)objectArray[1]);
        } else if ("JSON".equals(string)) {
            if (!this.m_session.isJsonUsable()) {
                throw ErrorFactory.makeDriverJDBCException("TJ758");
            }
            Object object = objectArray[0];
            if (object == null && objectArray.length == 1) {
                this.internalSetNull(n, 1111, 0, 889, false);
                return;
            }
            if (object == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
            }
            if (object instanceof LocatorClob) {
                if (objectArray.length != 1) {
                    throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                }
                if (((LocatorClob)object).locatorIsStale()) {
                    ((LocatorClob)object).refreshStaleLocator();
                }
                byte[] byArray = TDPreparedStatement.getLocatorWithLength(((LocatorClob)object).getLocator());
                int n3 = this.m_afcmiParameterMarkers[n - 1].getCharsetCode() == 1 ? this.m_session.getConfigResponse().getMaxJsonLatinCharCount() : this.m_session.getConfigResponse().getMaxJsonUnicodeCharCount();
                this.m_paramProperties.setCurrentParameter(n, object, byArray, 885, false, 0, 0, n3);
            } else {
                int n4;
                if (object instanceof Reader) {
                    if (objectArray.length != 2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "2");
                    }
                    if (!(objectArray[1] instanceof Integer)) {
                        throw ErrorFactory.makeDriverJDBCException("TJ729", string, "2", objectArray[1].getClass().getName(), "java.lang.Integer");
                    }
                    n4 = (Integer)objectArray[1];
                    if (n4 < 0) {
                        throw ErrorFactory.makeDriverJDBCException("TJ786", n, n4);
                    }
                } else if (object instanceof String) {
                    if (objectArray.length != 1) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                    }
                    n4 = ((String)object).length();
                    object = new StringReader((String)object);
                } else {
                    throw ErrorFactory.makeDriverJDBCException("TJ796", string, "1", object.getClass().getName());
                }
                this.m_paramProperties.setDeferredLobParameter(n, -1, null, (Reader)object, 889, n4, this.m_afcmiParameterMarkers[n - 1].getTransmitMetadataItemNumber());
                this.m_paramProperties.getCurrentParamSet().setServerCharsetCode(n, this.m_afcmiParameterMarkers[n - 1].getCharsetCode());
            }
        } else if ("DATASET STORAGE FORMAT AVRO".equals(string)) {
            if (!this.m_session.isAvroDataSetUsable()) {
                throw ErrorFactory.makeDriverJDBCException("TJ817", "AVRO");
            }
            Object object = objectArray[0];
            if (object == null && objectArray.length == 1) {
                this.internalSetNull(n, 1111, 0, 405, false);
                this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType((short)513);
                return;
            }
            if (object == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
            }
            if (object instanceof LocatorBlob) {
                if (objectArray.length != 1) {
                    throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                }
                if (((LocatorBlob)object).locatorIsStale()) {
                    ((LocatorBlob)object).refreshStaleLocator();
                }
                byte[] byArray = TDPreparedStatement.getLocatorWithLength(((LocatorBlob)object).getLocator());
                this.m_paramProperties.setCurrentParameter(n, object, byArray, 409, false, 0, 0, this.m_session.getConfigResponse().getMaxLobBytes());
            } else {
                int n5;
                if (object instanceof InputStream) {
                    if (objectArray.length != 2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "2");
                    }
                    if (!(objectArray[1] instanceof Integer)) {
                        throw ErrorFactory.makeDriverJDBCException("TJ729", string, "2", objectArray[1].getClass().getName(), "java.lang.Integer");
                    }
                    n5 = (Integer)objectArray[1];
                    if (n5 < 0) {
                        throw ErrorFactory.makeDriverJDBCException("TJ818", string, String.valueOf(n), String.valueOf(n5));
                    }
                } else if (object instanceof byte[]) {
                    if (objectArray.length != 1) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                    }
                    n5 = ((byte[])object).length;
                    object = new ByteArrayInputStream((byte[])object);
                } else {
                    throw ErrorFactory.makeDriverJDBCException("TJ819", string, "1", object.getClass().getName());
                }
                this.m_paramProperties.setDeferredLobParameter(n, -1, null, (InputStream)object, 405, n5, this.m_afcmiParameterMarkers[n - 1].getTransmitMetadataItemNumber());
                this.m_paramProperties.getCurrentParamSet().setServerCharsetCode(n, this.m_afcmiParameterMarkers[n - 1].getCharsetCode());
            }
            this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType((short)513);
        } else if ("DATASET STORAGE FORMAT CSV".equals(string)) {
            if (!this.m_session.isCSVDataSetUsable()) {
                throw ErrorFactory.makeDriverJDBCException("TJ817", "CSV");
            }
            Object object = objectArray[0];
            if (object == null && objectArray.length == 1) {
                this.internalSetNull(n, 1111, 0, 421, false);
                this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType((short)517);
                return;
            }
            if (object == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
            }
            if (object instanceof LocatorClob) {
                if (objectArray.length != 1) {
                    throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                }
                if (((LocatorClob)object).locatorIsStale()) {
                    ((LocatorClob)object).refreshStaleLocator();
                }
                byte[] byArray = TDPreparedStatement.getLocatorWithLength(((LocatorClob)object).getLocator());
                this.m_paramProperties.setCurrentParameter(n, object, byArray, 425, false, 0, 0, this.m_session.getConfigResponse().getMaxLobBytes());
            } else {
                int n6;
                if (object instanceof Reader) {
                    if (objectArray.length != 2) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "2");
                    }
                    if (!(objectArray[1] instanceof Integer)) {
                        throw ErrorFactory.makeDriverJDBCException("TJ729", string, "2", objectArray[1].getClass().getName(), "java.lang.Integer");
                    }
                    n6 = (Integer)objectArray[1];
                    if (n6 < 0) {
                        throw ErrorFactory.makeDriverJDBCException("TJ818", string, String.valueOf(n), String.valueOf(n6));
                    }
                } else if (object instanceof String) {
                    if (objectArray.length != 1) {
                        throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
                    }
                    n6 = ((String)object).length();
                    object = new StringReader((String)object);
                } else {
                    throw ErrorFactory.makeDriverJDBCException("TJ796", string, "1", object.getClass().getName());
                }
                this.m_paramProperties.setDeferredLobParameter(n, -1, null, (Reader)object, 421, n6, this.m_afcmiParameterMarkers[n - 1].getTransmitMetadataItemNumber());
                this.m_paramProperties.getCurrentParamSet().setServerCharsetCode(n, this.m_afcmiParameterMarkers[n - 1].getCharsetCode());
            }
            this.m_paramProperties.getCurrentDataInfoField(n).setServerDataType((short)517);
        } else {
            if (objectArray.length != 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ728", string, String.valueOf(objectArray.length), "1");
            }
            if (objectArray[0] != null && !(objectArray[0] instanceof String)) {
                throw ErrorFactory.makeDriverJDBCException("TJ729", string, "1", objectArray[0].getClass().getName(), "java.lang.String");
            }
            String string2 = (String)objectArray[0];
            if (string2 == null) {
                this.internalSetNull(n, 1111, 0, n2, false);
            } else {
                int n7 = JDBC4Constants.getIntervalLength(n2);
                if (string2.length() != n7) {
                    throw ErrorFactory.makeDriverJDBCException("TJ732", string, string2, String.valueOf(string2.length()), String.valueOf(n7));
                }
                byte[] byArray = Encoder.encodeStringParameter(this.m_session, n, string2);
                this.m_paramProperties.setIntervalParameter(n, string2, byArray, n2, false, JDBC4Constants.getNumberOfIntervalDigits(n2), JDBC4Constants.getNumberOfIntervalFracDigits(n2), byArray.length);
            }
        }
    }

    public void clearParameters() {
        this.m_paramProperties.clearCurrentParameters();
    }

    public void clearBatch() {
        this.m_paramProperties.clearBatchData();
    }

    public void addBatch() throws SQLException {
        if (!this.m_session.arraySupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ170");
        }
        this.m_paramProperties.addBatchData();
    }

    public int[] executeBatch() throws SQLException {
        if (!this.m_session.arraySupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ228");
        }
        String string = this.m_paramProperties.buildBatchStatement();
        return this.executeBatchDMLArray(string);
    }

    public ResultSet executeQuery() throws SQLException {
        this.autoRegisterOutParams();
        String string = this.m_paramProperties.buildStatement();
        this.doPrepExecuteQuery(string);
        return this.internalGetResultSet(false, false);
    }

    public int executeUpdate() throws SQLException {
        String string = this.m_paramProperties.buildStatement();
        return this.doPrepExecuteUpdate(string);
    }

    public boolean execute() throws SQLException {
        this.autoRegisterOutParams();
        String string = this.m_paramProperties.buildStatement();
        return this.doPrepExecute(string);
    }

    protected int findParamIndexFromName(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ178");
    }

    public Array getArray(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getArray(n2);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findParamIndexFromName(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getBigDecimal(n2);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        int n3 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getBigDecimal(n3, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParamIndexFromName(string));
    }

    public Blob getBlob(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getBlob(n2);
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParamIndexFromName(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getBoolean(n2);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParamIndexFromName(string));
    }

    public byte getByte(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getByte(n2);
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findParamIndexFromName(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getBytes(n2);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParamIndexFromName(string));
    }

    public Clob getClob(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getClob(n2);
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParamIndexFromName(string));
    }

    public Date getDate(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getDate(n2);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getDate(n2, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findParamIndexFromName(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParamIndexFromName(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getDouble(n2);
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParamIndexFromName(string));
    }

    public float getFloat(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getFloat(n2);
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParamIndexFromName(string));
    }

    public int getInt(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getInt(n2);
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findParamIndexFromName(string));
    }

    public long getLong(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getLong(n2);
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findParamIndexFromName(string));
    }

    public Object getObject(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getObject(n2);
    }

    public Object getObject(int n, Map map) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getObject(n2, map);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findParamIndexFromName(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findParamIndexFromName(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getRef(n2);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParamIndexFromName(string));
    }

    public short getShort(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getShort(n2);
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findParamIndexFromName(string));
    }

    public String getString(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getString(n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findParamIndexFromName(string));
    }

    public Time getTime(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getTime(n2);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getTime(n2, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findParamIndexFromName(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParamIndexFromName(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getTimestamp(n2);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getTimestamp(n2, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParamIndexFromName(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParamIndexFromName(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        int n2 = this.m_paramProperties.verifyOutParam(n);
        return this.m_rsOutParams.getURL(n2);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParamIndexFromName(string));
    }

    private void autoRegisterOutParams() {
        if (this.getSQLRequestEscapeFunction("TERADATA_AUTO_OUT_PARAM") != null) {
            for (int i = 1; i <= this.m_paramProperties.getNumOfParams(); ++i) {
                if (this.m_paramProperties.getCurrentParamSet().getParamType(i) != 4) continue;
                this.m_paramProperties.getCurrentParamSet().setParamType(i, 2);
            }
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.m_paramProperties.verifyParamMarker(n);
        this.m_paramProperties.getCurrentParamSet().setOutParamSqlType(n, n2);
        int n3 = this.m_paramProperties.getCurrentParamSet().getParamType(n);
        if (n3 == 4 || n3 == 1) {
            this.m_paramProperties.getCurrentParamSet().setParamType(n, n3 == 1 ? 3 : 2);
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParamIndexFromName(string), n);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParamIndexFromName(string), n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParamIndexFromName(string), n, string2);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParamIndexFromName(string), inputStream, n);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParamIndexFromName(string), bigDecimal);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParamIndexFromName(string), inputStream, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParamIndexFromName(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParamIndexFromName(string), by);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParamIndexFromName(string), byArray);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParamIndexFromName(string), reader, n);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParamIndexFromName(string), date);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParamIndexFromName(string), date, calendar);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParamIndexFromName(string), d);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParamIndexFromName(string), f);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParamIndexFromName(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParamIndexFromName(string), l);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParamIndexFromName(string), n);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParamIndexFromName(string), n, string2);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParamIndexFromName(string), object);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParamIndexFromName(string), object, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParamIndexFromName(string), object, n, n2);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParamIndexFromName(string), s);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParamIndexFromName(string), string2);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParamIndexFromName(string), time);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParamIndexFromName(string), time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParamIndexFromName(string), timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParamIndexFromName(string), timestamp, calendar);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParamIndexFromName(string), uRL);
    }

    public boolean wasNull() throws SQLException {
        return this.m_rsOutParams.wasNull();
    }

    public void lobRequest(byte[] byArray, short s, LobStream lobStream) throws SQLException {
        ParameterProperties.ParameterSet parameterSet = this.initParameterPropertiesForLobRequest(1);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 1, s, byArray, 2097088000);
        String string = this.m_paramProperties.getOriginalSql();
        try {
            this.m_lobReceiveController = new LobReceiveController(this, this.m_session, string, lobStream);
            this.m_lobReceiveController.setLobSelect((byte)73);
            this.executeStatement(this.m_lobReceiveController, 2, (byte)69);
        }
        catch (SQLException sQLException) {
            this.m_lobReceiveController = null;
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobContinue() throws SQLException {
        switch (this.getState()) {
            case 7: {
                throw ErrorFactory.makeDriverJDBCException("TJ360");
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                throw ErrorFactory.makeDriverJDBCException("TJ057");
            }
        }
        this.m_session.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            this.m_lobReceiveController.run();
        }
        finally {
            this.m_session.releaseSessionLock();
        }
    }

    public void updateLob(byte[] byArray, short s) throws SQLException {
        ParameterProperties.ParameterSet parameterSet = this.initParameterPropertiesForLobRequest(1);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 1, s, byArray, 2097088000);
        String string = this.m_paramProperties.getOriginalSql();
        this.doPrepExecuteUpdate(string);
    }

    public void updateLob(byte[] byArray, short s, byte[] byArray2, int n) throws SQLException {
        ParameterProperties.ParameterSet parameterSet = this.initParameterPropertiesForLobRequest(3);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 2, n, byArray2, byArray2.length);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 3, s, byArray, 2097088000);
        String string = this.m_paramProperties.getOriginalSql();
        this.doPrepExecuteUpdate(string);
    }

    public void updateLob(byte[] byArray, short s, int n, int n2, int n3) throws SQLException {
        ParameterProperties.ParameterSet parameterSet = this.initParameterPropertiesForLobRequest(2);
        this.setParameterWithPrefixLengthForLobRequest(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterDeferredLobRequest(parameterSet, 2, n2, ByteConverter.putInt(n), 2097088000, n3);
        String string = this.m_paramProperties.getOriginalSql();
        this.doPrepExecuteUpdate(string);
    }

    private ParameterProperties.ParameterSet initParameterPropertiesForLobRequest(int n) {
        ParameterProperties.ParameterSet parameterSet = this.m_paramProperties.createParameterSet(n);
        this.m_paramProperties.setNumOfParamsAndAttributes(n);
        parameterSet.setNullIndicatorBits(new byte[]{0});
        for (int i = 1; i <= n; ++i) {
            parameterSet.setMetadataItemNumber(i, i);
        }
        this.m_paramProperties.addParameterSet(parameterSet);
        return parameterSet;
    }

    private void setParameterWithPrefixLengthForLobRequest(ParameterProperties.ParameterSet parameterSet, int n, int n2, byte[] byArray, int n3) throws SQLException {
        byte[] byArray2 = ByteConverter.copyByteArrayAddLengthPrefix(byArray);
        this.setParameterDirectForLobRequest(parameterSet, n, n2, byArray2, n3);
    }

    private void setParameterDeferredLobRequest(ParameterProperties.ParameterSet parameterSet, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        this.setParameterDirectForLobRequest(parameterSet, n, n2, byArray, n3);
        parameterSet.setLength(n, n4);
    }

    private void setParameterDirectForLobRequest(ParameterProperties.ParameterSet parameterSet, int n, int n2, byte[] byArray, int n3) throws SQLException {
        parameterSet.setParameter(n, byArray, byArray, n2, false, 0, 0);
        this.m_paramProperties.setDataInfoField(n, n2, n3, 0, 0, 0, (short)0, "", (short)0, new int[0], true);
    }

    public void setNString(int n, String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNString");
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNCharacterStream(int,Reader,long)");
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setClob(int,Reader,long)");
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBlob(int,InputStream,long)");
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNClob(int,Reader,long)");
    }

    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > 2097088000L) {
            throw ErrorFactory.makeDriverJDBCException("TJ787", String.valueOf(n), String.valueOf(l), String.valueOf(2097088000));
        }
        this.setAsciiStream(n, inputStream, (int)l);
    }

    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > 2097088000L) {
            throw ErrorFactory.makeDriverJDBCException("TJ787", String.valueOf(n), String.valueOf(l), String.valueOf(2097088000));
        }
        this.setBinaryStream(n, inputStream, (int)l);
    }

    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > 2097088000L) {
            throw ErrorFactory.makeDriverJDBCException("TJ787", String.valueOf(n), String.valueOf(l), String.valueOf(2097088000));
        }
        this.setCharacterStream(n, reader, (int)l);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setAsciiStream");
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBinaryStream");
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setCharacterStream");
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNCharacterStream");
    }

    public void setClob(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setClob");
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBlob");
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNClob");
    }

    public void setNString(String string, String string2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNString");
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNCharacterStream(String,Reader,long)");
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setClob(String,Reader,long)");
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBlob(String,InputStream,long)");
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNClob(String,Reader,long)");
    }

    public String getNString(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNString");
    }

    public String getNString(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNString");
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNCharacterStream");
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getNCharacterStream");
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getCharacterStream");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getCharacterStream");
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBlob");
    }

    public void setClob(String string, Clob clob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setClob");
    }

    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.setAsciiStream(this.findParamIndexFromName(string), inputStream, l);
    }

    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(this.findParamIndexFromName(string), inputStream, l);
    }

    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.setCharacterStream(this.findParamIndexFromName(string), reader, l);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setAsciiStream");
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBinaryStream");
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setCharacterStream");
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNCharacterStream");
    }

    public void setClob(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setClob");
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setBlob");
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setNClob");
    }
}

