/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.fastload.FastLoadCSVPreparedStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class FastLoadCSVConnection
implements LocalEscapeFunctions {
    private String m_sMachineName = null;
    private String m_sUserName = null;
    private String m_sPassword = null;
    private URLParameters m_urlParams = null;
    private List m_listStatements = Collections.synchronizedList(new ArrayList());
    private boolean m_bConnected = false;
    private SQLWarning m_sqlWarnings = null;
    private boolean m_bAutoCommit = true;

    public FastLoadCSVConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        this.m_sMachineName = string;
        this.m_sUserName = string2;
        this.m_sPassword = string3;
        this.m_urlParams = uRLParameters;
        if (this.m_urlParams.getStrictEncode() == Boolean.FALSE) {
            throw ErrorFactory.makeDriverJDBCException("TJ712");
        }
        if (this.m_urlParams.getStrictEncode() == null) {
            this.m_urlParams.setStrictEncode("ON");
        }
        this.m_bConnected = true;
    }

    protected void abortIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    protected void chainSQLWarnings(SQLWarning sQLWarning) {
        if (this.m_sqlWarnings == null) {
            this.m_sqlWarnings = sQLWarning;
        } else {
            this.m_sqlWarnings.setNextWarning(sQLWarning);
        }
    }

    protected void removeStatement(Object object) {
        this.m_listStatements.remove(object);
    }

    protected URLParameters getURLParameters() {
        return this.m_urlParams;
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
        this.m_sqlWarnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.m_bConnected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.m_listStatements);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FastLoadCSVPreparedStatement fastLoadCSVPreparedStatement = (FastLoadCSVPreparedStatement)arrayList.get(i);
                    boolean bl = fastLoadCSVPreparedStatement.isFastLoading();
                    try {
                        fastLoadCSVPreparedStatement.close();
                        if (!bl) continue;
                        fastLoadCSVPreparedStatement.rollbackFastLoad();
                        fastLoadCSVPreparedStatement.closeFastLoad();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ694", i, arrayList.size());
                        sQLException = FastLoadCSVConnection.chainSQLExceptions(sQLException, sQLException3);
                        sQLException = FastLoadCSVConnection.chainSQLExceptions(sQLException, sQLException2);
                        continue;
                    }
                    finally {
                        if (bl) {
                            this.removeStatement(fastLoadCSVPreparedStatement);
                        }
                    }
                }
            }
            finally {
                this.m_bConnected = false;
            }
            if (sQLException != null) {
                SQLException sQLException4 = ErrorFactory.makeDriverJDBCException("TJ457");
                sQLException4.setNextException(sQLException);
                throw sQLException4;
            }
        }
    }

    private void commitOrRollback(boolean bl) throws SQLException {
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.m_listStatements);
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                FastLoadCSVPreparedStatement fastLoadCSVPreparedStatement = (FastLoadCSVPreparedStatement)arrayList.get(i);
                if (bl) {
                    fastLoadCSVPreparedStatement.endFastLoad();
                    continue;
                }
                fastLoadCSVPreparedStatement.rollbackFastLoad();
                continue;
            }
            catch (SQLException sQLException2) {
                sQLException = FastLoadCSVConnection.chainSQLExceptions(sQLException, ErrorFactory.makeDriverJDBCException("TJ694", i, arrayList.size()));
                sQLException = FastLoadCSVConnection.chainSQLExceptions(sQLException, sQLException2);
            }
        }
        if (sQLException != null) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException(bl ? "TJ458" : "TJ474");
            sQLException3.setNextException(sQLException);
            throw sQLException3;
        }
    }

    public void commit() throws SQLException {
        this.abortIfClosed();
        this.commitOrRollback(true);
    }

    public Statement createStatement() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getAutoCommit() throws SQLException {
        this.abortIfClosed();
        return this.m_bAutoCommit;
    }

    public String getCatalog() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getTransactionIsolation() throws SQLException {
        this.abortIfClosed();
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.abortIfClosed();
        return new HashMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return this.m_sqlWarnings;
    }

    public boolean isClosed() throws SQLException {
        return !this.m_bConnected;
    }

    public boolean isReadOnly() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        this.abortIfClosed();
        return EscapeUtil.nativeSQL(string, this);
    }

    public String getLogonSequenceNumber() {
        String string = "";
        ArrayList arrayList = new ArrayList(this.m_listStatements);
        for (int i = 0; i < arrayList.size(); ++i) {
            FastLoadCSVPreparedStatement fastLoadCSVPreparedStatement = (FastLoadCSVPreparedStatement)arrayList.get(i);
            String string2 = fastLoadCSVPreparedStatement.getLogonSequenceNumber();
            if (string2.length() <= 0) continue;
            string = string + (string.length() > 0 ? "," : "") + fastLoadCSVPreparedStatement.hashCode() + "," + fastLoadCSVPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    public String getAMPCount() {
        return "";
    }

    public String getLogLevel() {
        return "";
    }

    public String setLogLevel(String string) {
        return "";
    }

    public String teradataProvide(String string, Map map) {
        return "";
    }

    public String useAnsiDate() {
        return "";
    }

    public String useIntegerDate() {
        return "";
    }

    public String getSessionNumber() {
        return "";
    }

    public String getSocketInfo() {
        return "";
    }

    public int getTeradataDatabaseVersionNumber() {
        return 0;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.abortIfClosed();
        PreparedStatement preparedStatement = this.constructPreparedStatement(this.m_sMachineName, this.m_sUserName, this.m_sPassword, string);
        this.m_listStatements.add(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void rollback() throws SQLException {
        this.abortIfClosed();
        this.commitOrRollback(false);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.abortIfClosed();
        if (this.m_bAutoCommit != bl) {
            this.commit();
            this.m_bAutoCommit = bl;
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setHoldability(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Savepoint setSavepoint() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.abortIfClosed();
        if (n != 8) {
            throw ErrorFactory.makeDriverJDBCException("TJ679");
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    protected abstract PreparedStatement constructPreparedStatement(String var1, String var2, String var3, String var4) throws SQLException;

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Blob createBlob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Clob createClob() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Properties getClientInfo() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public String getClientInfo(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getClientInfo(String)");
    }

    public boolean isValid(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }
}

