/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.encode;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.encode.ConnectionCharsetInfo;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;

public class Decoder {
    private static final String REPLACE_WITH_UNICODE_REPLACEMENT_CHAR = "\ufffd";

    private static String getDecodedString(ConnectionCharsetInfo connectionCharsetInfo, byte[] byArray, int n, int n2) throws SQLException {
        if (n2 == 0) {
            return "";
        }
        try {
            return new String(byArray, n, n2, connectionCharsetInfo.getSerializeDeserializeCharsetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", connectionCharsetInfo.getSerializeDeserializeCharsetName());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public static String getUTF8DecodedString(byte[] byArray) throws SQLException {
        return Decoder.getUTF8DecodedString(byArray, 0, byArray.length);
    }

    public static String getUTF8DecodedString(byte[] byArray, int n, int n2) throws SQLException {
        if (n2 == 0) {
            return "";
        }
        try {
            return new String(byArray, n, n2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", "UTF8");
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    private static String getAsciiDecodedString(ConnectionCharsetInfo connectionCharsetInfo, byte[] byArray, int n, int n2, String string, int n3, String[] stringArray, boolean bl, long l) throws SQLException {
        if (n2 == 0) {
            return "";
        }
        if (!bl || string == null) {
            try {
                return new String(byArray, n, n2, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", "ASCII");
                sQLException.initCause(unsupportedEncodingException);
                throw sQLException;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        Charset charset = connectionCharsetInfo.getAsciiCharset();
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        ThreadLocal threadLocal = connectionCharsetInfo.getAsciiCharsetDecoderReport();
        try {
            CharsetDecoder charsetDecoder = (CharsetDecoder)ConnectionCharsetInfo.deref(threadLocal);
            if (charsetDecoder == null) {
                charsetDecoder = charset.newDecoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).replaceWith(REPLACE_WITH_UNICODE_REPLACEMENT_CHAR);
                ConnectionCharsetInfo.set(threadLocal, charsetDecoder);
            }
            charsetDecoder.reset();
            char[] cArray = new char[Encoder.scale(n2, charsetDecoder.maxCharsPerByte())];
            CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, cArray.length);
            try {
                CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                int n4 = charBuffer.position();
                String string2 = Integer.toHexString(byteBuffer.get(byteBuffer.position()) & 0xFF);
                SQLException sQLException = stringArray != null ? ErrorFactory.makeDriverJDBCException(string, stringArray[0], stringArray[1], string2, String.valueOf(l + (long)n4), "ASCII") : (n3 == -1 ? ErrorFactory.makeDriverJDBCException(string, string2, String.valueOf(l + (long)n4), "ASCII") : ErrorFactory.makeDriverJDBCException(string, String.valueOf(n3), string2, String.valueOf(l + (long)n4), "ASCII"));
                sQLException.initCause(characterCodingException);
                throw sQLException;
            }
            return new String(cArray, 0, charBuffer.position());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", "ASCII");
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public static String decodeClob(GenericTeradataConnection genericTeradataConnection, byte[] byArray) throws SQLException {
        return Decoder.getDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, 0, byArray.length);
    }

    public static String decodeClob(boolean bl, GenericTeradataConnection genericTeradataConnection, byte[] byArray, int n, int n2) throws SQLException {
        return bl ? Decoder.getUTF8DecodedString(byArray, n, n2) : Decoder.getDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n, n2);
    }

    public static String decodeColumn(ResultSetHelper resultSetHelper, byte[] byArray) throws SQLException {
        return Decoder.getDecodedString(resultSetHelper.getCharsetInfo(), byArray, 0, byArray.length);
    }

    public static String decodeStringParameter(GenericTeradataConnection genericTeradataConnection, byte[] byArray) throws SQLException {
        return Decoder.getDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, 0, byArray.length);
    }

    public static String decodeString(GenericTeradataConnection genericTeradataConnection, byte[] byArray, int n, int n2) throws SQLException {
        return Decoder.getDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n, n2);
    }

    public static String decodeStringAscii(GenericTeradataConnection genericTeradataConnection, byte[] byArray, int n, int n2) throws SQLException {
        return Decoder.getAsciiDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n, n2, null, -1, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static String decodeStreamAsciiChecked(GenericTeradataConnection genericTeradataConnection, int n, int n2, String[] stringArray, byte[] byArray, int n3, int n4, long l) throws SQLException {
        return stringArray != null ? Decoder.getAsciiDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, 0, byArray.length, "TJ717", -1, stringArray, genericTeradataConnection.isStrictEncode(), l) : (n == -1 && n2 == -1 ? Decoder.getAsciiDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n3, n4, "TJ718", -1, null, genericTeradataConnection.isStrictEncode(), l) : (n2 == -1 ? Decoder.getAsciiDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n3, n4, "TJ711", n, null, genericTeradataConnection.isStrictEncode(), l) : Decoder.getAsciiDecodedString(genericTeradataConnection.getCharsetInfo(), byArray, n3, n4, "TJ713", n2, null, genericTeradataConnection.isStrictEncode(), l)));
    }
}

