/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.LanHeader;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.io.WireProtocol;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AbortUCParcel;
import com.teradata.jdbc.jdbc_4.parcel.AckRequestedParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.ContinueContextParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataStartParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableNPSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableProtocolParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.SecurityPolicyParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionStatusResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.UnknownParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class TDNetworkIOIF {
    private String m_sOriginalHostName;
    private boolean m_bClosedJavaSPDefaultConnection;
    private Socket socket = null;
    private OutputStream outStream;
    private InputStream inStream;
    private Mutex readLock;
    private Mutex writeLock;
    private int sessionNum;
    private final String m_sConnectionID = Integer.toHexString(System.identityHashCode(this));
    private int m_tcp_concurrent = 3;
    private int m_tcp_contimeout = 10000;
    private long m_tcp_conwait = 1000L;
    private long m_result_connecttime = 0L;
    private long m_result_connecttotaltime = 0L;
    private int m_result_connectattempts = 0;
    private int m_result_connectfailures = 0;
    private byte[] m_abyLastSentMsg;
    private int m_nRecoverableNetworkState;
    private boolean m_bReadInProgress;
    private int m_nReconnectAttempts = 0;
    private boolean m_bReconnectInProgress;
    private GenericTeradataConnection m_con;
    protected Log log;
    private static Map sm_mapConnectFailures = Collections.synchronizedMap(new HashMap());
    private static Map sm_map = new HashMap();
    private Object m_oSocketWriteErrorMutex = new Object();
    private SQLException m_exSocketWriteErrorChain = null;
    private static final int GET_TCP_KEEPALIVE = 1;
    private static final int GET_TCP_NODELAY = 2;
    private static final int GET_TCP_RECEIVE = 3;
    private static final int GET_TCP_SEND = 4;
    private static final int GET_TCP_LINGER = 5;
    private static final int GET_TCP_TRAFFIC = 6;

    public TDNetworkIOIF(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        this.m_con = genericTeradataConnection;
        this.log = genericTeradataConnection.getLog();
        this.m_sOriginalHostName = genericTeradataConnection.getMachineName();
        this.createSocketConnection();
        this.readLock = new Mutex("IO ReadLock", this.log);
        this.writeLock = new Mutex("IO WriteLock", this.log);
    }

    private void createSocketConnection() throws SQLException {
        String string = this.m_con.getURLParameters().getCopDiscovery() ? "cop" : null;
        try {
            this.socket = this.connectToHost(this.m_con, string);
            this.outStream = this.socket.getOutputStream();
            this.inStream = this.socket.getInputStream();
        }
        catch (Throwable throwable) {
            this.close();
            throw ErrorAnalyzer.analyzeIoError("Connection to " + this.m_sOriginalHostName, this, throwable, false, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Completed connection: " + this);
        }
    }

    public TDNetworkIOIF(OutputStream outputStream, InputStream inputStream, Log log) throws SQLException {
        this.log = log;
        this.outStream = outputStream;
        this.inStream = inputStream;
        this.socket = null;
        this.readLock = new Mutex("IO ReadLock", log);
        this.writeLock = new Mutex("IO WriteLock", log);
    }

    private static int randomNumber(int n, int n2) {
        int n3 = n2 - n + 1;
        return (int)(Math.random() * (double)n3) % n3 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connectToHost(GenericTeradataConnection genericTeradataConnection, String string) throws IOException, SQLException {
        Iterator iterator;
        long l;
        int n;
        Cloneable cloneable;
        Object object;
        Object object2;
        LinkedHashSet<InetSocketAddress> linkedHashSet;
        int n2;
        Lookup lookup;
        Object object3;
        Integer n3;
        int n4;
        boolean bl;
        Integer n5;
        Integer n6;
        boolean bl2;
        boolean bl3;
        Log log;
        long l2;
        int n7;
        String string2;
        block60: {
            string2 = genericTeradataConnection.getMachineName();
            n7 = genericTeradataConnection.getMachinePort();
            l2 = genericTeradataConnection.getURLParameters().getConnectFailureTTL();
            log = genericTeradataConnection.getLog();
            bl3 = false;
            bl2 = false;
            n6 = null;
            n5 = null;
            bl = true;
            n4 = 10;
            n3 = null;
            String string3 = genericTeradataConnection.getURLParameters().getTCP();
            if (string3 != null) {
                object3 = string3.toUpperCase().trim().split("[+]");
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    if (object3[i].equals("KEEPALIVE")) {
                        bl3 = true;
                        continue;
                    }
                    if (object3[i].equals("NODELAY")) {
                        bl2 = true;
                        continue;
                    }
                    if (object3[i].startsWith("RECEIVE")) {
                        n6 = new Integer(((String)object3[i]).substring("RECEIVE".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("SEND")) {
                        n5 = new Integer(((String)object3[i]).substring("SEND".length()));
                        continue;
                    }
                    if (((String)object3[i]).equals("NOLINGER")) {
                        bl = false;
                        continue;
                    }
                    if (((String)object3[i]).startsWith("LINGER")) {
                        n4 = Integer.parseInt(((String)object3[i]).substring("LINGER".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("TRAFFIC")) {
                        n3 = new Integer(((String)object3[i]).substring("TRAFFIC".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("CONCURRENT")) {
                        this.m_tcp_concurrent = Integer.parseInt(((String)object3[i]).substring("CONCURRENT".length()));
                        continue;
                    }
                    if (((String)object3[i]).startsWith("CONTIMEOUT")) {
                        this.m_tcp_contimeout = Integer.parseInt(((String)object3[i]).substring("CONTIMEOUT".length()));
                        continue;
                    }
                    if (!((String)object3[i]).startsWith("CONWAIT")) continue;
                    this.m_tcp_conwait = Long.parseLong(((String)object3[i]).substring("CONWAIT".length()));
                }
            }
            if (this.m_tcp_concurrent <= 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ654", string2, "concurrent", String.valueOf(this.m_tcp_concurrent));
            }
            if (this.m_tcp_contimeout < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string2, "contimeout", String.valueOf(this.m_tcp_contimeout));
            }
            if (this.m_tcp_conwait < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string2, "conwait", String.valueOf(this.m_tcp_conwait));
            }
            object3 = new ArrayList();
            lookup = new Lookup(genericTeradataConnection, string2);
            if (lookup.isLiteralIpAddress()) {
                ((ArrayList)object3).add(lookup.getAddresses());
            } else if (string != null) {
                n2 = string2.indexOf(46);
                linkedHashSet = n2 < 0 ? string2 : string2.substring(0, n2);
                object2 = n2 < 0 ? "" : string2.substring(n2);
                try {
                    int n8 = 1;
                    while (true) {
                        String string4 = (String)((Object)linkedHashSet) + string + n8 + (String)object2;
                        ((ArrayList)object3).add(new Lookup(genericTeradataConnection, string4).getAddresses());
                        ++n8;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (log.isDebugEnabled()) {
                        log.debug("TDNetworkIOIF.connectToHost: caught " + unknownHostException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!log.isDebugEnabled()) break block60;
                    log.debug("TDNetworkIOIF.connectToHost: caught " + securityException);
                }
            }
        }
        if (((ArrayList)object3).size() == 0) {
            ((ArrayList)object3).add(lookup.getAddresses());
        }
        n2 = TDNetworkIOIF.randomNumber(0, ((ArrayList)object3).size() - 1);
        linkedHashSet = sm_map;
        synchronized (linkedHashSet) {
            object2 = (Integer)sm_map.get(string2);
            if (object2 != null) {
                n2 = ((Integer)object2 + 1) % ((ArrayList)object3).size();
            }
            sm_map.put(string2, new Integer(n2));
        }
        Collections.rotate(object3, -n2);
        if (log.isDebugEnabled()) {
            log.debug("Before connect loop: sm_mapConnectFailures=" + sm_mapConnectFailures);
        }
        linkedHashSet = new LinkedHashSet<InetSocketAddress>();
        long l3 = System.currentTimeMillis();
        IOException iOException = null;
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            InetAddress[] inetAddressArray = (InetAddress[])((ArrayList)object3).get(i);
            for (int j = 0; j < inetAddressArray.length; ++j) {
                object = new InetSocketAddress(inetAddressArray[j], n7);
                genericTeradataConnection.checkRemainingLoginTime();
                cloneable = (Date)sm_mapConnectFailures.get(object);
                if (cloneable != null) {
                    long l4 = ((Date)cloneable).getTime();
                    int n9 = n = l4 <= l3 ? 1 : 0;
                    if (n != 0) {
                        boolean bl4;
                        l = l4 + l2 * 1000L;
                        boolean bl5 = bl4 = l3 < l;
                        if (bl4) {
                            if (!log.canLog(2)) continue;
                            log.timing("Fail-fast connection attempt skipped due to failure at " + cloneable + ", " + object + " will become usable at " + new Date(l));
                            continue;
                        }
                    }
                }
                linkedHashSet.add((InetSocketAddress)object);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("setAddresses=" + linkedHashSet);
        }
        Iterator iterator2 = linkedHashSet.iterator();
        this.m_result_connectattempts = 0;
        long l5 = System.currentTimeMillis();
        object = null;
        cloneable = new ArrayList();
        try {
            Iterator iterator3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                WorkerThreadList workerThreadList = new WorkerThreadList();
                while (object == null && (iterator2.hasNext() || cloneable.size() > 0)) {
                    Object object4;
                    Object object5;
                    n = genericTeradataConnection.checkRemainingLoginTime();
                    if (cloneable.size() < this.m_tcp_concurrent && iterator2.hasNext()) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)iterator2.next();
                        ++this.m_result_connectattempts;
                        if (log.canLog(2)) {
                            log.timing("Attempting connection " + this.m_result_connectattempts + " to " + inetSocketAddress);
                        }
                        int n10 = n == 0 && this.m_tcp_contimeout != 0 ? this.m_tcp_contimeout : (n != 0 && this.m_tcp_contimeout == 0 ? n : Math.min(n, this.m_tcp_contimeout));
                        object5 = new Socket();
                        ((Socket)object5).setKeepAlive(bl3);
                        ((Socket)object5).setTcpNoDelay(bl2);
                        if (n6 != null) {
                            ((Socket)object5).setReceiveBufferSize(n6);
                        }
                        if (n5 != null) {
                            ((Socket)object5).setSendBufferSize(n5);
                        }
                        ((Socket)object5).setSoLinger(bl, n4);
                        if (n3 != null) {
                            ((Socket)object5).setTrafficClass(n3);
                        }
                        arrayList.add(object5);
                        object4 = new ConnectThread((Socket)object5, inetSocketAddress, n10, workerThreadList);
                        cloneable.add(object4);
                        ((Thread)object4).setDaemon(true);
                        ((Thread)object4).start();
                    }
                    l = cloneable.size() < this.m_tcp_concurrent && iterator2.hasNext() ? this.m_tcp_conwait : 0L;
                    object5 = workerThreadList.waitForThreads(l);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        ConnectThread connectThread = (ConnectThread)object4.next();
                        cloneable.remove(connectThread);
                        long l6 = System.currentTimeMillis();
                        TDNetworkIOIF.waitForThreadDeath(connectThread);
                        if (log.canLog(2)) {
                            log.timing("Connection attempt to " + connectThread.m_isa + " with timeout " + connectThread.m_nTimeoutMs + " ms took " + connectThread.m_nElapsedTime + " ms and " + (connectThread.m_ex != null ? "failed" : (object == null ? "succeeded" : "succeeded but was discarded")) + ", waiting for thread took " + (System.currentTimeMillis() - l6) + " ms");
                        }
                        if (connectThread.m_ex == null) {
                            if (object != null) continue;
                            object = connectThread.m_socket;
                            this.m_result_connecttime = connectThread.m_nElapsedTime;
                            continue;
                        }
                        ++this.m_result_connectfailures;
                        sm_mapConnectFailures.put(connectThread.m_isa, connectThread.m_dateFailure);
                        if (connectThread.m_ex instanceof IOException) {
                            iOException = (IOException)connectThread.m_ex;
                        } else {
                            iOException = new IOException(connectThread.m_ex.toString());
                            iOException.initCause(connectThread.m_ex);
                        }
                        arrayList.remove(connectThread.m_socket);
                        try {
                            connectThread.m_socket.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                Object var40_49 = null;
                iterator3 = arrayList.iterator();
            }
            catch (Throwable throwable) {
                Object var40_50 = null;
                Iterator iterator4 = arrayList.iterator();
                while (iterator4.hasNext()) {
                    Socket socket = (Socket)iterator4.next();
                    if (socket == object) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException3) {}
                }
                throw throwable;
            }
            while (iterator3.hasNext()) {
                Socket socket = (Socket)iterator3.next();
                if (socket == object) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException4) {}
            }
            Object var45_58 = null;
            iterator = cloneable.iterator();
        }
        catch (Throwable throwable) {
            Object var45_59 = null;
            Iterator iterator5 = cloneable.iterator();
            while (iterator5.hasNext()) {
                ConnectThread connectThread = (ConnectThread)iterator5.next();
                long l7 = System.currentTimeMillis();
                TDNetworkIOIF.waitForThreadDeath(connectThread);
                if (!log.canLog(2)) continue;
                log.timing("Discarded connection attempt to " + connectThread.m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l7) + " ms");
            }
            throw throwable;
        }
        while (iterator.hasNext()) {
            ConnectThread connectThread = (ConnectThread)iterator.next();
            long l8 = System.currentTimeMillis();
            TDNetworkIOIF.waitForThreadDeath(connectThread);
            if (!log.canLog(2)) continue;
            log.timing("Discarded connection attempt to " + connectThread.m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l8) + " ms");
        }
        this.m_result_connecttotaltime = System.currentTimeMillis() - l5;
        if (object != null) {
            return object;
        }
        if (iOException == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ635", String.valueOf(l2));
        }
        throw iOException;
    }

    public String toString() {
        return (this.isJavaSPDefaultConnection() ? "jdbc:default:connection" : "socket orig=" + this.m_sOriginalHostName) + (this.socket != null ? " local=" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + " remote=" + this.socket.getInetAddress() + ":" + this.socket.getPort() + " keepalive=" + this.getTcpOption(1) + " nodelay=" + this.getTcpOption(2) + " receive=" + this.getTcpOption(3) + " send=" + this.getTcpOption(4) + " linger=" + this.getTcpOption(5) + " traffic=" + this.getTcpOption(6) + " concurrent=" + this.m_tcp_concurrent + " contimeout=" + this.m_tcp_contimeout + " conwait=" + this.m_tcp_conwait + " connecttime=" + this.m_result_connecttime + " connecttotaltime=" + this.m_result_connecttotaltime + " connectattempts=" + this.m_result_connectattempts + " connectfailures=" + this.m_result_connectfailures + " reconnectattempts=" + this.m_nReconnectAttempts + " recoverable=" + this.m_con.isRecoverableNPActive() + " redrive=" + this.m_con.isRedriveActive() + " failurecache=" + sm_mapConnectFailures : "") + " cid=" + this.m_sConnectionID + " sess=" + this.sessionNum;
    }

    private String getTcpOption(int n) {
        try {
            switch (n) {
                case 1: {
                    return String.valueOf(this.socket.getKeepAlive());
                }
                case 2: {
                    return String.valueOf(this.socket.getTcpNoDelay());
                }
                case 3: {
                    return String.valueOf(this.socket.getReceiveBufferSize());
                }
                case 4: {
                    return String.valueOf(this.socket.getSendBufferSize());
                }
                case 5: {
                    return String.valueOf(this.socket.getSoLinger());
                }
                case 6: {
                    return String.valueOf(this.socket.getTrafficClass());
                }
            }
            throw new IllegalArgumentException("Invalid value specified for nDesiredOption");
        }
        catch (SocketException socketException) {
            return "unavailable";
        }
    }

    public String getOriginalHostName() {
        return this.m_sOriginalHostName;
    }

    public InetAddress getRemoteAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    public int getRemotePort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public InetAddress getLocalAddress() {
        return this.socket != null ? this.socket.getLocalAddress() : null;
    }

    public int getLocalPort() {
        return this.socket != null ? this.socket.getLocalPort() : 0;
    }

    public String getConnectionID() {
        return this.m_sConnectionID;
    }

    public int getSessionNum() {
        return this.sessionNum;
    }

    public void setSessionNum(int n) {
        this.sessionNum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int read(BufferContainer bufferContainer, int n, TDStatement tDStatement, boolean bl) throws SQLException {
        boolean bl3 = tDStatement != null ? tDStatement.isFinalized() : false;
        try {
            boolean bl2 = this.m_bReadInProgress;
            this.m_bReadInProgress = true;
            try {
                int n3;
                if (this.socket != null) {
                    this.socket.setSoTimeout(n);
                }
                int n4 = 0;
                long l = System.currentTimeMillis();
                byte[] byArray = bufferContainer.getBuffer();
                boolean bl4 = false;
                int n5 = 1;
                try {
                    while (true) {
                        boolean bl5;
                        int n6 = 0;
                        try {
                            try {
                                int n7;
                                int n8;
                                while (n4 < 52 && (n8 = this.inStream.read(byArray, n4, 52 - n4)) != -1) {
                                    n4 += n8;
                                }
                                if (n4 < 52) {
                                    if (!bl3) {
                                        this.log.error("Read message " + n5 + ": Incomplete LAN message header: read " + n4 + " bytes");
                                        if (n4 > 0) {
                                            this.log.debugPartialByteArray("Incomplete response message header", byArray, 0, n4);
                                        }
                                    }
                                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ324"), n4));
                                }
                                n6 = TDNetworkIOIF.getTotalMsgLength(byArray);
                                n8 = this.m_con != null && this.m_con.getConfigResponse() != null ? this.m_con.getMaxMessageSize(false, true) * 2 : 0xFFF800;
                                boolean bl6 = bl5 = n6 > byArray.length && n6 <= n8;
                                if (bl5) {
                                    byte[] byArray2 = new byte[n6];
                                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                                    if (this.log.canLog(1)) {
                                        this.log.info("Read message " + n5 + ": resizing buffer from " + byArray.length + " bytes to " + byArray2.length + " bytes");
                                    }
                                    byArray = byArray2;
                                    bufferContainer.setBuffer(byArray);
                                }
                                int n2 = n3 = n6 > byArray.length ? 1 : 0;
                                if (n3 != 0) {
                                    if (!this.isJavaSPDefaultConnection()) {
                                        this.m_con.suppressReconnect();
                                    }
                                    this.log.error("Read message " + n5 + ": Bad response message header with invalid message length of " + n6 + " bytes");
                                    this.log.debugPartialByteArray("Bad response message header message dump", byArray, 0, 52);
                                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ325"), n6));
                                }
                                while (n4 < n6 && (n7 = this.inStream.read(byArray, n4, n6 - n4)) != -1) {
                                    n4 += n7;
                                }
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                                Object var19_30 = null;
                                if (this.log.canLog(2)) {
                                    this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray, " ") + "message " + n5 + ", " + n4 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                                }
                            }
                            catch (Throwable throwable) {
                                Object var19_31 = null;
                                if (this.log.canLog(2)) {
                                    this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray, " ") + "message " + n5 + ", " + n4 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException iOException) {
                            bl5 = false;
                            if (iOException instanceof SocketException && iOException.getMessage().equals("Read timed out") || iOException instanceof InterruptedIOException) {
                                bl4 = true;
                                boolean bl7 = bl5 = n4 > 0 && n5 < 2;
                                if (!bl3) {
                                    this.log.info("Read message " + n5 + ", " + n4 + (n6 > 0 ? " of " + n6 : "") + " bytes, timed out: " + iOException);
                                    if (n4 > 0) {
                                        this.log.debugPartialByteArray("Timed out message header message dump", byArray, 0, Math.min(n4, 52));
                                    }
                                }
                            }
                            if (!bl5) {
                                throw iOException;
                            }
                            ++n5;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (bl4) {
                        block47: {
                            if (n4 > 0) {
                                if (!bl3) {
                                    this.log.error("Read message " + n5 + " timed out after partial read; closing socket due to: " + iOException);
                                }
                                this.close();
                                IOException iOException2 = new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ625"), n4));
                                iOException2.initCause(iOException);
                                throw iOException2;
                            }
                            try {
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                            }
                            catch (IOException iOException3) {
                                if (bl3) break block47;
                                this.log.error("Read message " + n5 + " reset socket timeout failed: " + iOException3);
                            }
                        }
                        throw iOException;
                    }
                    if (bl3 || this.isJavaSPDefaultConnection() || !bl || !this.m_con.isReconnectEnabled() || this.m_bReconnectInProgress) {
                        if (!bl3) {
                            this.log.error("Read message " + n5 + " failed; closing socket due to: " + iOException);
                        }
                        this.close();
                        throw iOException;
                    }
                    int n10 = this.processReconnect(iOException, bufferContainer, n, tDStatement, bl);
                    Object var21_33 = null;
                    this.m_bReadInProgress = bl2;
                    if (!this.m_bReadInProgress) {
                        this.m_nRecoverableNetworkState = 2;
                    }
                    return n10;
                }
                this.log.debugPartialByteArray("Raw packet receive", byArray, 0, n4);
                if (!this.isJavaSPDefaultConnection() && this.m_con.getTeraEncrypt() != null && (byArray[1] & 0x80) != 0) {
                    byte[] byArray3 = new byte[24];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                    byte[] byArray4 = new byte[n4 - byArray3.length];
                    System.arraycopy(byArray, byArray3.length, byArray4, 0, byArray4.length);
                    byte[] byArray5 = this.m_con.getTeraEncrypt().decrypt(byArray4, 0, byArray4.length);
                    n4 = byArray5.length + byArray3.length;
                    byArray = new byte[n4];
                    bufferContainer.setBuffer(byArray);
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                    System.arraycopy(byArray5, 0, byArray, byArray3.length, byArray5.length);
                    byArray[1] = (byte)(byArray[1] - 128);
                    n3 = byArray5.length - 28;
                    byArray[3] = (byte)(n3 >> 24 & 0xFF);
                    byArray[4] = (byte)(n3 >> 16 & 0xFF);
                    byArray[8] = (byte)(n3 >> 8 & 0xFF);
                    byArray[9] = (byte)(n3 & 0xFF);
                    this.log.debugPartialByteArray("message dump", byArray, 0, n4);
                }
                if (!this.isJavaSPDefaultConnection() && bufferContainer instanceof TDPacketStream) {
                    this.processControlData((TDPacketStream)bufferContainer, tDStatement, bl);
                }
                int n2 = n4;
                Object var21_34 = null;
                this.m_bReadInProgress = bl2;
                if (!this.m_bReadInProgress) {
                    this.m_nRecoverableNetworkState = 2;
                }
                return n2;
            }
            catch (Throwable throwable) {
                Object var21_35 = null;
                this.m_bReadInProgress = bl2;
                if (!this.m_bReadInProgress) {
                    this.m_nRecoverableNetworkState = 2;
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException;
            SQLException sQLException2 = ErrorAnalyzer.analyzeIoError("Packet receive", this, iOException, bl3, bl);
            Object object = this.m_oSocketWriteErrorMutex;
            synchronized (object) {
                sQLException = this.m_exSocketWriteErrorChain;
                this.m_exSocketWriteErrorChain = null;
            }
            if (sQLException == null) {
                sQLException = sQLException2;
            } else {
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, TDStatement tDStatement, boolean bl) throws SQLException {
        Object object;
        Object object2;
        boolean bl2;
        boolean bl3;
        boolean bl4 = tDStatement != null && tDStatement.isFinalized();
        byte by = byArray[2];
        int n = TDNetworkIOIF.getTotalMsgLength(byArray);
        if (!(this.isJavaSPDefaultConnection() || !this.m_con.isRecoverableNPActive() || this.m_bReadInProgress || by != 5 && by != 6 && by != 13)) {
            this.m_abyLastSentMsg = new byte[n];
            System.arraycopy(byArray, 0, this.m_abyLastSentMsg, 0, this.m_abyLastSentMsg.length);
            this.m_nRecoverableNetworkState = 0;
        }
        boolean bl5 = !this.isJavaSPDefaultConnection() && this.m_con.getEncryptData();
        SecurityPolicyParcel securityPolicyParcel = !this.isJavaSPDefaultConnection() ? this.m_con.getSecurityPolicy() : null;
        boolean bl6 = securityPolicyParcel != null && securityPolicyParcel.getSecurityRequired() >= 1;
        int n2 = securityPolicyParcel != null ? securityPolicyParcel.getSecurityLevel() : 0;
        boolean bl7 = securityPolicyParcel != null && securityPolicyParcel.getConfidentialityRequired() >= 1;
        switch (by) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                bl3 = false;
                bl2 = false;
                break;
            }
            case 3: 
            case 4: {
                bl2 = bl3 = !this.isJavaSPDefaultConnection();
                break;
            }
            default: {
                bl3 = !this.isJavaSPDefaultConnection() && (bl5 || bl6) && this.m_con.getTeraEncrypt().canEncrypt();
                boolean bl8 = bl2 = bl3 && (bl5 || bl7);
            }
        }
        if (bl3) {
            this.log.debugPartialByteArray("message dump", byArray, 0, n);
            byte[] byArray2 = new byte[24];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            object2 = new byte[n - byArray2.length];
            System.arraycopy(byArray, byArray2.length, object2, 0, ((Object)object2).length);
            object = this.m_con.getTeraEncrypt().encrypt(n2, bl2, (byte[])object2, 0, ((Object)object2).length);
            byArray = new byte[((Object)object).length + byArray2.length];
            n = byArray.length;
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(object, 0, byArray, byArray2.length, ((Object)object).length);
            byArray[1] = (byte)(byArray[1] | 0x80);
            int n3 = ((Object)object).length - 28;
            byArray[3] = (byte)(n3 >> 24 & 0xFF);
            byArray[4] = (byte)(n3 >> 16 & 0xFF);
            byArray[8] = (byte)(n3 >> 8 & 0xFF);
            byArray[9] = (byte)(n3 & 0xFF);
        }
        this.log.debugPartialByteArray("Raw packet transmit", byArray, 0, n);
        try {
            this.acquireWriteLock();
            try {
                long l = System.currentTimeMillis();
                try {
                    this.outStream.write(byArray, 0, n);
                    this.outStream.flush();
                    Object var19_20 = null;
                    if (this.log.canLog(2)) {
                        this.log.timing("Wrote " + TDNetworkIOIF.messageTitle(byArray, " ") + "message, " + n + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                }
                catch (Throwable throwable) {
                    Object var19_21 = null;
                    if (this.log.canLog(2)) {
                        this.log.timing("Wrote " + TDNetworkIOIF.messageTitle(byArray, " ") + "message, " + n + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                    throw throwable;
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
        catch (IOException iOException) {
            object2 = ErrorAnalyzer.analyzeIoError("Packet transmit", this, iOException, bl4, bl);
            object = this.m_oSocketWriteErrorMutex;
            synchronized (object) {
                if (this.m_exSocketWriteErrorChain == null) {
                    this.m_exSocketWriteErrorChain = object2;
                } else {
                    this.m_exSocketWriteErrorChain.setNextException((SQLException)object2);
                }
            }
        }
    }

    public static int getMsgBodyLength(byte[] byArray) {
        return (UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 3)) << 16) + UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 8));
    }

    public static int getTotalMsgLength(byte[] byArray) {
        return 52 + TDNetworkIOIF.getMsgBodyLength(byArray);
    }

    private static String messageTitle(byte[] byArray, String string) {
        boolean bl = byArray.length >= 52;
        String string2 = bl ? WireProtocol.messageKind(byArray[2]) : null;
        String string3 = bl ? WireProtocol.messageClass(byArray[1] & 0x7F) : null;
        return string2 != null && string3 != null ? string2 + " " + string3 + string : "";
    }

    public boolean isJavaSPDefaultConnection() {
        return this.m_sOriginalHostName == null;
    }

    public boolean isClosed() {
        return this.isJavaSPDefaultConnection() ? this.m_bClosedJavaSPDefaultConnection : this.socket == null || this.socket.isClosed();
    }

    public void close() {
        if (this.isJavaSPDefaultConnection()) {
            this.m_bClosedJavaSPDefaultConnection = true;
            return;
        }
        this.closeSocket(false);
    }

    private void closeSocket(boolean bl) {
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                try {
                    this.socket.setSoLinger(true, 0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void acquireReadLock() throws SQLException {
        this.readLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    private void acquireWriteLock() throws SQLException {
        this.writeLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void releaseReadLock() {
        this.readLock.release();
    }

    private void releaseWriteLock() {
        this.writeLock.release();
    }

    public Log getLog() {
        return this.log;
    }

    private static void waitForThreadDeath(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int processReconnect(IOException iOException, BufferContainer bufferContainer, int n, TDStatement tDStatement, boolean bl) throws SQLException {
        SQLException sQLException;
        void var8_11;
        int n2;
        Object object;
        TDPacket tDPacket = this.m_con.createPacket(1);
        this.m_bReconnectInProgress = true;
        try {
            int n3;
            int sessionStatusResponseParcel;
            int bl3;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Read message failed; will attempt to reconnect after closing socket due to: " + iOException);
            }
            if ((bl3 = ((URLParameters)(object = this.m_con.getURLParameters())).getReconnectCount()) == 0) {
                sessionStatusResponseParcel = 11;
            }
            if ((n3 = ((URLParameters)object).getReconnectInterval()) == 0) {
                n3 = 30;
            }
            n2 = 1;
            while (true) {
                block34: {
                    this.closeSocket(true);
                    ++this.m_nReconnectAttempts;
                    if (n2 > 1) {
                        if (this.log.canLog(2)) {
                            this.log.timing("Reconnect attempt " + n2 + " of " + sessionStatusResponseParcel + " waiting " + n3 + " seconds for connection: " + this);
                        }
                        Utility.sleepForSeconds(n3);
                    }
                    this.log.error("Reconnect attempt " + n2 + " of " + sessionStatusResponseParcel + " for connection: " + this);
                    try {
                        this.createSocketConnection();
                    }
                    catch (SQLException sQLException2) {
                        if (n2 == sessionStatusResponseParcel) {
                            throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException2);
                        }
                        break block34;
                    }
                    GenericLogonController.Reconnect sQLException3 = new GenericLogonController.Reconnect();
                    sQLException3.nAuthenticationNonce = this.m_con.readAuthenticationNonce();
                    sQLException3.nRequestNumber = this.m_con.getCurrentRequestNum();
                    GenericLogonController genericLogonController = new GenericLogonController(this.m_con);
                    genericLogonController.setReconnect(sQLException3);
                    try {
                        genericLogonController.run();
                        break;
                    }
                    catch (SQLException sQLException4) {
                        this.close();
                        if (n2 != sessionStatusResponseParcel && "08S01".equals(sQLException4.getSQLState())) break block34;
                        throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException4);
                    }
                }
                n2 += 1;
            }
            try {
                tDPacket.getBuffer().readStream(this, tDStatement, 0, true);
            }
            catch (SQLException sQLException5) {
                this.close();
                throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException5);
            }
        }
        finally {
            this.m_bReconnectInProgress = false;
        }
        tDPacket.initParcelFactory(this.m_con);
        object = null;
        Object var8_10 = null;
        Object object2 = null;
        block15: while ((object2 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object2).getFlavor()) {
                case 12: {
                    continue block15;
                }
                case 9: 
                case 49: {
                    object = (ErrorParcel)object2;
                    continue block15;
                }
                case 195: {
                    SessionStatusResponseParcel sessionStatusResponseParcel = (SessionStatusResponseParcel)object2;
                    continue block15;
                }
            }
            throw TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object2).getFlavor())));
        }
        object2 = null;
        int n4 = n2 = var8_11 != null && this.m_abyLastSentMsg != null ? 1 : 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("processReconnect: errorParcel=" + object + " getCode=" + (object != null ? "" + ((ErrorParcel)object).getCode() : "n/a") + " sessStatResp=" + var8_11 + " m_abyLastSentMsg=" + this.m_abyLastSentMsg + " bAttemptRecoverableNP=" + (n2 != 0));
        }
        if (n2 != 0) {
            int n5;
            int n6;
            byte by = this.m_abyLastSentMsg[2];
            int n7 = ByteConverter.getInt(this.m_abyLastSentMsg, 32);
            int n8 = var8_11.getRedriveOrNewRequestOK();
            boolean bl2 = var8_11.getRequestState(n7) != null;
            boolean bl3 = false;
            if (n8 == 0 && by == 5 && this.m_abyLastSentMsg.length >= 54 && Parcel.trueFlavor((short)(n6 = ByteConverter.getShort(this.m_abyLastSentMsg, 52))) == 128 && this.m_abyLastSentMsg.length >= 52 + (n5 = Parcel.calculateHeaderLength(Parcel.isAPH((short)n6))) + 2) {
                short s = ByteConverter.getShort(this.m_abyLastSentMsg, 52 + n5);
                boolean bl4 = bl3 = s > 1;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("processReconnect: nLastSentRequestNumber=" + n7 + " nLastSentMsgKind=" + by + (by == 5 ? " (COPKINDSTART)" : "") + (by == 13 ? " (COPKINDELICIT)" : "") + " m_nRecoverableNetworkState=" + this.m_nRecoverableNetworkState + " nRedriveOrNewRequestOK=" + n8 + " bIsKnownRequest=" + bl2 + " bMultiTSRContinuation=" + bl3);
            }
            if (by == 5 && bl2 && n8 == 1) {
                this.log.debug("processReconnect: condition 1");
                this.sendElicitStartResp(tDStatement, bl, n7);
                return this.read(bufferContainer, n, tDStatement, bl);
            }
            if (by == 13 && bl2 && n8 == 1) {
                this.log.debug("processReconnect: condition 2");
                this.sendElicitStartResp(tDStatement, bl, n7);
                n6 = this.read(bufferContainer, n, tDStatement, bl);
                int n9 = n5 = n6 >= 52 && bufferContainer.getBuffer()[2] == 13 ? 1 : 0;
                if (n5 == 0) {
                    return n6;
                }
                this.sendUCAbort(tDStatement, bl, n7);
                this.read(bufferContainer, n, tDStatement, bl);
            } else {
                if (!(this.m_nRecoverableNetworkState != 0 || by != 5 && by != 6 || bl3)) {
                    this.log.debug("processReconnect: condition 3");
                    ByteConverter.putLong(this.m_abyLastSentMsg, 24, this.m_con.getAuthenticationNonce());
                    this.write(this.m_abyLastSentMsg, tDStatement, bl);
                    return this.read(bufferContainer, n, tDStatement, bl);
                }
                if (this.m_nRecoverableNetworkState == 1 && !bl2 && n8 == 1) {
                    this.log.debug("processReconnect: condition 4");
                    return 0;
                }
            }
            object2 = ErrorFactory.makeDriverJDBCException("TJ761", TDNetworkIOIF.messageTitle(this.m_abyLastSentMsg, ""));
        }
        SQLException sQLException6 = sQLException = object != null ? TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object).getMsg(), ((ErrorParcel)object).getCode())) : TDNetworkIOIF.makeReconnectException("TJ591", iOException, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("processReconnect: reconnectEx=" + sQLException + " exRecoveryNotPossible=" + object2);
        }
        if (object2 != null) {
            sQLException.setNextException((SQLException)object2);
        }
        throw sQLException;
    }

    private static SQLException makeReconnectException(String string, IOException iOException, SQLException sQLException) {
        SQLException sQLException2 = ErrorFactory.makeDriverJDBCException(string);
        sQLException2.initCause(iOException);
        if (sQLException != null) {
            sQLException2.setNextException(sQLException);
        }
        return sQLException2;
    }

    private void processControlData(TDPacketStream tDPacketStream, TDStatement tDStatement, boolean bl) throws SQLException {
        LanHeader lanHeader = new LanHeader(tDPacketStream);
        int n = lanHeader.getControlDataLength();
        if (n == 0) {
            return;
        }
        int n2 = 52 + lanHeader.getMsgLength();
        int n3 = n2 - n;
        block11: while (n3 < n2) {
            Parcel parcel;
            short s = Parcel.trueFlavor(tDPacketStream.getShort(n3));
            tDPacketStream.position(n3);
            switch (s) {
                case 197: {
                    this.log.debug("processControlData: creating a ControlDataStartParcel");
                    parcel = new ControlDataStartParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (((ControlDataStartParcel)parcel).getControlDataLength() == n) continue block11;
                    this.log.error("ControlData length mismatch: Message header value: " + n + " ControlDataStartParcel value:" + ((ControlDataStartParcel)parcel).getControlDataLength());
                    continue block11;
                }
                case 198: {
                    this.log.debug("processControlData: creating a ControlDataEndParcel");
                    parcel = new ControlDataEndParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (((ControlDataEndParcel)parcel).getControlDataLength() == n) continue block11;
                    this.log.error("ControlData length mismatch: Message header value: " + n + " ControlDataEndParcel value:" + ((ControlDataEndParcel)parcel).getControlDataLength());
                    continue block11;
                }
                case 200: {
                    this.log.debug("processControlData: creating a RecoverableProtocolParcel");
                    parcel = new RecoverableProtocolParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    continue block11;
                }
                case 196: {
                    this.log.debug("processControlData: creating a ContinueContextParcel");
                    parcel = new ContinueContextParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (tDStatement == null) continue block11;
                    tDStatement.setContinueContext((ContinueContextParcel)parcel);
                    continue block11;
                }
                case 201: {
                    this.log.debug("processControlData: creating a RedriveParcel");
                    parcel = new RedriveParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRedrive((RedriveParcel)parcel);
                    continue block11;
                }
                case 204: {
                    this.log.debug("processControlData: creating a RedriveSupportedParcel");
                    parcel = new RedriveSupportedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRedriveSupported((RedriveSupportedParcel)parcel);
                    continue block11;
                }
                case 214: {
                    this.log.debug("processControlData: creating a RecoverableNPSupportedParcel");
                    parcel = new RecoverableNPSupportedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRecoverableNPSupported((RecoverableNPSupportedParcel)parcel);
                    continue block11;
                }
                case 202: {
                    this.log.debug("processControlData: creating a AckRequestedParcel");
                    parcel = new AckRequestedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_nRecoverableNetworkState = 1;
                    this.sendAck(tDStatement, bl, lanHeader.getRequestNo());
                    continue block11;
                }
                case 206: {
                    this.log.debug("processControlData: creating a SecurityPolicyParcel");
                    parcel = new SecurityPolicyParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifySecurityPolicy((SecurityPolicyParcel)parcel);
                    continue block11;
                }
            }
            this.log.debug("processControlData: unknown parcel");
            parcel = new UnknownParcel(tDPacketStream, this.m_con);
            n3 += parcel.getLength();
        }
    }

    private void sendAck(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)2);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)15);
        this.sendPacket(tDPacket, tDStatement, bl);
        tDPacket.clear();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)6);
        tDPacket.addParcel(new CancelParcel(this.m_con));
        this.sendPacket(tDPacket, tDStatement, bl);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this, tDStatement, 0, bl);
    }

    private void sendElicitStartResp(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)14);
        int n2 = 0;
        ControlDataStartParcel controlDataStartParcel = new ControlDataStartParcel(this.m_con);
        n2 += controlDataStartParcel.getLength();
        RecoverableProtocolParcel recoverableProtocolParcel = new RecoverableProtocolParcel(this.m_con);
        n2 += recoverableProtocolParcel.getLength();
        ControlDataEndParcel controlDataEndParcel = new ControlDataEndParcel(this.m_con);
        controlDataStartParcel.setControlDataLength(n2 += controlDataEndParcel.getLength());
        controlDataEndParcel.setControlDataLength(n2);
        tDPacket.addParcel(controlDataStartParcel);
        tDPacket.addParcel(recoverableProtocolParcel);
        tDPacket.addParcel(controlDataEndParcel);
        tDPacket.setControlDataLength(n2);
        this.sendPacket(tDPacket, tDStatement, bl);
    }

    private void sendUCAbort(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)7);
        tDPacket.addParcel(new AbortUCParcel(this.m_con));
        this.sendPacket(tDPacket, tDStatement, bl);
    }

    public void sendPacket(TDPacket tDPacket, TDStatement tDStatement, boolean bl) throws SQLException {
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this, tDStatement, bl);
    }

    public static class WorkerThreadList {
        private List m_listCompletedThreads = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List waitForThreads(long l) {
            boolean bl = false;
            try {
                long l2 = System.currentTimeMillis();
                while (this.m_listCompletedThreads.isEmpty()) {
                    long l3;
                    if (l == 0L) {
                        l3 = 0L;
                    } else {
                        long l4 = l2 + l;
                        l3 = l4 - System.currentTimeMillis();
                        if (l3 <= 0L) break;
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                List list = this.m_listCompletedThreads;
                this.m_listCompletedThreads = new ArrayList();
                List list2 = list;
                return list2;
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public synchronized void reportCompletion(Thread thread) {
            this.m_listCompletedThreads.add(thread);
            this.notify();
        }
    }

    public static class ConnectThread
    extends Thread {
        public Socket m_socket;
        public InetSocketAddress m_isa;
        public int m_nTimeoutMs;
        private WorkerThreadList m_workerThreadList;
        public Throwable m_ex;
        public Date m_dateFailure;
        public long m_nElapsedTime;

        public ConnectThread(Socket socket, InetSocketAddress inetSocketAddress, int n, WorkerThreadList workerThreadList) {
            this.m_socket = socket;
            this.m_isa = inetSocketAddress;
            this.m_nTimeoutMs = n;
            this.m_workerThreadList = workerThreadList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            try {
                this.m_socket.connect(this.m_isa, this.m_nTimeoutMs);
            }
            catch (Throwable throwable) {
                this.m_ex = throwable;
                this.m_dateFailure = new Date();
            }
            finally {
                this.m_nElapsedTime = System.currentTimeMillis() - l;
            }
            this.m_workerThreadList.reportCompletion(this);
        }
    }

    public static class Lookup {
        private GenericTeradataConnection m_conn;
        private String m_sHostName;
        private boolean m_bLookupDone = false;
        private InetAddress[] m_aAddrs = null;
        private UnknownHostException m_exUnk = null;
        private SecurityException m_exSec = null;

        public Lookup(GenericTeradataConnection genericTeradataConnection, String string) {
            this.m_conn = genericTeradataConnection;
            this.m_sHostName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLookup() throws SQLException {
            block10: {
                if (this.m_bLookupDone) {
                    return;
                }
                this.m_bLookupDone = true;
                this.m_conn.checkRemainingLoginTime();
                long l = System.currentTimeMillis();
                try {
                    try {
                        this.m_aAddrs = InetAddress.getAllByName(this.m_sHostName);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.m_exUnk = unknownHostException;
                        Object var5_3 = null;
                        if (this.m_conn.getLog().canLog(2)) {
                            this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                        break block10;
                    }
                    catch (SecurityException securityException) {
                        this.m_exSec = securityException;
                        Object var5_4 = null;
                        if (this.m_conn.getLog().canLog(2)) {
                            this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                    }
                    Object var5_2 = null;
                    if (this.m_conn.getLog().canLog(2)) {
                        this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.m_conn.getLog().canLog(2)) {
                        this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                    throw throwable;
                }
            }
        }

        public boolean isLiteralIpAddress() throws SQLException {
            if (this.m_sHostName.length() > 0 && Character.isLetter(this.m_sHostName.charAt(0)) && this.m_sHostName.indexOf(58) < 0) {
                return false;
            }
            this.doLookup();
            return this.m_aAddrs != null && this.m_aAddrs.length > 0 && this.m_aAddrs[0].toString().startsWith("/");
        }

        public InetAddress[] getAddresses() throws SecurityException, SQLException, UnknownHostException {
            this.doLookup();
            if (this.m_exUnk != null) {
                throw this.m_exUnk;
            }
            if (this.m_exSec != null) {
                throw this.m_exSec;
            }
            return this.m_aAddrs;
        }
    }
}

