/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdk14.JDK14_Console_Connection;
import com.teradata.jdbc.jdk14.JDK14_FastExportManager_Connection;
import com.teradata.jdbc.jdk14.JDK14_FastExport_Connection;
import com.teradata.jdbc.jdk14.JDK14_FastLoadCSV_Connection;
import com.teradata.jdbc.jdk14.JDK14_FastLoadManager_Connection;
import com.teradata.jdbc.jdk14.JDK14_FastLoad_Connection;
import com.teradata.jdbc.jdk14.JDK14_Monitor_Connection;
import com.teradata.jdbc.jdk14.JDK14_Raw_Connection;
import com.teradata.jdbc.jdk14.JDK14_SQL_Connection;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionFactory {
    private static ConnectionFactory sm_factory = ConnectionFactory.getConnectionFactoryForJavaVersion();

    protected ConnectionFactory() {
    }

    private static int parseUnsignedByte(String string) {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int getJavaVersion() {
        int n;
        int n2;
        String string = System.getProperty("java.version");
        if (string != null && (n2 = string.indexOf(46)) > 0 && (n = string.indexOf(46, n2 + 1)) > n2 + 1) {
            int n3 = ConnectionFactory.parseUnsignedByte(string.substring(0, n2));
            int n4 = ConnectionFactory.parseUnsignedByte(string.substring(n2 + 1, n));
            if (n3 > 0 && n4 >= 0) {
                return n3 * 1000 + n4;
            }
        }
        return 1004;
    }

    private static ConnectionFactory getConnectionFactoryForJavaVersion() {
        try {
            if (ConnectionFactory.getJavaVersion() >= 1006) {
                return (ConnectionFactory)Class.forName("com.teradata.jdbc.jdk6.JDK6ConnectionFactory").newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ConnectionFactory();
    }

    public Connection constructSQLConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_SQL_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructConsoleConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_Console_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructFastExportConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_FastExport_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructFastExportManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_FastExportManager_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructFastLoadConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_FastLoad_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructFastLoadManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_FastLoadManager_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructFastLoadCSVConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_FastLoadCSV_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructMonitorConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_Monitor_Connection(string, string2, string3, uRLParameters);
    }

    public Connection constructRawConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return new JDK14_Raw_Connection(string, string2, string3, uRLParameters);
    }

    public static Connection createConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        return ConnectionFactory.createConnection(false, string, string2, string3, uRLParameters);
    }

    public static Connection createConnection(boolean bl, String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        if (bl || uRLParameters.getType().equalsIgnoreCase("DEFAULT")) {
            if (uRLParameters.getPartition().equalsIgnoreCase("DBC/SQL")) {
                return sm_factory.constructSQLConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("FASTLOAD")) {
                return sm_factory.constructFastLoadConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("EXPORT")) {
                return sm_factory.constructFastExportConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("MONITOR")) {
                return sm_factory.constructMonitorConnection(string, string2, string3, uRLParameters);
            }
            if (uRLParameters.getPartition().equalsIgnoreCase("DBCCONS")) {
                return sm_factory.constructConsoleConnection(string, string2, string3, uRLParameters);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ403", uRLParameters.getPartition());
        }
        if (uRLParameters.getType().equalsIgnoreCase("FASTLOAD")) {
            return sm_factory.constructFastLoadManagerConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("FASTLOADCSV")) {
            return sm_factory.constructFastLoadCSVConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("FASTEXPORT")) {
            return sm_factory.constructFastExportManagerConnection(string, string2, string3, uRLParameters);
        }
        if (uRLParameters.getType().equalsIgnoreCase("RAW")) {
            return sm_factory.constructRawConnection(string, string2, string3, uRLParameters);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ456", uRLParameters.getType());
    }
}

