/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.DeferredClob;
import com.teradata.jdbc.LocatorLob;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobAsciiStream;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobOutputStream;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobReader;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobWriter;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class LocatorClob
extends LocatorLob {
    public LocatorClob(TDSession tDSession, long l, byte[] byArray, boolean bl) {
        this.m_sColumnName = "cval";
        this.m_session = tDSession;
        this.length = l;
        this.locator = byArray;
        this.m_bUpdatable = bl;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        return new ClobAsciiStream(this.m_session, this.locator, this.getSlobData(), 424, this.length);
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        return new ClobReader(this.m_session, this.locator, this.getSlobData(), 424, this.length);
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        if (l < 1L || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "getSubString");
        }
        if (l + (long)n > this.length() + 1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "getSubString");
        }
        if (n == 0) {
            return "";
        }
        SQLException sQLException = null;
        LobStream lobStream = new LobStream(this.m_session, this.locator, this.getSlobData(), 424, n);
        try {
            String string = Decoder.decodeClob(this.m_session, lobStream.getBytes(l, n));
            return string;
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            throw sQLException;
        }
        finally {
            try {
                lobStream.internalClose();
            }
            catch (SQLException sQLException3) {
                throw Utility.chainSQLExceptions(sQLException, sQLException3);
            }
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "position");
    }

    public long position(String string, long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "position");
    }

    public void truncate(long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.m_bUpdatable) {
            throw ErrorFactory.makeDriverJDBCException("TJ795");
        }
        if (l < 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.truncate");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Clob.truncate");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.truncate");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = SUBSTRING(? FROM 1 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)424);
        this.setStaleLocator(true);
        tDPreparedStatement.close();
        this.close();
        this.setSlobData(null);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.m_bUpdatable) {
            throw ErrorFactory.makeDriverJDBCException("TJ795");
        }
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setCharacterStream");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Clob.setCharacterStream");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setCharacterStream");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)424);
        this.setStaleLocator(true);
        tDPreparedStatement.close();
        this.close();
        this.setSlobData(null);
        return new ClobWriter(this);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.m_bUpdatable) {
            throw ErrorFactory.makeDriverJDBCException("TJ795");
        }
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setAsciiStream");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Clob.setAsciiStream");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setAsciiStream", String.valueOf(l));
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") WHERE id=" + this.getWritableLobId();
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)424);
        this.setStaleLocator(true);
        tDPreparedStatement.close();
        this.close();
        this.setSlobData(null);
        return new ClobOutputStream(this, this.m_session);
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        byte[] byArray;
        String string2;
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        if (!this.m_bUpdatable) {
            throw ErrorFactory.makeDriverJDBCException("TJ795");
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Clob.setString");
        }
        if (n < 0 || n2 < 0 || l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setString");
        }
        if (n + n2 > string.length()) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "Clob.setString");
        }
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string3 = this.initWritableLobs("Clob.setString");
        if (this.m_session != null) {
            string2 = "UPDATE " + string3 + " SET " + this.m_sColumnName + " = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? || SUBSTRING(? FROM " + (l + (long)n2) + " FOR " + this.length() + ") WHERE id=" + this.getWritableLobId();
            byArray = Encoder.encodeClob(this.m_session, string.substring(n, n2 + n), l);
            if (byArray.length > 64000) {
                throw ErrorFactory.makeDriverJDBCException("TJ515", "String", String.valueOf(byArray.length));
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setString()");
        }
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)424, byArray, 449);
        this.setStaleLocator(true);
        tDPreparedStatement.close();
        this.close();
        this.setSlobData(null);
        return n2;
    }

    public int setString(long l, String string) throws SQLException {
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Clob.setString");
        }
        return this.setString(l, string, 0, string.length());
    }

    public void writeStream(long l, Reader reader, int n) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator();
        }
        String string = this.initWritableLobs("Clob.writeStream");
        if (this.m_session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.writeStream()");
        }
        String string2 = "UPDATE " + string + " SET " + this.m_sColumnName + " = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? WHERE id=" + this.getWritableLobId();
        int n2 = this.m_session.registerDeferredLob(new DeferredClob(reader, n, -1, -1, null, this.m_session, false));
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)this.m_session.prepareStatement(string2));
        tDPreparedStatement.updateLob(this.locator, (short)424, n2, 421, n);
        this.setStaleLocator(true);
        tDPreparedStatement.close();
        this.close();
        this.setSlobData(null);
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getCharacterStream(long,long)");
    }
}

